'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filter_tools.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/05 13:06:54 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Helper functions for filternames
'*
'*******************************************************************************
'**
' #1 hGetFilter680FromUNO         ' Retrieve a localized filtername from UNO
' #1 hFindUNOTemplateInFilterList ' Take UNO template filter and find it in FileSave
'**
'\******************************************************************************

function hGetFilter680FromUNO( bTemplate as boolean ) as string

    '///<H3>Retrieve a localized filtername from UNO</H3>

    ' bTemplate: If TRUE the name of the TEMPLATE is returned otherwise
    '            we get the normal file filter.
    ' For now there is no template for CHART and MATH, you will get an error
    ' when trying to get them.
    ' The searchstringsd are retrieved from the Filter.xcu-files from the 
    ' OpenOffice.org installation.

    const CFN = "hGetFilter680FromUNO::"
    
    dim oOpenUNOService as object
    dim oUnoService as object

    dim cApp as string
        cApp = ucase( gApplication )

    dim sFilter as string 
    dim iFilter as integer
    dim oFilter as object

    ' note: No templates for MATH and CHART
    if ( bTemplate ) then
        select case cApp
        case "WRITER"    : sFilter = "writer8_template"
        case "CALC"      : sFilter = "calc8_template"
        case "DRAW"      : sFilter = "draw8_template"
        case "IMPRESS"   : sFilter = "impress8_template"
        case "MASTERDOC" : sFilter = "writerglobal8_template"
        case else        : warnlog( CFN & "Undefined filter: " & cApp )
                           hGetFilter680FromUNO() = ""
                           exit function
        end select
    else
        select case cApp
        case "WRITER"    : sFilter = "writer8"
        case "CALC"      : sFilter = "calc8"
        case "DRAW"      : sFilter = "draw8"
        case "IMPRESS"   : sFilter = "impress8"
        case "MASTERDOC" : sFilter = "writerglobal8"
        case "MATH"      : sFilter = "math8"
        case "CHART"     : sFilter = "chart8"
        case else        : warnlog( CFN & "Undefined filter: " & cApp )
                           hGetFilter680FromUNO() = ""
                           exit function
        end select
    endif

    printlog( CFN & "Retrieving filter for: " & sFilter )        

    oUNOService = GetUNOApp
    oOpenUNOService = oUnoService.createInstance( "com.sun.star.document.FilterFactory" )
    oFilter = oOpenUNOService.getByName( sFilter )

    for iFilter = 0 to ubound( oFilter )
        if ( oFilter( iFilter ).Name = "UIName" ) then
             sFilter = oFilter( iFilter ).Value
        endif
    next iFilter

    printlog( CFN & "Requested Filtername is: " & sFilter )
    hGetFilter680FromUNO() = sFilter

end function

'*******************************************************************************

function hFindUNOTemplateInFilterList( sFilter as string ) as integer

    '///<h3>Function to find a TEMPLATE filter in the filter list</h3>
    ' Input: Filtername as provided by hGetFilter680FromUNO()
    
    ' This function is required beacuse UNO returns the filtername without
    ' the extension. The filters in the Filterlist always consist of the
    ' UNO filtername + " (.xxx). The real filtername is retrieved using 
    ' substring-matching. 
    ' Warning: The Function should only be used to find the TEMPLATE filters
    ' If sFilter is a "normal" documenttype the function might select the
    ' "normal" filter or the template at random.
    
    const CFN = "hFindUNOTemplateInFilterList::"

    dim iFilterPos as integer
    dim iFilterCount as integer
    dim iCurrentFilter as integer
    dim cCurrentFilter as string
    dim brc as boolean
        brc = false
    
    Kontext "SpeichernDlg"
    iFilterCount = DateiTyp.getItemCount()
    
    for iCurrentFilter = 1 to iFilterCount
    
        DateiTyp.select( iCurrentFilter )
        cCurrentFilter = DateiTyp.getSelText()
    
        if ( instr( cCurrentFilter , sFilter ) <> 0 ) then
            brc = true
            exit for
        endif
        
    next iCurrentFilter
    
    if ( brc ) then
        printlog( CFN & "Using filter: " & cCurrentFilter )
        hFindUNOTemplateInFilterList() = iCurrentFilter
    else
        printlog( CFN & "No filter found that matches given criteria" )
        hFindUNOTemplateInFilterList() = 0
    endif
    
end function
