'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: fileoperations.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: jsk $ $Date: 2006/08/16 07:04:11 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( extended tests )
'*
'*******************************************************************************
'**
' #1 hSaveLoadDelSuccess      ' Save, Reload and delete a file
' #1 hLoadFileExpectSuccess   ' Try to load a file - success expected
' #1 hLoadFileExpectFailure   ' Try to read a file - failure expected
' #1 hSaveFileExpectSuccess   ' Try to save a file - success expected
' #1 hSaveFileExpectFailure   ' Try to save a file - failure expected
' #1 hCreateNewDirectory      ' Create a new directory using FileOpen
' #1 hDeleteFileViaFileOpen   ' Delete a file via FileOpen dialog
' #1 hGetFileCountViaFileOpen ' Get the number of files in the current workdir
' #1 hNameGen_append          ' Generate filenames with ASCII/UNICODE chars
' #1 hNameGen_lead            ' Generate filenames with ASCII/UNICODE chars
' #1 hCopyDir                 ' Copy a directory 
'**
'\******************************************************************************

function hSaveLoadDelSuccess( cFile as string ) as integer

    '///<h3>Successfully save, close, load, close and delete a file</h3>
    '///<i>Uses</i>: framework\tools\stringtools.inc<br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Filename incl. extension (string)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcode (integer)</li>
    '///<ul>
    '///+<li>0 = all ok</li>
    '///+<li>1 = Saving failed</li>
    '///+<li>2 = Closing the file failed</li> 
    '///+<li>3 = Reloading failed</li>
    '///+<li>4 = Closing the file failed</li>
    '///+<li>5 = Deleting failed</li>
    '///+<li>6 = Post operation error</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    dim cMsg as string
    dim brc as boolean
    dim irc as integer
    const CFN = "hSaveLoadDelSuccess::"

    '///+<li>Save the current file, overwriting existing</li>
    brc = hSaveFileExpectSuccess( cFile , TRUE ) ' save and overwrite
    irc = 1
    
    '///+<li>Close the file</li>
    if ( brc ) then
        brc = hDestroyDocument()
        irc = 2
    else
         qaerrorlog( CFN & "hSaveFileExpectSuccess claims to have failed" )
    endif
    
    '///+<li>Reload the file</li>
    if ( brc ) then
        brc = hLoadFileExpectSuccess( cFile )
        irc = 3
    endif
    
    '///+<li>Close the document</li>
    if ( brc ) then
        brc = hDestroyDocument()
        irc = 4
    endif
    
    '///+<li>Delete the file via FileOpen</li>
    if ( brc ) then
        brc = hDeleteFileViaFileOpen( cFile )
        irc = 5
    endif

    '///+<li>Close possible Messagebox (#i33946#)</li>
    if ( brc ) then
        kontext "active"
        if ( active.exists() ) then
            cMsg = active.getText()
            cMsg = hRemoveLineBreaks( cMsg )
            printlog( CFN & "Unexpected message: " & cMsg )
            qaerrorlog( "#i33946# - message when deleting last document in folder" )
            active.ok()
            brc = false
            irc = 6
        endif
    endif
    
    if ( brc ) then
        printlog( CFN & "Successfully created, saved, reloaded and deleted file" )
        irc = 0
    else
        qaerrorlog( CFN & "Failed with rc=" & irc )
    endif
    
    '///+<li>Return errorcode</li>
    hSaveLoadDelSuccess() = irc
    '///</ul>

end function

'*******************************************************************************

function hLoadFileExpectSuccess( fpath as string ) as boolean

    '///<h3>Load a file where failure is expected</h3>
    '///<i>Uses</i>: framework\tools\stringtools.inc<br><br>
    '///<i>This function is quite similar to hLoadFile but does much less
    '///+ errorhandling so the information of the type of failure is a little
    '///+ more exact</i><br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Filename incl. extension (string)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE = File was loaded without problems</li>
    '///+<li>FALSE = Any error</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    dim brc as boolean
        brc = true

    const CFN = "hLoadFileExpectSuccess::"

    '///+<li>Click FileOpen (or use the menu)</li>
    FileOpen    

    '///+<li>Enter the filename (with extension)</li>
    'printlog( " - Type the filepath/name into the entryfield" )
    Kontext "OeffnenDLG"
    DateiName.setText( fpath )

    '///+<li>Click &quot;Open&quot;</li>
    'printlog( " - Click 'Open'" )
    oeffnen.click()    

    '///+<li>Watch out for an unexpected messagebox<br>
    Kontext "Active"
    if ( Active.Exists() ) then
        cMsg = active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        printlog( "Unexpected active: " & cMsg )
        Active.OK()

        Kontext "OeffnenDLG"
        OeffnenDLG.cancel()
        brc = false
    endif

    '///+recover in case of error so the test has a chance to continue</li>
    ' try to recover in case of failure so the test can continue.
    Kontext "OeffnenDLG"
    if ( Oeffnen.Exists() ) then
        warnlog( "The file was not opened, it doesn't appear to exist" )
        OeffnenDLG.cancel()
        brc = false
    endif

    '///+<li>Verify that the document has been loaded</li>
    if ( brc ) then
        IsItLoaded

        if ( getDocumentCount < 2 ) then
            warnlog( "Document missing" )
            brc = false
        endif
    endif

    if ( brc ) then
        printlog( CFN & "File loaded successfully" )
    else
        qaerrorlog( CFN & "File not loaded correctly" )
    endif
    
    '///+<li>Return the errorcode</li>
    hLoadFileExpectSuccess() = brc
    '///</ul>
    
end function

'*******************************************************************************

function hLoadFileExpectFailure( fpath as string ) as boolean

    '///<h3>Load a file where failure is expected</h3>
    '///<i>Uses</i>: framework\tools\stringtools.inc<br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Filename incl. extension (string)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE = There was an error loading the file (as expected)</li>
    '///+<li>FALSE = The file was loaded without problems/any other error</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    dim brc as boolean
        brc = true
    dim cMsg as string

    printlog( " *  Trying (load-failure): " & fpath )

    '///+<li>Click FileOpen</li>
    FileOpen    
    Kontext "OeffnenDLG"

    '///+<li>Enter filepath</li>
    DateiName.setText( convertpath( fpath ) )

    '///+<li>Click &quot;Open&quot;</li>
    oeffnen.click()

    '///+<li>Close the expected warning dialog, return to FileOpen</li>
    Kontext "Active"
    if Active.Exists() then
        cMsg = active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        printlog( "Expected active: " & cMsg )
        active.ok()

        Kontext "OeffnenDLG"
        OeffnenDLG.cancel()
        brc = true
    endif

    '///+<li>Verify that we are on FileOpen dialog, set errorcondition true</li>
    if ( brc ) then
        Kontext "OeffnenDLG"
        if ( Oeffnen.Exists() ) then
            printlog( " - File is not loaded, still in File/Open. Good, cancelling" )
            OeffnenDLG.cancel()
            brc = true
        else
            brc = false
        endif
    endif
    
    '///+<li>If the document is loaded, set errorcondition to false</li>
    if ( not brc ) then
        IsItLoaded
        warnlog( "The file appears to have loaded correctly. Not good" )
    
        '///+<li>Click away possible messagebox to recover</li>
        Kontext "Active"
        if ( active.exists() ) then
            cMsg = active.getText()
            cMsg = hRemoveLineBreaks( cMsg )
            printlog( "Unexpected active: " & cMsg )
            Active.OK()
    
        endif
    endif 
    
    '///+<li>Return errorcondition</li>
    hLoadFileExpectFailure() = brc
    '///</ul>
    
end function

'*******************************************************************************

function hSaveFileExpectSuccess( fpath as string , bReplace as boolean ) as boolean

    '///<h3>Save a file with optional replace where success is expected</h3>
    '///<i>Uses</i>: framework\tools\stringtools.inc<br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Filename incl. extension (string)</li>
    '///+<li>Replace file (boolean)</li>
    '///<ul>
    '///+<li>TRUE = Replace the file</li>
    '///+<li>FALSE = Do not replace the file</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE = There was an error loading the file (as expected)</li>
    '///+<li>FALSE = The file was loaded without problems/any other error</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    const CFN = "hSaveFileExpectSuccess::" 
    dim brc as boolean
        brc = true
    dim cMsg as string

    '///+<li>Open a new document</li>
    hCreateDocument()

    '///+<li>Click &quot;Save As...&quot;</li>
    FileSaveAs    'sleep( ICWAIT )

    '///+<li>Enter a filename (with extension)</li>
    'printlog( " - Enter filename" )
    Kontext "SpeichernDlg"
    Dateiname.setText( fpath )

    '///+<li>Uncheck automatic filename extension</li>
    'printlog( " - Uncheck automatic filename extension" )
    automatischedateinamenserweiterung.uncheck()

    '///+<li>Click &quot;Save&quot;</li>
    'printlog( " - Press 'Save'" )
    speichern.click()

    sleep( 2 )

    '///+<li>If the file exists, say &quot;yes&quot; to replace it</li>
    if ( bReplace = true ) then
        Kontext "Active"
        if ( active.exists() ) then
            printlog( " - Overwrite file" )
            active.yes()
        endif
    endif

    '///+<li>Handle any unexpected errormessage with &quot;OK&quot;</li>
    Kontext "Active"
    if ( active.exists() ) then
        cMsg = active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        printlog( "Unexpected active: " & cMsg )
        brc = false
        sleep( 2 )

        active.ok()
    endif

    '///+<li>Verify that at least two documents are open</li>
    if( getDocumentCount < 2 ) then        
        warnlog( "Document missing" )
        brc = false
    endif
    
    if ( brc ) then
        printlog( CFN & "File saved successfully" )
    else
        qaerrorlog( CFN & "Failed to save the file" )
    endif

    hSaveFileExpectSuccess() = brc
    
    '///</ul>

end function

'*******************************************************************************

function hSaveFileExpectFailure( fpath as string , errortype as integer ) as boolean

    '///<h3>Save a file where failure is expected</h3>
    '///<i>Uses</i>: framework\tools\stringtools.inc<br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Filename incl. extension (string)</li>
    '///+<li>Errortype (Integer). Valid options are:</li>
    '///<ul>
    '///+<li>0 = Invalid characters in string</li>
    '///+<li>1 = Filename is interpreted as device</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE = There was an error saving the file (as expected)</li>
    '///+<li>FALSE = The file was saved without problems/any other error</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    ' currently we have two different kinds of failure
    ' 1. File cannot be saved due to invalid character(s)
    '    This is the default, errortype = 0
    ' 2. File cannot be saved because the given name is interpreted as device
    '    This is errortype = 1
    ' This sequence tries to save a document with an invalid name. The errormsg
    ' is closed, the filedialog cancelled and the file closed. We should be back
    ' to "The first doc" after completion

    dim brc as boolean
        brc = false
    dim cMsg as string

    '///+<li>Open an new document</li>
    hCreateDocument()
    
    '///+<li>Click &quot;Save As;&quot;</li>
    printlog( " * Trying (save-failure): " & fpath  )
    FileSaveAs
    
    '///+<li>Enter the filename</li>
    Kontext "SpeichernDlg"
    Dateiname.setText( fpath )

    '///+<li>Uncheck automatic filename extension</li>
    'printlog( " - Uncheck automatic filename extension" )
    automatischedateinamenserweiterung.uncheck()

    '///+<li>Click &quot;Save&quot;</li>
    speichern.click()
    sleep( 1 )

    '///<ul>
    '///+<li>Handle invalid characters (Errormessages)</li>
    if ( errortype = 1 ) then

        Kontext "Active"
        if ( Active.exists() ) then
            cMsg = active.getText()
            cMsg = hRemoveLineBreaks( cMsg )
            printlog( "Expected active: " & cMsg )
            Active.OK()
            sleep( 1 )

            Kontext "SpeichernDLG"
            SpeichernDLG.cancel()
            sleep( 1 )
            brc = true
        else
            warnlog( "Errormessage for '/', '\' or ':' is missing" )
        endif

    '///+<li>Handle filenames which are devicenames (Errormessages)</li>
    elseif ( errortype = 0 ) then

        Kontext "Active"
        if ( Active.Exists() ) then
            printlog( " - Close the expected warning" )
            try
                cMsg = active.getText()
                cMsg = hRemoveLineBreaks( cMsg )
                printlog( "Expected active: " & cMsg )
                Active.OK()
                brc = true
            catch
                cMsg = active.getText()
                cMsg = hRemoveLineBreaks( cMsg )
                printlog( "Unxpected active: " & cMsg )
                Active.Yes()
                sleep( 2 )
                kontext "Active"
                Active.OK()

            endcatch
        else
            warnlog( "Warning missing: Unable to write file" )
        endif

    endif
    '///</ul>

    '///+<li>Close the document</li>
    hDestroyDocument()
    
    '///+<li>Return errorcondition</li>
    hSaveFileExpectFailure() = brc
    
    '///</ul>
    
end function

'*******************************************************************************

function hCreateDirectoryExpectSuccess( dirname as string ) as boolean

    '///<h3>Create a directory where success is expected</h3>
    '///<i>Uses</i>: framework\tools\stringtools.inc<br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name of the directory (string)</li>
    '///<ul>
    '///+<li>Relative or absolute, absolute is recommended</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE = The directory wass created</li>
    '///+<li>FALSE = On any error (Unable to create or file already exists)</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    dim cMsg as string
    dim brc as boolean
        brc = true

    '///+<li>Click &quot;File Open&quot;</li>
    FileOpen    
    sleep( 2 )

    '///+<li>Click on &quot;New folder&quot;</li>
    Kontext "OeffnenDlg"
    NeuerOrdner.click()

    '///+<li>Enter a name for the folder into the dialog</li>
    Kontext "NeuerOrdner"
    OrdnerName.setText( dirname )
    
    '///+<li>Click &quot;OK&quot;</li>
    NeuerOrdner.OK()

    '///+<li>Handle possible messagebox (unexpected)</li>
    Kontext "Active"
    if Active.Exists() then
        cMsg = active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        printlog( "Unexpected active: " & cMsg )
        brc = false
        try
            Active.YES()
        catch
            Active.OK()
        endcatch
    endif
    
    '///+<li>Return errorcondition</li>
    hCreateDirectoryExpectSuccess() = brc
    
    '///</ul>

end function

'*******************************************************************************

function hDeleteFileViaFileOpen( cFile as String ) as boolean

    '///<h3>Delete a file using the File Open dialog</h3>
    '///<i>Uses</i>: framework\tools\stringtools.inc<br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Filename incl. extension (string)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE = File was deleted</li>
    '///+<li>FALSE = Any other condition</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    ' This sub deletes a file by name. No errors or warnings are expected.
    ' if everything goes well,  we're back to the originating document after
    ' completion.

    dim iFilesBeforeDelete as integer
    dim iFilesAfterDelete as integer
    dim iCurrentFile as integer
    dim brc as boolean
        brc = false
    dim cMsg as string

    '///+<li>Click &quot;File Open&quot;</li>
    FileOpen
    
    '///+<li>Retrieve the number of files listed in FilePicker</li>
    Kontext "OeffnenDLG"
    iFilesBeforeDelete = DateiAuswahl.getItemCount()

    '///+<li>Walk through the files and try to find the specified file</li>
    '///+<li>On match: Delete it using &quot;DEL&quot;-Key</li>
    ' delete the file specified in cFile using stringcompare in "Dateiauswahl"
    ' NOTE: In some cases this might fail (e.g. truncated spaces)
    for iCurrentFile = 1 to iFilesBeforeDelete

        if ( DateiAuswahl.getItemText( iCurrentFile ) = cFile ) then
            printlog( " * Deleting file: " & DateiAuswahl.getItemText( iCurrentFile ) )
            DateiAuswahl.Select( iCurrentFile )  ' select (if on pos1 without focus)
            DateiAuswahl.typeKeys( "<SPACE>" )   ' highlight/focus
            DateiAuswahl.TypeKeys( "<DELETE>" )
            sleep( 1 )

            ' confirm deletion
            Kontext "ConfirmDelete"
            if ( ConfirmDelete.exists() ) then
                Delete.click()
            else
                warnlog( "Messagebox to confirm deletion of file is missing" )
            endif

            ' break the loop
            iCurrentFile = iFilesBeforeDelete + 1
        endif

    next iCurrentFile

    '///+<li>Handle possible Warnings/Errormessages</li>
    Kontext "Active"
    if( Active.exists( 1 ) = true ) then
        cMsg = active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        printlog( "Unexpected active: " & cMsg )
        Active.OK()
    endif

    '///+<li>Cancel &quot;File Open&quot;</li>
    ' The testtool internally does not refresh the list so restarting the dialog
    ' is required to get the new number of files in the list.
    Kontext "OeffnenDLG"
    OeffnenDLG.cancel()
    sleep( 1 )

    '///+<li>Verify that the number of files in &quot;File Open&quot; has decreased by one</li>
    Kontext "OeffnenDLG"
    iFilesAfterDelete = hGetFileCountViaFileOpen()
    if ( iFilesAfterDelete <> ( iFilesBeforeDelete - 1 )) then
        printlog( "The File: " & cFile & " has not been deleted. Please check." )
        brc = true
    endif
    
    '///+<li>Return errorcondition</li>
    hDeleteFileViaFileOpen() = brc
    
    '///</ul>

end function

'******************************************************************************

function hGetFileCountViaFileOpen() as integer

    '///<h3>Get the number of items listed in the FilePicker (File Open)</h3>
    '///<i>Note</i>: This function works on the current workdirectory<br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Number of items listed in filepicker</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    '///+<li>Click &quot;File open&quot;</li>
    FileOpen
    
    '///+<li>Retrieve the number of items in the filepicker window</li>
    Kontext "OeffnenDLG"
    hGetFileCountViaFileOpen() = DateiAuswahl.getItemCount()
    
    '///+<li>Close &quot;File Open&quot;</li>
    OeffnenDLG.cancel()
    '///</ul>    

end function

'*******************************************************************************

function hNameGen_append( iDecChar as long , bSuf as boolean ) as string

    '///<h3>Create a filename with specified character at the end and optional suffix</h3>
    '///<i>Uses</i>: Default suffix via hGetSuffix()<br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Character as number (integer)</li>
    '///<ul>
    '///+<li>Only positive numbers are allowed</li>
    '///+<li>Respect integer boundaries</li>
    '///</ul>
    '///+<li>Append suffix (boolean)</li>
    '///<ul>
    '///+<li>TRUE = Do append a suffix</li>
    '///+<li>FALSE = Do not append a suffix</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>A filename containing a special character at the end (before suffix)</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    dim cFile as string

    '///+<li>Create a string &quot;test&quot;, append ascii char</li>
    cFile = "test" & CHR$( iDecChar )

    '///+<li>Optionally append suffix</li>
    if ( bSuf ) then        
        cFile = cFile & hGetSuffix( "current" ) 
    endif

    '///+<li>Return the new filename</li>
    hNameGen_append() = cFile
    
    '///</ul>

end function

'*******************************************************************************

function hNameGen_lead( iDecChar as long , bSuf as boolean ) as string

    '///<h3>Create a filename with specified character at the beginning and optional suffix</h3>
    '///<i>Uses</i>: Default suffix via hGetSuffix()<br><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Character as number (integer)</li>
    '///<ul>
    '///+<li>Only positive numbers are allowed</li>
    '///+<li>Respect integer boundaries</li>
    '///</ul>
    '///+<li>Append suffix (boolean)</li>
    '///<ul>
    '///+<li>TRUE = Do append a suffix</li>
    '///+<li>FALSE = Do not append a suffix</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>A filename containing a special character at the beginning</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
   
    dim cFile as string

    '///+<li>Create a string beginning with ascii char and append &quot;test&quot</li>
    cFile = CHR$( iDecChar ) & "test"

    '///+<li>Optionally append suffix</li>
    if ( bSuf ) then   
        cFile = cFile & hGetSuffix( "current" )
    endif    

    '///+<li>Return the new filename</li>
    hNamegen_lead() = cFile
    
    '///</ul>

end function

'*******************************************************************************

function hCopyDir( sSourceDir as string, sTargetDir as string ) as integer


    '///<h3>Copy a directory recursively including subdirs and files</h3>
    
    '///<i>This function runs silent. Evaluate retuncode instead</li><br>

    '///<u>Input value(s):</u><br>
    '///<ol>

    '///+<li>Source directory (string)</li>
    '///<ul>
    '///+<li>This must be an existing directory</li>
    '///</ul>

    '///+<li>Target directory (string)</li>
    '///<ul>
    '///+<li>This must be an existing directory</li>
    '///</ul>

    '///</ol>


    '///<u>Return Value:</u><br>

    '///<ol>
    '///+<li>Errorcode (integer)</li>
    '///<ul>
    '///+<li>0 = Operation completed successfully</li>
    '///+<li>1 = Target directory does not exist</li>
    '///+<li>2 = Source directory does not exist</li>
    '///</ul>
    '///</ol>

    const CFN = "hCopyDir::"
    dim brc as boolean 'a multi purpose boolean returnvalue
    dim iErr as integer
    dim iSourceObjectCount as integer
    dim asSourceFiles( 1000 ) as string
    dim sTargetFile as string
    dim iTemp as integer

    '///<u>Description:</u>
    '///<ul>
    '///+<li>Test that the source directory exists</li>
    sSourceDir = convertpath( sSourceDir )
    if ( dir( sSourceDir, 16 ) = "" ) then
        hCopyDir() = 1
        exit function
    endif
        
    '///+<li>Test that the target directory exists</li>
    sTargetDir = convertpath( sTargetDir )
    if ( dir( sTargetDir, 16 ) = "" ) then
        hCopyDir() = 2
        exit function
    endif
    
    '///+<li>Retrieve the list of directories recursively</li>
    iSourceObjectCount = GetAllDirList( sSourceDir, "*", asSourceFiles() )
   
    '///+<li>Strip source path, concatenate target path and directory name</li>
    '///+<li>Create the list of directories at the target location</li>
    for iTemp = 1 to iSourceObjectCount
        sTargetFile = sTargetDir & hGetRelPath( sSourceDir, asSourceFiles( iTemp ) )
        sTargetFile = left( sTargetFile , len( sTargetFile ) -1 )
        'printlog( "Write to: " & sTargetFile )
        iErr = mkdir( sTargetFile )
        select case iErr
        case 5  : warnlog( "Invalid procedure call" )
        case 76 : warnlog( "Path not found" )
        end select
        
    next iTemp

    '///+<li>Retrieve the list of files recursively</li>
    iSourceObjectCount = GetAllFileList( sSourceDir, "*", asSourceFiles() )
    
    '///+<li>Strip source path, concatenate target path and filenames</li>
    '///+<li>Create the list of files at the target directory</li>
    '///+<li>Copy the files</li>
    for iTemp = 1 to iSourceObjectCount
        sTargetFile = sTargetDir & _
                      hGetRelPath( sSourceDir, asSourceFiles( iTemp ) )
        'printlog( "Copy to: " & sTargetFile )                     
        iErr = filecopy( asSourceFiles( iTemp ) , sTargetFile )
        select case iErr
        case 5  : warnlog( "Invalid procedure call" )
        case 76 : warnlog( "Path not found" )
        end select
    next iTemp
    
 
    '///</ul>

    hCopyDir() = 0

end function

'*******************************************************************************

function hGetRelPath( cStartDir, cFileName as String ) as string

   hGetRelPath() = mid( cFileName , len( cStartDir + 1 ) )

end function

'*******************************************************************************
