'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_certification_dialogs.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Walk through a number of dialogs related to digital signatures
'*
'*******************************************************************************
'**
' #1 tCertificationDialogs ' Walk through a number of dialogs related to digital signatures
'**
'\******************************************************************************

testcase tCertificationDialogs

    '///<H1>Walk through a number of dialogs related to digital signatures</H1>

    dim brc as boolean
    const CFN = "tCertificationDialogs::"
    const SVERSION = "680"

    dim sFile as string
        sFile = gOfficePath & "user\work\certdlg" & hGetSuffix( SVERSION )
        sFile = convertpath( sFile )

    hDeleteFile( sFile )

    call hNewDocument() 

    call hChangeDoc()

    brc = hOpenDigitalSignaturesDialog()

    kontext "active"
    if ( active.exists() ) then
        printlog( "MSGBOX: " & active.getText() )
        active.yes()
        printlog( CFN & "Allow to save the document" )
    else
        if ( gApplication <> "MASTERDOC" ) then
            warnlog( CFN & "No message that the file must be saved to be signed" )
        else
            printlog( CFN & "OK - No save-message for Masterdoc." )
        endif
    endif

    kontext "SpeichernDlg"
    if ( SpeichernDlg.exists() ) then
        DateiName.setText( sFile )
        AutomatischeDateinamensErweiterung.uncheck()
        Speichern.click()
    else
        if ( gApplication <> "MASTERDOC" ) then
            warnlog( CFN & "Save As Dialog is not open" )
        else
            printlog( CFN & "OK - No filesave for Masterdoc." )
        endif
    endif

    kontext "DigitalSignature"
    if ( DigitalSignature.exists() ) then
        printlog( CFN & "Digital signatures is open" )
        DigitalSignature.cancel()
    else
        if ( gApplication <> "MASTERDOC" ) then
            warnlog( CFN & "Digital Signatures Dialog is not open" )
        else
            printlog( CFN & "OK - No signature dialog for Masterdoc." )
        endif
    endif

    call hCloseDocument()



endcase

