'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filename1.inc,v $
'*
'*  $Revision: 1.19 $
'*
'*  last change: $Author: jsk $ $Date: 2006/07/25 06:26:53 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( extended tests )
'*
'*******************************************************************************
'**
' #1 tSaveLoadDelFiles       ' checks for strange names on windows that are allowed
' #1 tSaveReservedNamesWin   ' checks that reserved names on Windows cannot be saved
' #1 tSaveReservedNamesUNIX  ' checks if we accidentially don't allow special names
' #1 tSLDForbiddenNamesWin  ' checks ASCII chars 0 .. 31 on Windows
' #1 tSLDForbiddenNamesUNIX ' checks ASCII chars 0 .. 31 on UNIX
'**
'\******************************************************************************

testcase tSaveLoadDelFiles()

    '///<h1>Check allowed filenames on Windows using the File-Save dialog</h1>
    
    ' This test checks filenames that resemble Devices and files that contain
    ' the allowed ASCII chars between 32 and 255. The latter is tested by five
    ' random characters
    ' The test should work for all applications and on all languages/locales.
    
    dim cStrangeName as string
    dim iCounter ' iterator
    dim iRandom  ' random number. should end up to be a value between 32 and 255
    dim brc as boolean
    
    printlog( CHR$(13) )
    printlog( "Check if filenames that resemble devicenames are treated ok" )
    printlog( CHR$(13) )
    
    '///<ul>
    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    
    '///+<li>Save/Load/Delete names that resemble port-names (but are valid names)</li>
    brc = hSaveLoadDelSuccess( "COM0"      , true )
    brc = hSaveLoadDelSuccess( "COM10"     , true )
    brc = hSaveLoadDelSuccess( "COM0"  & hGetSuffix( "current" ) , true )
    brc = hSaveLoadDelSuccess( "COM10" & hGetSuffix( "current" ) , true )
    brc = hSaveLoadDelSuccess( "LPT0"      , true )
    brc = hSaveLoadDelSuccess( "LPT10"     , true )
    brc = hSaveLoadDelSuccess( "LPT0"  & hGetSuffix( "current" ) , true )
    brc = hSaveLoadDelSuccess( "LPT10" & hGetSuffix( "current" ) , true )
    
    '///+<li>Save/Load/Delete files containing  permitted ASCII-characters</li>
    ' This test randomizes through a number of characters, a full test of all
    ' possible ascii characters would simply take too long.
    printlog( CHR$(13) + "Names with allowed ASCII-chars" )
    printlog( "" )
    
    call randomize()
    
    for iCounter = 1 to 3
        
        iRandom = int( 32 + ( 223 * rnd ) )
        printlog( "" )
        printlog( " * Using decimal char: " & iRandom )
        
        
        ' Exclude some special characters that cannot work
        select case iRandom
            
        case  34 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case  35 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case  42 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case  47 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case  58 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case  60 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case  62 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case  63 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case  92 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case 124 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
        case 126 : printlog( CHR$(13) & " - skipping ASCII-Char: " & iRandom )
            
        case else
            
            cStrangeName = hNameGen_append( iRandom , true )
            brc = hSaveLoadDelSuccess( cStrangeName , TRUE )
            
            cStrangeName = hNameGen_lead( iRandom , true )
            brc = hSaveLoadDelSuccess( cStrangeName , TRUE )
            
        end select
        
        sleep( 1 )
        
    next iCounter
    
    '///+<li>close the document</li>
    brc = hDestroyDocument()

    '///+<li>Restart the office</li>    
    printlog( "Exit and restart the office" )
    call ExitRestartTheOffice()
    '///</ul>
    
endcase

'*******************************************************************************

testcase tSaveReservedNamesWin()

    '///<h1>Check reserved filenames on Windows using the File-Save dialog</h1>
    
    ' This sub creates invalid filenames on Windows and tries to save files
    ' with those names. This should fail.
    ' The names are created dependent on the gApplication (documenttype)
    ' which must have been specified in advance. To generate the names the
    ' function hNameGenASCII_append( int, boolean ) is used which generates
    ' the file-suffix based on the current 'gApplication'
    ' Since saving is expected to fail in every case, there is no reload-test
    ' for these filenames
    
    dim cStrangeName as string
    dim iCounter as integer
    dim brc as boolean
    
    
    '///<ul>
    '///+<li>Reserved filenames are e.g. LPT1, COM2, NUL etc.</li>
    
    printlog( CHR$(13) )
    printlog( "Check if reserved filenames on Windows are handled ok" )
    printlog( CHR$(13) )
    
    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    brc = hCreateDocument()
    
    
    ' serial ports (COM1-COM9 are not allowed)
    '///+<li>Try to save files with names of serial ports COM1-COM9</li>
    printlog( CHR$(13) + "Serial ports without extension" )
    for iCounter = 1 to 9
        cStrangeName = "COM" & CHR$( iCounter + 48 )
        brc = hSaveFileExpectFailure( cStrangeName , 0 )
        if ( brc ) then warnlog( "Assumption failed" )
    next iCounter
    
    
    ' serial ports with extension (COM1.xxx-COM9.xxx are not allowed)
    '///+<li>Try to save files to names of serial ports with extension</li>
    printlog( CHR$(13) + "Serial ports with extensions" )
    for iCounter = 1 to 9
        cStrangeName = "COM" & CHR$( iCounter + 48 )
        cStrangeName = cStrangeName & hGetSuffix( "current" )
        brc = hSaveFileExpectFailure( cStrangeName , 0 )
        if ( brc ) then warnlog( "Assumption failed" )
    next iCounter
    
    
    ' parallel ports (LPT1-LPT9 are not allowed)
    '///+<li>Try to save files to parallel ports LPT1-LPT9</li>
    printlog( CHR$(13) + "Parallel ports without extension" )
    for iCounter = 1 to 9
        cStrangeName = "LPT" & CHR$( iCounter + 48 )
        cStrangeName = cStrangeName & hGetSuffix( "current" )
        brc = hSaveFileExpectFailure( cStrangeName , 0 )
        if ( brc ) then warnlog( "Assumption failed" )
    next iCounter
    
    
    ' parallel ports with extension (LPT1.xxx-LPT9.xxx are not allowed)
    '///+<li>Try to save files to parallel ports with extension</li>
    printlog( CHR$(13) + "Parallel ports with extension" )
    for iCounter = 1 to 9
        cStrangeName = "LPT" & CHR$( iCounter + 48 )
        cStrangeName = cStrangeName & hGetSuffix( "current" )
        brc = hSaveFileExpectFailure( cStrangeName , 0 )
        if ( brc ) then warnlog( "Assumption failed" )
    next iCounter
    
    
    ' other reserved names
    '///+<li>Try to save files to other reserved names such as NUL, CLOCK$ etc.</li>
    printlog( CHR$(13) + "Other reserved names" )

    brc = hSaveFileExpectFailure( "NUL"    , 0 )
    if ( brc ) then warnlog( "Assumption failed" )

    qaerrorlog( "skipping CLOCK$, we write the file without error->bug" )
    'brc = hSaveFileExpectFailure( "CLOCK$" , 0 )

    brc = hSaveFileExpectFailure( "CON"    , 0 )
    if ( brc ) then warnlog( "Assumption failed" )

    brc = hSaveFileExpectFailure( "PRN"    , 0 )
    if ( brc ) then warnlog( "Assumption failed" )

    brc = hSaveFileExpectFailure( "AUX"    , 0 )
    if ( brc ) then warnlog( "Assumption failed" )
    
    qaerrorlog( "Skipping special reserved characters, we do not handle them correctly" )
    goto AS_SpecialBug
    ' special reserved characters
    '///+<li>Try to save files to names containing reserved characters like <, >, |</li>
    printlog( CHR$(13) + "Reserved characters" )
    
    ' descr: hNameGenASCII_append takes an ASCII-char as int and a boolean
    ' value for "append file suffix" if true
    ' descr: SaveFileExpectFailure takes a filename and a numeric value for
    ' the type of errorhandling (0 = invalid char, 1 = path separator)
    
    cStrangeName = hNameGen_append( 60 , true ) ' char "<"
    brc = hSaveFileExpectFailure( cStrangeName , 0 )
    if ( brc ) then warnlog( "Assumption failed" )
    
    cStrangeName = hNameGen_append( 62 , true ) ' char ">"
    brc = hSaveFileExpectFailure( cStrangeName , 0 )
    if ( brc ) then warnlog( "Assumption failed" )
    
    cStrangeName = hNameGen_append( 34 , true ) ' char '"'
    brc = hSaveFileExpectFailure( cStrangeName , 0 )
    if ( brc ) then warnlog( "Assumption failed" )
    
    cStrangeName = hNameGen_append( 124 , true ) ' char "|"
    brc = hSaveFileExpectFailure( cStrangeName , 0 )
    if ( brc ) then warnlog( "Assumption failed" )
    
    'misinterpreted characters (seen as UNC name or device by Windows)
    cStrangeName = hNameGen_append( 92, true ) ' char "\"
    brc = hSaveFileExpectFailure( cStrangeName , 1 )
    if ( brc ) then warnlog( "Assumption failed" )
    
    cStrangeName = hNameGen_append( 47 , true ) ' char "/"
    brc = hSaveFileExpectFailure( cStrangeName , 1 )
    if ( brc ) then warnlog( "Assumption failed" )
    
    cStrangeName = hNameGen_append( 58 , true ) ' char ":"
    brc = hSaveFileExpectFailure( cStrangeName , 1 )
    if ( brc ) then warnlog( "Assumption failed" )
    
    AS_SpecialBug:
    
    '///+<li>Close the document</li>
    printlog( "Close the document" )
    brc = hDestroyDocument()
    
    '///</ul>
    
endcase

'*******************************************************************************

testcase tSLDForbiddenNamesWin()

    '///<h1>Check forbidden filenames on Windows using File-Save dialog</h1>
    
    ' This test tries to save files that contain characters that are not allowed
    ' in filenames on Windows. This covers the entire ASCII range from 0 to 31.
    ' Currently the ASCII chars 0, 9, 10, and 13 are excluded because we - for some
    ' reason - do not intercept them.
    
    '///<ul>
    '///+<li>Open a new document</li>
    '///+<li>Save the file with a name containing the ASCII chars 0 through 31, excluding 0,9,10,13</li>
    '///+<li>Confirm the warning</li>
    '///+<li>Close the document</li>
    '///+<li>Repeat the test for all applications</li>
    '///</ul>
    
    dim cStrangeName as string
    dim iCounter as integer
    dim brc as boolean
    
    printlog( CHR$(13) )
    printlog( "Check if reserved filenames on Windows are handled ok" )
    printlog( CHR$(13) )
    
    printlog( " - names with forbidden ASCII-chars" )
    for iCounter = 1 to 31
        
        select case iCounter
            
        case 9 :  printlog( " - skipping ASCII 009 (horizontal tab)" )
        case 10 : printlog( " - skipping ASCII 010 (linefeed)" )
        case 13 : printlog( " - skipping ASCII 013 (carriage return)" )
        case else
            printlog( CHR$(13) & "Using char at decimal position: " & iCounter )
            cStrangeName = hNameGen_append( iCounter , true )
            brc = hSaveFileExpectFailure( cStrangeName , 0 )
            if ( not brc ) then warnlog( "Assumption failed" )
        end select
        
    next iCounter
    
endcase

'*******************************************************************************

testcase tSaveReservedNamesUNIX()

    '///<h1>Check if we accidentially disallow some special names as COM etc on UNIX</h1>
    
    ' This test checks if we - accidentially - disallow filenames that are devices
    ' on Windows to be saved on Unix/Linux. This should not happen.
    
    '///<ul>
    '///+<li>Save a file with a name like COM, LPT, NUL, CLOCK$ - this should work</li>
    '///+<li>Close the document and reload it, it should be loaded</li>
    '///+<li>Close the document and delete it using the 'DEL'-key in File-Open</li>
    '///+<li>repeat this for all applications</li>
    '///</ul>
    
    dim cStrangeName as string
    dim brc as boolean
    
    printlog( CHR$(13) + "Names that are reserved on WINDOWS but are OK on UNIX" )
    brc = hSaveLoadDelSuccess( "NUL"    , true )
    if ( not brc ) then warnlog( "Assumption failed" )
    hDestroyDocument()

    brc = hSaveLoadDelSuccess( "CLOCK$" , true )
    if ( not brc ) then warnlog( "Assumption failed" )
    hDestroyDocument()

    brc = hSaveLoadDelSuccess( "CON"    , true )
    if ( not brc ) then warnlog( "Assumption failed" )
    hDestroyDocument()

    brc = hSaveLoadDelSuccess( "PRN"    , true )
    if ( not brc ) then warnlog( "Assumption failed" )
    hDestroyDocument()

    brc = hSaveLoadDelSuccess( "AUX"    , true )
    if ( not brc ) then warnlog( "Assumption failed" )
    hDestroyDocument()

    brc = hSaveLoadDelSuccess( "LPT1"   , true )
    if ( not brc ) then warnlog( "Assumption failed" )
    hDestroyDocument()

    brc = hSaveLoadDelSuccess( "LPT2"   , true )
    if ( not brc ) then warnlog( "Assumption failed" )
    hDestroyDocument()

    brc = hSaveLoadDelSuccess( "COM1"   , true )
    if ( not brc ) then warnlog( "Assumption failed" )
    hDestroyDocument()

    brc = hSaveLoadDelSuccess( "COM2"   , true )
    hDestroyDocument()
    
    cStrangeName = "LPT1" & hGetSuffix( "current" )
    brc = hSaveLoadDelSuccess( cStrangeName , true )
    if ( not brc ) then warnlog( "Assumption failed" )
    hDestroyDocument()
    
endcase

'*******************************************************************************

testcase tSLDForbiddenNamesUNIX()

    '///<h1>Check forbidden filenames on Windows using File-Save dialog</h1>
    
    ' This test tries to save files that contain the ASCII chars 0 through 31.
    ' This is not allowed on Windows but should work on Unix/Linux.
    
    
    '///<ul>
    '///+<li>Open a new document</li>
    '///+<li>Save the file with a name containing the ASCII chars 1 through 31</li>
    '///+<li>Close the document</li>
    '///+<li>Reopen the document using File-Open, the document should load</li>
    '///+<li>Close the document</li>
    '///+<li>Delete the document via File-Open using the 'DEL' Key</li>
    '///+<li>Confirm the deletion warning</li>
    '///+<li>Repeat the test for all applications</li>
    '///</ul>
    
    dim cStrangeName as string   ' this is the current file to be tested
    dim iCurrentChar as integer
    dim brc as boolean
    
    printlog( CHR$(13) )
    printlog( "Check if Windows reserved filenames are handled ok on UNIX" )
    printlog( CHR$(13) )
    printlog( " - names with ASCII-chars that are forbidden on Windows" )
    
    qaerrorlog( "#i42990# ASCII chars in the range of 1 to 31 in filenames freeze the office while loading" )
    goto skiptest
    
    'chars from ASCII 1 to 31
    for iCurrentChar = 1 to 31
        
        select case iCurrentChar
            
        case 9 :  printlog( " - skipping ASCII 009 (horizontal tab)" )
        case 10 : printlog( " - skipping ASCII 010 (linefeed)" )
        case 13 : printlog( " - skipping ASCII 013 (carriage return)" )
        case else
            printlog( CHR$(13) & " * Checking ASCII char: " & iCurrentChar )
            cStrangeName = hNameGen_append( iCurrentChar , true )
            brc = hSaveLoadDelSuccess( cStrangeName , true )
            if ( not brc ) then warnlog( "Assumption failed" )
            
        end select
        
    next iCurrentChar
    
    skiptest:
    
endcase

