'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_filteritems.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2006/06/23 13:14:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'************************************************************************
'**
' #1 tFilteritems         ' select all filteritems in the filter-dialog
'**
'\***************************************************************************

testcase tFilteritems
    
    '///<h1>Ressource test: Select all filters in the filter dialog</h1>
    '///<i>Note</i>: This test does not compare filters, it merely looks for freezes/crashes
    
    'select all filters in a directory where all types of StarOffice exists
    'why this test : When a filter is selected, the listbox shows only the files
    'with the right extension.
    'Because of this we must test, that all filters have an action
    
    dim iCurrentFilter as Integer
    dim iFilterCount as integer
    dim iFileSum as integer
    dim iFileCount as integer
    
    
    dim cCurrentFilterName as string
    dim sWorkPath as string
        sWorkPath = gTesttoolPath & "framework\filedlg\input\alldocs"
        sWorkPath = convertpath( sWorkPath )
    
    '///<ul>
    
    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    hCreateDocument()
    
    '///+<li>Either click on &quot;FileOpen&quot; or use the menu to get to the dialog</li>
    printlog( " - Open the file-open dialog" )
    FileOpen
    
    '///+<li>Open [TesttoolPath]\framework\filedlg\input</li>
    printlog( " - change to working directory: " + sWorkPath )
    
    Kontext "OeffnenDlg"
    Dateiname.SetText ( sWorkPath )
    oeffnen.click()
    
    '///+<li>Check that there is a total of 125 entries in the filterlist (incl. separators)</li>
    iFilterCount = Dateityp.GetItemCount()
    printlog( "Read " & iFilterCount & " filters from the list" )
    if ( iFilterCount <> 125 ) then
        warnlog( "Number of entries in filterlist should be 125" )
    endif
    
    '///+<li>For each filter in the filterlist</li>
    printlog( " - step through the filters one by one" )

    '///<ul>
    for iCurrentFilter =1 to iFilterCount
        
        try
            '///+<li>Select filter</li>
            DateiTyp.Select( iCurrentFilter )
            
            '///+<li>Retrieve the name of the filter, verify that it is not empty</li>
            cCurrentFilterName = Dateityp.GetItemText( iCurrentFilter )
            if ( cCurrentFilterName =  "" ) then
                warnlog( "Empty filter in list at pos. " & iCurrentFilter )
            else
                printlog( "Filter: " & cCurrentFilterName )
            endif
            
            '///+<li>Verify that a number of files is listed in the filelist</li>
            if ( instr( "---------" , cCurrentFilterName ) = 0 ) then
                iFileCount = DateiAuswahl.getItemCount()
                if ( iFileCount < 2 ) then
                    qaerrorlog( "No testdocument present for this filetype" )
                endif
            endif
            
            iFileSum = iFileSum + iFileCount 
            
            sleep( 1 )
        catch
            Warnlog( "Failed for filter at pos. " & iCurrentFilter )
        endcatch
        '///+<li>Next filter</li>
        
    next iCurrentFilter
    '///</ul>
    
    '///+<li>Check that a total of 188 files (incl. CVS-directory) were listed during the test</li>
    printlog( "Number of hits in FileList: " & iFileSum )
    if ( iFileSum <> 188 ) then
        warnlog( "The expected sum of all files listed per filter should be 188" )
    endif
    
    '///+<li>Cancel the FileOpen dialog</li>
    printlog( " - close the file open dialog via 'cancel'" )
    OeffnenDlg.Cancel()
    
    '///+<li>Close the document</li>
    printlog( "Close the document" )
    hDestroyDocument()
    '///</ul>
    
endcase


