'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_accented_foldernames.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2006/07/28 05:54:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Save/Load/Delete files from folders containing accented chars in their names
'*
'*******************************************************************************
'**
' #1 tFiledlgAccentedFolders ' Save/Load/Delete files from folders containing accented chars in their names
'**
'\******************************************************************************

testcase tFiledlgAccentedFolders

    '///<h3>Save/Load/Delete files from folders containing accented chars in their names</h3>
    '///<ul>
    
    ' Accented characters can be found in the extended ASCII charset at the decimal 
    ' positions between 192 (#C0) and 223 (#DF). This makes a total of 32 possible names
    
    ' Filenames with strange characters are tested in filedlg_cjkchars.bas, this is
    ' about the foldernames only
    
    const FOLDERCOUNT = 32
    dim iCurrentFolder as integer
    dim iCurrentChar as integer
    
    dim sCurrentFolder as string
    dim sFileName as string
    dim sCurrentFile as string
        
    dim irc as integer ' some integer return code
    dim brc as boolean ' some boolean return code
    
    '///+<li>Set a name for the file to work with</li>
    sFileName = "tFileDlgAccentedFolder" & hGetSuffix( "current" )    
    
    for iCurrentFolder = 1 to FOLDERCOUNT
    
        printlog( "" )
    
        '///+<li>Pick the next character</li>
        iCurrentChar = 191 + iCurrentFolder
    
        '///+<li>Build the name of the folder to work with</li>
        sCurrentFolder = hGetWorkPath()
        sCurrentFolder = sCurrentFolder & "tFiledlgAccentedFolder" 
        sCurrentFolder = sCurrentFolder & CHR$( iCurrentChar )
        printlog( "Current name is: " & sCurrentFolder & " (" & iCurrentChar & ")" )
        
        '///<li>For all 32 Characters do:</li>
        '///<ul>
        if ( dir( sCurrentFolder ) = "" ) then
        
            '///+<li>Create the folder (if it does not exist)</li>
            brc = hCreateDirectoryExpectSuccess( sCurrentFolder )
            if ( not brc ) then

                qaerrorlog( "Filepicker prevented creation of folder, using basic" )

                kontext "NeuerOrdner"
                NeuerOrdner.cancel()
                
                kontext "OeffnenDlg"
                OeffnenDlg.cancel()
                
                mkdir( sCurrentFolder )
            endif

            '///+<li>Verify that the folder has been created, if not: break</li>            
            if ( dir( sCurrentFolder ) = "" ) then
                warnlog( "Failed to create the folder" )
                goto endsub ' evil jump
            endif
            
            '///+<li>Build the fully qualified filename to the workfile</li>
            sCurrentFile = sCurrentFolder & "\" & sFileName
            sCurrentFile = convertpath( sCurrentFile )
            printlog( "Full path to file: " & sCurrentFile )
                      
            '///+<li>Save, load and delete the file via filedialog</li>
            irc = hSaveLoadDelSuccess( sCurrentFile )
            if ( irc <> 0 ) then
                warnlog( "hSaveLoadDelSuccess failed with error " & irc )
            endif
            
            '///+<li>Delete the Folder</li>
            hDeleteFile( sCurrentFolder )
            
        else
        
            warnlog( "A folder/file of that name already exists" )
            
        endif
        
    next iCurrentFolder
    '///</ul>
    '///</ul>

endcase

