/* MessageBox.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 *
 * Creates a generic alert/message/information dialog box.
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/
import java.awt.*;
import java.applet.*;

class MessageBox extends Dialog
{
        static final String BUTTON = "OK";
		Button button;
 
        public MessageBox(String message)
        {
 
                super(new Frame(), true);
                addNotify();

                setFont(new Font("Helvetica",Font.BOLD,12));
                
                setLayout(new BorderLayout());

                Panel p0=new Panel();
                p0.add(new Label(message));
                add("North",p0);
                
             
                Panel p = new Panel();
                p.add(button=new Button(BUTTON));
                add("South", p);

                int width=p0.preferredSize().width;
                int height=p.preferredSize().height + p0.preferredSize().height;


                resize(2*width , 2*height);
                
                //////////////////////////////////////
                //Position window in center of display
                //////////////////////////////////////
                Dimension screenSize = getToolkit().getScreenSize();
                move((screenSize.width - size().width)/2,
                     (screenSize.height - size().height)/2);                
        }

        public boolean action(Event evt, Object arg)
        {
               
                if(arg.equals(BUTTON))
                {
                        hide();
                        return true;
                }
                return false;
        }

	public boolean handleEvent(Event e)
    {
        /////////////////////////////////////////////////
        // Handle clicking on the close icon, and also
        // pressing the ESC key.
        /////////////////////////////////////////////////
        if (e.id == Event.WINDOW_DESTROY
        		||	(e.id == Event.KEY_PRESS && e.key==27)){
            hide();
            return true;
        }

         return super.handleEvent(e);
    }

    public void show()
    {
    	super.show();
    	button.requestFocus();
    }


}


