'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_formcontrols.inc,v $
'*
'*  $Revision: 1.13 $
'*
'*  last change: $Author: jsk $ $Date: 2006/05/16 13:19:29 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : Basic form-controls
'*
'*******************************************************************************
' **

' #1 tAllControlsOnDialog ' insert all controls in all documents, save/close/reload the docs and check all controls
' **
'\******************************************************************************

testcase tAllControlsOnDialog( cMajor as string )

    '///<h1>Basic test for macro controls</h1>
    '///<i>This test opens the applications and creates a basic dialog.
    '///+On this dialog all control are inserted, the document is saved and reloaded
    '///+to see if the dialog and the controls still exist.</i><br><br>

    dim iApplication as Integer ' numeric expression for gApplication
    dim cApplication as string  ' Name of the current application
    
    dim lsControlNames( 30 ) as string  ' list containing the names of the controls

    ' number of controls and the name of the current control
    dim iCurrentControl as integer
    dim sCurrentControl as string

    ' the workfile and the filter (Tested for 569, 645, 680
    dim sFile as string

    ' errorstatus: if false, something went wrong and the test cancels
    ' trying to recover somehow
    dim bOpen as boolean
    dim brc as boolean 
    
    const CMODULE = "tacod" ' abbreviation for tAllControlsOnDialog


    '///<b>save/load-test for controls on a basic-dialog in all applications</b>
    '///<ul>
    '///+<li>open a new doc (for all applications, not html)</li>

    for iApplication = 1 to 6
    
        ' switch documenttype (writer, calc, impress, draw ...)
        cApplication = hNumericDoctype( iApplication )

        ' get the name of the workfile dependent on gApplication
        sFile = hGetBasicWorkFile( cMajor )
        
        ' delete the file if it exists, the outcome has no influence on the test
        ' so the returnvalue is ignored
        hDeleteFile( sFile )
                
        ' open a new document to work with (2 open AFTER this)
        '///+<li>Open a new document to work with</li>
        printlog( "" )
        printlog( cApplication )
        call hCreateDocument()


        '///+<li>Create a new module for the new document</li>
        '///+<li>Create a new dialog in BasicIDE</li>
        '///+<li>Open the macro controls float</li>
        bOpen = hInitFormControls( CMODULE )
        if ( not bOpen ) then
            printlog( CFN & "Aborting due to previous errors" )
            call hCloseDocument()
            goto endsub
        endif

        printlog( "Insert all controls into the dialog" )
        for iCurrentControl = 1 to ICONTROLCOUNT - 1

            sCurrentControl = hDrawControlOnDialog( iCurrentControl )
            listappend( lsControlNames() , sCurrentControl )
            hOpenPropertyBrowser()
            hSetControlName( sCurrentControl )
            hClosePropertyBrowser()

        next iCurrentControl
        

        Kontext "BASICIDE"
        '///+<li>close the BASIC-IDE</li>
        hCloseBasicIde()
        
        ' check documentcount
        hCheckDocCount( 2 , false )        

        printlog "Save the document"
        '///+<li>save the document</li>
        Call hSaveFile( sFile , cMajor , true , false )

        printlog "Close it"
        '///+<li>close the document</li>
        '///</ul>
        brc = hDestroyDocument()
        sleep( 2 )
        
        ' check documentcount
        ' hCheckDocCount( 1 , false )

        '///<b>check all controls in the saved document</b>
        printlog "Open the file again"
        '///<ul>
        '///+<li>open the document</li>
        Call hLoadFile( sFile )

        printlog "Open tools/macro and select the last module for the current document"
        '///+<li>open the basic-IDE of this document, open controls, activate 'Select-mode' and open the properties</li>
        'hSelectTheLastModule( true )
        ToolsMacro_uno
        kontext "Makro"
        hSelectTheLastNode( MakroAus )
        sleep( 3 )
        
        brc = hIsMacroEditButtonEnabled()
        if ( not brc ) then
            warnlog( "Edit-Button is not enabled, the test cannot continue" )
            kontext "Makro"
            Makro.cancel()
            brc = hDestroyDocument()
            goto endsub
        endif
            
        sleep(1)

        '///+<li>Click 'Edit' to edit the module</li>
        printlog( "Edit the module" )
        Bearbeiten.Click()
        sleep( 2 )

        kontext "BasicIDE"
        '///+<li>Find the dialog we created before</li>
        ' try to find our dialog again by stepping through the tabbar
        bOpen = hFindFirstDialog()
        if ( not bOpen ) then
            warnlog( "Could access dialog, aborting test" )
            hCloseBasicIde()
            brc = hDestroyDocument()
            goto endsub
        endif

        '///+<li>Open the macro controls float</li>
        ' if the dialog is open, open the macro controls toolbar as well,
        ' we need access to the "properties" button
        bOpen = hShowMacroControls()
        if ( not bOpen ) then
            warnlog( "Could not open macro controls, aborting" )
            hCloseBasicIde()
            brc = hDestroyDocument()
            goto endsub
        endif
        
        '///+<li>Select every control, open its properties and verify its name</li>
        for iCurrentControl = 1 to ICONTROLCOUNT - 1
        
            hSelectControl( iCurrentControl )
            hOpenPropertyBrowser()
            sCurrentControl = lsControlNames( iCurrentControl )
            hGetControlName( sCurrentControl )
            hClosePropertyBrowser()
            
        next iCurrentControl
        
        '///+<li>Close the Property-Browser</li>

        ' we need to delete the list-content otherwise we run into index-problems
        listalldelete( lsControlNames() )
       
        '///+<li>Close the BASIC-IDE</li>
        ' close the BASIC IDE
        printlog( "Close the BASIC IDE" )
        hCloseBasicIde()
        
        '///+<li>Close the document</li>
        ' close the document
        printlog( "Close the document" )
        brc = hDestroyDocument()
        
        '///+<li>Check that only one document is open (the first doc)</li>
        'check the documentcount ( should be 1 at this point, the first doc
        'hCheckDocCount( 1 , false )
        
        '///+<li>Delete the file we created</li>
        ' do not bother with the outcome, it does not break the test.
        hDeleteFile( sFile )
        
        '///+<li>Repeat this for every application</li>
        '///</ul>
        
    next iApplication

endcase


