'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_extensions.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2006/08/17 15:47:31 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Function test of extension manager
'*
'*************************************************************************
'*
' #1   tExtensionsFunction        ' 
'*
'\************************************************************************

testcase tExtensionsFunction
    ' written for CWS jsc7, in master since SRC680m176
    ' features: - http://specs.openoffice.org/appwide/packagemanager/simple_extension_license.odt
    '           - http://specs.openoffice.org/appwide/packagemanager/extensiondependencies1.odt
    '/// The test documents are available at http://qa.openoffice.org/source/browse/qa/qatesttool/framework/basic/input/extensions/ ///'
    '/// Textdocuments used in this test and expected messages: ///'
    '/// (1/23): simpleLicense\BadDesc.oxt ///'
    '/// - BadDesc.oxt/description.xml contains data which cannot be parsed. ///' 
    '/// - will not install ///' 
    '/// (2/23): simpleLicense\BadNamespace.oxt ///'
    '/// - BadNamespace.oxt/description.xml contains a root element with an unsupported namespace. ///' 
    '/// - will not install ///' 
    '/// (3/23): simpleLicense\BadRoot.oxt ///'
    '/// - BadRoot.oxt/description.xml does not contain the root element <description>. ///'
    '/// - will not install ///' 
    '/// (4/23): simpleLicense\IncompAttr1.oxt ///'
    '/// - ExtensionSoftwareLicenseAgreement dialog exists ///'
    '/// - installs and is enabled ///'
    '/// (5/23): simpleLicense\IncompAttr2.oxt ///'
    '/// - Cannot find a localized license text or a default license text. ///'
    '/// - will not install ///' 
    '/// (6/23): simpleLicense\LongLic.oxt ///'
    '/// - ExtensionSoftwareLicenseAgreement dialog exists ///'
    '/// - It is a Long License ///'
    '/// - installs and is enabled ///'
    '/// (7/23): simpleLicense\MissingLic.oxt ///'
    '/// - MissingLic.oxt\registration\license_en_US.txt does not exist. ///'
    '/// - will not install ///' 
    '/// (8/23): simpleLicense\MissingLicRef.oxt ///'
    '/// - Cannot find a localized license text or a default license text. ///'
    '/// - will not install ///' 
    '/// (9/23): simpleLicense\NoDesc.oxt ///'
    '/// - installs and is enabled ///'
    '/// (10/23): simpleLicense\NoLangNoDefault.oxt ///'
    '/// - Cannot find a localized license text or a default license text. ///'
    '/// - will not install ///' 
    '/// (11/23): simpleLicense\OnlyDefault.oxt ///'
    '/// - Cannot find a localized license text or a default license text. ///'
    '/// - will not install ///' 
    '/// (12/23): simpleLicense\ShortLicense.oxt ///'
    '/// - ExtensionSoftwareLicenseAgreement dialog exists ///'
    '/// - installs and is enabled ///'
    '/// (13/23): ///'
    '/// - will not install ///' 
    '/// (14/23): simpleLicense\ShortLicenseShared.oxt ///'
    '/// - ExtensionSoftwareLicenseAgreement dialog exists ///'
    '/// - installs and is enabled ///'
    '/// (15/23): dependencies\broken-dependency.oxt ///'
    '/// - broken-dependency.oxt/description.xml contains data which cannot be parsed. ///' 
    '/// - will not install ///' 
    '/// (16/23): dependencies\double-dependencies.oxt ///'
    '/// - UnsatisfiedDependencies dialog exists ///'
    '///     (1/2): Dependency 1 ///'
    '///     (2/2): Dependency 2 ///'
    '/// - will not install ///' 
    '/// (17/23): dependencies\empty-dependencies.oxt ///'
    '/// - installs and is enabled ///'
    '/// (18/23): dependencies\funny-dependency.oxt ///'
    '/// - UnsatisfiedDependencies dialog exists ///'
    '///     (1/1): & < > ' " > ' tab	. crlf ///'
    '///           . em-dash�;. line-separator?. paragraph-separator?. xxxxxxxxxxx... ///'
    '/// - will not install ///' 
    '/// (19/23): dependencies\license-dependency.oxt ///'
    '/// - UnsatisfiedDependencies dialog exists ///'
    '///     (1/1): Dependency ///'
    '/// - will not install ///' 
    '/// (20/23): dependencies\many-dependencies.oxt ///'
    '/// - UnsatisfiedDependencies dialog exists ///'
    '///     (1/20): Dependency 1 ///'
    '///     (2/20): Dependency 2 ///'
    '///     (3/20): Dependency 3 ///'
    '///     (4/20): Dependency 4 ///'
    '///     (5/20): Dependency 5 ///'
    '///     (6/20): Dependency 6 ///'
    '///     (7/20): Dependency 7 ///'
    '///     (8/20): Dependency 8 ///'
    '///     (9/20): Dependency 9 ///'
    '///     (10/20): Dependency 10 ///'
    '///     (11/20): Dependency 11 ///'
    '///     (12/20): Dependency 12 ///'
    '///     (13/20): Dependency 13 ///'
    '///     (14/20): Dependency 14 ///'
    '///     (15/20): Dependency 15 ///'
    '///     (16/20): Dependency 16 ///'
    '///     (17/20): Dependency 17 ///'
    '///     (18/20): Dependency 18 ///'
    '///     (19/20): Dependency 19 ///'
    '///     (20/20): Dependency 20 ///'
    '/// - will not install ///' 
    '/// (21/23): dependencies\no-dependencies.oxt ///'
    '/// - installs and is enabled ///'
    '/// (22/23): dependencies\no-description.oxt ///'
    '/// - installs and is enabled ///'
    '/// (23/23): dependencies\unknown-dependency.oxt ///'
    '/// - UnsatisfiedDependencies dialog exists ///'
    '///     (1/1): Unknown ///'
    '/// - will not install ///' 

    dim j,b,i,a,x,y as integer
    dim sPath as string
    dim aFiles(50) as string
    dim aFeatures(50) as string
    dim aFileList(50) as string
    dim sTemp as string
    dim sTemp2 as string
    dim sTemp3 as string
    dim aTemp
    dim sFirstStatus as string
    dim bFound as boolean
    dim aRemovePackages(50) as string
    
    ' want to start and work with just one document window
    b = getDocumentCount
    for j = 1 to b
        printlog "closing: " + j
        hCloseDocument()
    next j
    hNewDocument()
    sleep (5)
    
    ' load about twenty one extension files, to test the features
    ' the list tells the filename and in encoded numbers the features
    ' a line looks like:
    ' simpleLicense\LongLic.oxt;0,2,1,0
    ' - the filename and the features are seperated by a semicolon
    ' - the numbes for the features are seperated by colons
    ' 1st number: Unsatisfied dependencies; if there are any, the number counts them; if there are none it is zero and the dialog won't come up
    ' 2nd number: License; if there is one the value is 1; it it a long one, where the scroll button needs to be used it is 2; 3 if the license should not be accepted for testing purposes, if there is no license the value is zero
    ' 3rd number: If the extension should successfully install teh value is one, else zero.
    ' 4th number: If an active is expected after selecting a file for installation the value is one, else zero.
    
    ' Base path for test files
    sPath = convertPath(gTestToolPath+"framework/basic/input/extensions/")
    ' read filelist and expected features
    ListRead(aFileList(), sPath+"files.txt")
    a = listCount(aFileList())
    printlog a
    for i = 1 to a
        aTemp = split (aFileList(i),";")
        if uBound(aTemp()) >0 then
            listAppend(aFiles(),aTemp(0))
            listAppend(aFeatures(),aTemp(1))
        endif
    next i
    
    ' there are some dependencys to languages...
    if iSprache = 49 then
    	sTemp = aFeatures(4)
    	aFeatures(4) = aFeatures(5)
    	aFeatures(5) = sTemp
    else
        if iSprache <> 01 then
            aFeatures(4) = aFeatures(5)
            aFeatures(6) = aFeatures(5)
            aFeatures(12) = aFeatures(5)
            aFeatures(13) = aFeatures(5)
            aFeatures(14) = aFeatures(5)
        endif
    endif
    ' cleanup before starting; check that no extension from the list is installed right now; if remove it.
    '/// Before starting, look into extension manager, if already a file is installed, that will be used in this test ///'
    '/// Remove it. ///'
    a = listCount(aFiles())
        ToolsPackageManager
        kontext "PackageManager"
        If PackageManager.exists(10) then
            BrowsePackages.typeKeys("<home>")
            sTemp = BrowsePackages.getSelText
            sTemp2 = ""
            while (sTemp <> sTemp2)
                kontext "PackageManager"
                BrowsePackages.typeKeys("+")
                BrowsePackages.typeKeys("<down>")
                sTemp2 = sTemp
                sTemp = BrowsePackages.getSelText
                if right(sTemp,3) = "oxt" then
                    for x = 1 to a
                        sTemp3 = aFiles(x)
                        y = instr(sTemp3,"\")
                        sTemp3 = mid(sTemp3,y+1)
                        if sTemp = sTemp3 then
                            qaErrorLog "Package is already installed, trying to remove it: '" + sTemp + "'"
                            if remove.isEnabled then
                                remove.click
                                Kontext "AddingPackages"
                                y=0
                                while AddingPackages.exists(1) AND (y<6)
                                    printlog "RemovingPackages..."
                                    sleep 5
                                    y=y+1
                                wend
                                kontext "PackageManager"
                                BrowsePackages.typeKeys("<up>")
                            else
                                warnlog "Package is already installed and can't get removed: '" + sTemp + "'"
                            endif
                        endif
                    next x
                endif
            wend
            kontext "PackageManager"
            PackageManager.close
            sleep 5
        endif
    
    ' for every test file do...
    a = listCount(aFiles())
    for i = 1 to a
        printlog "********** Test file ("+i+"/"+a+"): "+aFiles(i)
        aTemp = split (aFeatures(i),",")
        '/// call Tools - Package/Extension manager ///'
        ToolsPackageManager
        kontext "PackageManager"
        If PackageManager.exists(10) then
            '/// going to top of package list and explode every line, until the button 'Add' is enabled ///'
            '/// should be 'My Packages' ///'
            BrowsePackages.typeKeys("<home>")
            sTemp = BrowsePackages.getSelText
            sTemp2 = ""
            while (Not Add.isEnabled AND (sTemp <> sTemp2))
                BrowsePackages.typeKeys("+")
                BrowsePackages.typeKeys("<down>")
                sTemp2 = sTemp
                sTemp = BrowsePackages.getSelText
            wend
            if sTemp = sTemp2 then
                warnlog "Couldn't find a way to enable the Add button - aborting"
                goto endsub
            endif
            printlog BrowsePackages.getSelText
            '/// click button 'Add' ///'
            Add.click
                '/// Add Package(s)... dialg comes up ///'
                Kontext "OeffnenDlg"
                if OeffnenDlg.exists(5) then
                    '/// put filename into field ///'
                    Dateiname.setText convertPath(sPath + aFiles(i))
                    printlog DateiTyp.getSelText
                    '/// press button 'Open' ///'
                    Oeffnen.click
                else
                    warnlog "Add Package(s)... dialog didn't came up"
                endif
                
                '/// Progress dialog comes up ///'
                Kontext "AddingPackages"
                if AddingPackages.exists(1) then
                    printlog " - AddingPackages dialog exists"
                    'DialogTest(AddingPackages)
                endif
                
                '/// If any error happens, an active comes up, telling what is wrong ///'
                Kontext
                if active.exists(5) then
                    sTemp = active.getText
                    y = instr(sTemp, " ")
                    if cBool(aTemp(3)) then
                        printlog sTemp
                    else
                        warnlog sTemp
                    endif
                    printlog mid(sTemp, y)
                    active.ok
		        else
                    if cBool(aTemp(3)) then
                        warnlog "errormessage expected, but none came up."
                    endif
                endif
                
                '/// If there are any unsatisfied dependencies, they are shown now ///'
                Kontext "UnsatisfiedDependencies"
                if UnsatisfiedDependencies.exists(10) then
                    if cBool(aTemp(0)) then
                        printlog " - UnsatisfiedDependencies dialog exists"
                    else
                        warnLog "UnsatisfiedDependencies are not expected but available"
                    endif
                    DialogTest(UnsatisfiedDependencies)
                    y = UnsatisfiedDependencyList.getItemCount
                    if cInt(aTemp(0)) <> y then
                        warnlog "Difference in dependencies; expected: " + aTemp(0) + "; found: " +y
                    endif
                    for x = 1 to y
                        printlog "   ("+x+"/"+y+"): "+UnsatisfiedDependencyList.getItemText(x)
                    next x
                    '/// close dialog if available, extension will not be installed ///'
                    UnsatisfiedDependencies.close
                else
                    if cBool(aTemp(0)) then
                        warnLog "UnsatisfiedDependencies expected but none shown."
                    endif
                endif
                
                '/// If there is a license, it is shown now ///'
                Kontext "ExtensionSoftwareLicenseAgreement"
                if ExtensionSoftwareLicenseAgreement.exists(10) then
                    if cBool(aTemp(1)) then
                        printlog " - ExtensionSoftwareLicenseAgreement dialog exists"
                    else
                        warnlog "ExtensionSoftwareLicenseAgreement are not expected but shown"
                    endif
                    if NOT Accept.isEnabled then
                        if cInt(aTemp(1)) = 2 then
                            printlog "   Long License"
                        else
                            errorlog "Long License"
                        endif
                    else
                        if NOT cInt(aTemp(1)) = 2 then
                            printlog "Long License"
                        else
                            errorlog "Long License"
                        endif
                    endif
                    '/// scroll down until accept button is enabled, click accept button ///'
                    LicenseText.typeKeys ("<mod1 a>",true)
                    if Accept.isEnabled then
                        '/// for testing purposes click cancel one time - the extension should not get installed ///'
                        if cInt(aTemp(1)) = 3 then
                            ExtensionSoftwareLicenseAgreement.CANCEL
                        else
                            Accept.click
                        endif
                    else
                        qaErrorLog "Accept not enabled.yet"
                        while NOT Accept.isEnabled
                            ScrollDown.click
                            printlog "Scrolling..."
                            sleep 1
                        wend
                        '/// for testing purposes click cancel one time - the extension should not get installed ///'
                        if cInt(aTemp(1)) = 3 then
                            ExtensionSoftwareLicenseAgreement.CANCEL
                        else
                            Accept.click
                        endif
                    endif
                else
                    if cBool(aTemp(1)) then
                        errorlog "ExtensionSoftwareLicenseAgreement dialog expected but not shown."
                    endif
                endif
                
                '/// There may come up another active right now, which would be an error ///'
                Kontext
                if active.exists(5) then
                    sTemp = active.getText
                    if i = 7 then
                        qaerrorlog "#i67452# " + sTemp
                    else
                        warnlog sTemp
                    endif
                    active.ok
                endif
                
                '/// the progress dialog is now available again ///'
                Kontext "AddingPackages"
                x=0
                while AddingPackages.exists(1) AND (x<6)
                    printlog "AddingPackages..."
                    sleep 5
                    x=x+1
                wend
                
                '/// There may come up another active right now, which would be an error ///'
                Kontext
                if active.exists(5) then
                    sTemp = active.getText
                    warnlog sTemp
                    active.ok
                endif

            ' find out, if the extension got installed
            kontext "PackageManager"
            BrowsePackages.typeKeys("<home>")
            BrowsePackages.typeKeys("+")
            y = BrowsePackages.getItemCount
            sTemp = aFiles(i)
            x = instr(sTemp, "\")
            sTemp = mid(sTemp,x+1)
            printlog stemp
            bFound = FALSE
            for x = 1 to y
                sTemp2 = BrowsePackages.getItemText(x)
                printlog "("+x+"/"+y+"): "+sTemp2
                ' Mechanism to detect a status change; report it only one time
                sTemp3 = BrowsePackages.getItemText(x,2)
                if sTemp3 <> "" AND sFirstStatus = "" then
                    sFirstStatus = sTemp3
                else
                    if (sFirstStatus <> sTemp3) AND (sTemp3 <> "") AND (sFirstStatus <> "alreadyshown") then
                        qaErrorlog "#i67450# " + sFirstStatus + " <> " + sTemp3
                        sFirstStatus= "alreadyshown"
                    endif
                endif
                if sTemp3 <> "" then
                    printlog "   +++ " + sTemp3
                endif
                if sTemp = sTemp2 then
                    listAppend(aRemovePackages(), sTemp)
                    if cBool(aTemp(2)) then
                        printlog  "-------------------------------- Extension got installed"
                        bFound = TRUE
                    else
                        warnLog "-------------------------------- Extension got installed, but shouldn't do that"
                    endif
                endif
            next x
            if NOT cBool(aTemp(2)) and bFound then
                warnlog "not found"
            endif
            '/// Close extension manager ///'
            PackageManager.OK
            'OK / Close
        else
            warnlog "Couldn't call Tools -> Package manager - aborting test at " + i
            goto endsub
        endif
    next i
    
    '/// after installing all extensions, remove them ///'
    ' uninstall all components, that were installed
    a = listCount(aRemovePackages())
        ToolsPackageManager
        kontext "PackageManager"
        If PackageManager.exists(10) then
            BrowsePackages.typeKeys("<home>")
            sTemp = BrowsePackages.getSelText
            sTemp2 = ""
            while (sTemp <> sTemp2)
                kontext "PackageManager"
                BrowsePackages.typeKeys("+")
                BrowsePackages.typeKeys("<down>")
                sTemp2 = sTemp
                sTemp = BrowsePackages.getSelText
                if right(sTemp,3) = "oxt" then
                    for x = 1 to a
                        if sTemp = aRemovePackages(x) then
                            printlog "Package is installed, trying to remove it: '" + sTemp + "'"
                            if remove.isEnabled then
                                remove.click
                                Kontext "AddingPackages"
                                y=0
                                while AddingPackages.exists(1) AND (y<6)
                                    printlog "RemovingPackages..."
                                    sleep 5
                                    y=y+1
                                wend
                                kontext "PackageManager"
                                BrowsePackages.typeKeys("<up>")
                            else
                                warnlog "Package can't get removed: '" + sTemp + "'"
                            endif
                        endif
                    next x
                endif
            wend
            kontext "PackageManager"
            PackageManager.close
            sleep 5
        else
            qaErrorLog "disabling installed extensions failed;"
        endif
    
    hCloseDocument()
endcase


