'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_ole.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:52 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Chart resource test - section FILE
'*
'************************************************************************
'*
' #1 ch_ole        ' Initial routine
' #1 tChartOLE
'*
'\************************************************************************

sub ch_ole

  printLog Chr(13) + "---------  CH_OLE   ----------"

  Call tChartOLE("WRITER")
  Call tChartOLE("CALC")
  Call tChartOLE("IMPRESS")
  Call tChartOLE("DRAW")
  Call tChartOLE("HTMLDOKUMENT")
  Call tChartOLE("MASTERDOC")

End Sub

'*******************************************************************

testcase tChartOLE(sCurrentApplication as STRING)
'///<u><b>Chart as OLE in all applicable applications</b></u>///
dim sOutputFile as STRING
    sOutputFile = (gOfficePath & ConvertPath("user\work\") & "tChartOLE_" & sCurrentApplication)
dim bCommitDialog as boolean
    select case sCurrentApplication
      case ("WRITER")       : bCommitDialog = TRUE
      case ("CALC")         : bCommitDialog = FALSE
      case ("IMPRESS")      : bCommitDialog = FALSE
      case ("DRAW")         : bCommitDialog = FALSE
      case ("HTMLDOKUMENT") : bCommitDialog = TRUE
      case ("MASTERDOC")    : bCommitDialog = TRUE
    end select
'///<ul>
  printLog("Chart as OLE in " & sCurrentApplication)
  gApplication = sCurrentApplication

  '///<li>Open new document</li>///
  Call hNewDocument
  '///<li>Insert default chart</li>///
  InsertChart
  sleep(2)
  if bCommitDialog then
     Kontext "AutoFormatDiagramm1"
       Fertigstellen.Click
     sleep(2)
  endif
  '///<li>Save file</li>///
  if hSpeichernUnterKill(sOutputFile) then
     printlog "OK, successfully saved the test document!"
  else
     warnlog "Saving the testdocument failed!"
  endif
  sleep(2)
  '///<li>Leave implace mode in Spreadsheet, Draw and Impress ...</li>///
  '///<li>... and then select Chart OLE (Green handles)</li>///
  select case sCurrentApplication
      case ("CALC")    : call gMouseclick (99,99) : selectFirstOLE
      case ("IMPRESS") : call gMouseclick (99,99) : call gMouseclick (50,50)
      case ("DRAW")    : call gMouseclick (99,99) : call gMouseclick (50,50)
  end select
  '///<li>Try if Edit::Object:Edit works for chart OLE</li>///
  try
      EditObjectEdit
      sleep(2)
      printlog "Edit::Object::Edit seems to work"
  catch
      warnlog "Edit::Object::Edit seems to fail -> Check this out!"
  endcatch
  '///<li>WORKAROUD to prevent crash #.....#: Click in right bottom corner</li>///
  call gMouseclick (99,99)
  '///<li>Close document</li>///
  Call hCloseDocument
  gApplication = "Calc"
  '///</ul>
endcase

