'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_010_.inc,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: jsi $ $Date: 2006/08/17 13:51:17 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Check other calc functions like accesibility, autocomplete ...
'*
'*************************************************************************************************
'*
' #1 C_010_ ' Initial routine
' #1 tAutocomplete
' #1 tNaturalLanguage
' #1 tKeyJump
' #1 tKeyMark
' #1 tKeySizeWidth
' #1 tNextTable
' #1 tRelativAbsolut
'*
'\************************************************************************************************

sub C_010_

Printlog Chr(13) + "--------- C_010_ ---------"

    call ExitRestartTheOffice
    Call tAutocomplete
    Call tNaturalLanguage
    Call tKeyJump
    call tKeyMark
    call tKeySizeWidth
    call tNextTable
    call tRelativAbsolut

End sub
'
'-----------------------------------------------------------
'
testcase tAutocomplete

        Dim firstChar$, complStr$, cellContain$
        Printlog "* Autocomplete"

        select case iSprache
               case 01   : firstChar$ = "=Su" : complStr$ = "=SUM()"    'Englisch
               case 03   : firstChar$ = "=SO" : complStr$ = "=SOMA()"   'Portugiesisch
               case 07   : firstChar$ = "=Su" : complStr$ = "=SUM()"    'Russian
               case 31   : firstChar$ = "=SO" : complStr$ = "=SOM()"    'Niederlaendisch
               case 33   : firstChar$ = "=SO" : complStr$ = "=SOMME()"  'Franzoesisch
               case 34   : firstChar$ = "=SU" : complStr$ = "=SUMA()"   'Spanisch
               case 39   : firstChar$ = "=SO" : complStr$ = "=SOMMA()"  'Italienisch
               case 45   : firstChar$ = "=Su" : complStr$ = "=SUM()"    'D��nisch
               case 46   : firstChar$ = "=SU" : complStr$ = "=SUMMA()"  'Schwedisch
               case 48   : firstChar$ = "=Su" : complStr$ = "=SUMA()"   'Polnisch
               case 49   : firstChar$ = "=Su"  : complStr$ = "=SUMME()"  'Deutsch
               case 55   : firstChar$ = "=SO"  : complStr$ = "=SOMA()"  'Brasilian/Portuguese
               case 81   : firstChar$ = "=Su"  : complStr$ = "=SUM()"    'japanese
               case 82   : firstChar$ = "=Su"  : complStr$ = "=SUM()"    'korean
               case 86   : firstChar$ = "=Su"  : complStr$ = "=SUM()"    'chinese simple
               case 88   : firstChar$ = "=Su"  : complStr$ = "=SUM()"    'chinese traditional
               case else : QAErrorlog "The language adjustment is still missing" : goto endsub
        end select
        
        call createC_010_Testdoc
        sleep(2)
        
        call cgotocell ("B8")
        DocumentCalc.typekeys(complStr$)
        DocumentCalc.typekeys("<RETURN>")
        
        call cgotocell ("C8")
        DocumentCalc.typekeys(firstChar$)
        DocumentCalc.TypeKeys("<RETURN><RETURN>")
        cellContain$ = cZellinhalt("C8")
        if cellContain$ = complStr$ then
        Printlog "  Autocomplete work"
        else
        Warnlog "Autocomplete doesn't work " & cellContain$ & " instead of " & complStr$
        end if
        call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tNaturalLanguage
Dim firstChar$, complStr$, cellContain$
Printlog "* Natural Language"

printlog "iSprache: " & iSprache
select case iSprache
  case 01       : firstChar$ = "=SUM"
  case 03       : firstChar$ = "=SOMA"
  case 07       : firstChar$ = "=SUM"
  case 31       : firstChar$ = "=SOM"
  case 33       : firstChar$ = "=SOMME"
  case 34       : firstChar$ = "=SUMA"
  case 39       : firstChar$ = "=SOMMA"
  case 45       : firstChar$ = "=SUM"
  case 46       : firstChar$ = "=SUMMA"
  case 48       : firstChar$ = "=SUMA"
  case 49       : firstChar$ = "=SUMME"
  case 55       : firstChar$ = "=SOMA"
  case 82       : firstChar$ = "=SUM"
  case 86       : firstChar$ = "=SUM"
  case 88       : firstChar$ = "=SUM"
  case else     : QAErrorlog "The language adjustment is still missing" : goto endsub
end select

  call createC_010_Testdoc
  sleep(2)

  call cgotocell ("C8")
  Kontext "DocumentCalc"
  DocumentCalc.typekeys(firstChar$ & "(Spalte1)<RETURN>")
  cellContain$ = cZellwert("C8")

    if cellContain$ = "104" then
      Printlog "Natural Language work in one column"
    else
      Warnlog "Natural Language doesn't work in one column " & cellContain$ & " instead of 104"
      warnlog "Could be bug: 94899"
    end if

  call cgotocell ("H3")
  Kontext "DocumentCalc"
  DocumentCalc.typekeys(firstChar$ & "(Zeile1)<RETURN>")
    cellContain$ = cZellwert("H3")
    if cellContain$ = "50" then
      Printlog "  Natural Language work in one row"
    else
      Warnlog "Natural Language doesn't work in one row " & cellContain$ & " instead of 50"
      warnlog "Could be bug: 94899"
    end if

  call cgotoCell("C3")
  Kontext "DocumentCalc"
    DocumentCalc.typekeys ("0<Return>")

    if czellwert("H3") <> 39 then
      Warnlog "Modified value isn't updated in rowsum"
    else
      Printlog "Modified value is updated in rowsum"
    end if
    if czellwert("C8") <> 93 then
      Warnlog "Modified value isn't updated in columnsum"
    else
      Printlog "Modified value is updated in columnsum"
    end if
  call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tKeyJump
Dim firstChar$, complStr$, cellContain$
Printlog "* Keyboard Navigation"
call createC_010_Testdoc
sleep(2)

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 HOME>")
  if fWhereIsTheCellCursor = "A1" then
    Printlog "  CTRL + HOME jumped from D4 to cell A1"
  else
    Warnlog "CTRL + HOME didn't jump from D4 to A1 but" & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 END>")
  if fWhereIsTheCellCursor = "P28" then
    Printlog "  CTRL + END jumped from D4 to cell P28 the point of intersection from last column and row with datainput"
  else
    Warnlog "CTRL + END didn't jump from D4 to P28 the point of intersection from last column and row with datainput but" & fWhereIsTheCellCursor
  end if

  kontext "DocumentCalc"
  DocumentCalc.typekeys("<HOME>")
  if fWhereIsTheCellCursor = "A28" then
    Printlog "  HOME jumped to the first column from the table"
  else
    Warnlog "HOME didn't jump to the first column from the table but " & fWhereIsTheCellCursor
  end if

  Kontext "DocumentCalc"
  DocumentCalc.typekeys("<END>")
  if fWhereIsTheCellCursor = "P28" then
    Printlog "  END jumped to the last column with contents"
  else
    Warnlog "END didn't jump to the last column with contents but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 LEFT>")
  if fWhereIsTheCellCursor = "B4" then
    Printlog "  CTRL + LINKS jumped from D4 to the first column of the range"
  else
    Warnlog "CTRL + LINKS didn't jump from D4 to the first column of the range but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 RIGHT>")
  if fWhereIsTheCellCursor = "F4" then
    Printlog "  CTRL + RECHTS jumped from D4 to the last column of the range"
  else
    Warnlog "CTRL + RECHTS didn't jump from D4 to the last column of the range but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 UP>")
  if fWhereIsTheCellCursor = "D2" then
    Printlog "  CTRL + HOCH jumped from D4 to the first row of the range"
  else
    Warnlog "CTRL + HOCH didn't jump from D4 to the first row of the range but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 DOWN>")
  if fWhereIsTheCellCursor = "D6" then
    Printlog "  CTRL + DOWN jumped from D4 to the last row of the range"
  else
    Warnlog "CTRL + DOWN didn't jump from D4 to the last row of the range  but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 DOWN DOWN>")
  if fWhereIsTheCellCursor = "D24" then
    Printlog "  CTRL + DOWN + DOWN jumped from D4 to the first row of the second range (D24)"
  else
    Warnlog "CTRL + DOWN + DOWN didn't jump from D4 to the first row of the second range (D24) but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 DOWN DOWN DOWN DOWN>")
  if fWhereIsTheCellCursor = "D65536" then
    Printlog "  CTRL + DOWN + DOWN + DOWN + DOWN jumped from D4 to the last row of the table (D65536)"
    Printlog "This should be StarOffice Calc after the row limit (=65536) was enhanced"
  else
    if fWhereIsTheCellCursor = "D32000" then
       Printlog "  CTRL + DOWN + DOWN + DOWN + DOWN jumped from D4 to the last row of the table (D32000)"
       QaErrorLog "This should be StarOffice Calc before the row limit (32000 -> 65536) was enhanced"
    else
       Warnlog "CTRL + DOWN + DOWN + DOWN + DOWN didn't jump from D4 to the last row of the table (D65536) but " & fWhereIsTheCellCursor
    end if
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 LEFT LEFT>")
  if fWhereIsTheCellCursor = "A4" then
    Printlog "  CTRL + LEFT + LEFT jumped from D4 to the first column of the table"
  else
    Warnlog "CTRL + LEFT + LEFT didn't jump from D4 to the first column of the table but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 RIGHT RIGHT>")
  if fWhereIsTheCellCursor = "L4" then
    Printlog "  CTRL + RIGHT + RIGHT jumped from D4 to the first column of the second range"
  else
    Warnlog "CTRL + RIGHT + RIGHT didn't jump from D4 to the first column of the second range but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 RIGHT RIGHT RIGHT RIGHT>")
  if fWhereIsTheCellCursor = "IV4" then
    Printlog "  CTRL + RIGHT + RIGHT + RIGHT + RIGHT jumped from D4 to the last column of the table table"
  else
    Warnlog "CTRL + RIGHT + RIGHT + RIGHT + RIGHT didn't jump from D4 to the last column of the table table but " & fWhereIsTheCellCursor
  end if
  call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tKeyMark
Dim firstChar$, complStr$, cellContain$
Printlog "* Keyboard Marks"
call createC_010_Testdoc
sleep(2)

  call cgotoCell("D4")
  Kontext "DocumentCalc"
  DocumentCalc.typekeys("<SHIFT LEFT DOWN>")
  if fWhereIsTheCellCursor = "C4:D5" then
    Printlog "  SHIFT + LEFT + DOWN has marked the cells C4:D5"
  else
    Warnlog "SHIFT + LEFT + DOWN hasn't marked the cells C4:D5 but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 SHIFT RIGHT UP>")
  if fWhereIsTheCellCursor = "D2:F4" then
    Printlog "  CTRL + SHIFT + RIGHT + HOCH has marked the cells D2:F4 "
  else
    Warnlog "CTRL + SHIFT + RIGHT + HOCH hasn't marked the cells D2:F4 but " & fWhereIsTheCellCursor
  end if

  call cgotoCell("A1")
  DocumentCalc.typekeys("<MOD1 SHIFT RIGHT DOWN>")
  if fWhereIsTheCellCursor = "A1:IV65536" then
     Printlog "  CTRL + SHIFT + RIGHT + DOWN has marked the cells A1:IV65536 "
  else
     if fWhereIsTheCellCursor = "A1:IV32000" then
        Printlog "  CTRL + SHIFT + RIGHT + DOWN has marked the cells A1:IV32000 "
        QaErrorLog "This should be StarOffice Calc before the row limit (32000 -> 65536) was enhanced"
     else
        Warnlog "CTRL + SHIFT + RIGHT + DOWN hasn't marked the cells A1:IV32000 but " & fWhereIsTheCellCursor
     end if
  end if

  call cgotoCell("D4")
  DocumentCalc.typekeys("<MOD1 MULTIPLY>")
  sleep (2)
  if fWhereIsTheCellCursor = "B2:F6" then
    Printlog "  CTRL + * has marked the cells B2:F6"
  else
    Warnlog "CTRL + * hasn't marked the cells B2:F6 but " & fWhereIsTheCellCursor
  end if


  call cgotoCell("D4")
  Kontext "DocumentCalc"
  DocumentCalc.typekeys("<MOD1 MULTIPLY>")
  DocumentCalc.typekeys "<RETURN><RETURN><RETURN><RETURN><RETURN><RETURN><RETURN><RETURN>"
  sleep(2)
  DocumentCalc.typekeys "<F2>"
  sleep(2)
  DocumentCalc.typekeys "<MOD1 A>"
  sleep(2)
  EditCopy
  sleep(2)
  if getclipboardtext = "Spalte4" then
    Printlog "  RETURN in a section has changed the cells in it"
  else
    Warnlog "  RETURN in a section has lost the range"
  end if

  call cgotoCell("D4")
  Kontext "DocumentCalc"
  DocumentCalc.typekeys("<MOD1 MULTIPLY>")
  DocumentCalc.typekeys "<SHIFT RETURN><SHIFT RETURN>"
  sleep(2)
  DocumentCalc.typekeys "<F2>"
  sleep(2)
  DocumentCalc.typekeys "<MOD1 A>"
  sleep(2)
  EditCopy
  sleep(2)
  if getclipboardtext = "Spalte2" then
     Printlog "  SHIFT RETURN has changed reward the cells in a selection"
  else
     Warnlog "  SHIFT RETURN in a selection has lost this selection. Clipboard contains: " & getclipboardtext
  end if

  call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tKeySizeWidth
Dim WatNu,WatWas, WatIsZ, WatIsS
Printlog "* Keyboard modify columnwidth"
If gplatgroup = "unx" then Printlog "  In Exceed the Keyboardfunction ALT doesn't work"
call createC_010_Testdoc
sleep(2)

  call cGotoCell("M13")
    WatIsS = wiebreit
    printlog "Width " & WatisS

    Kontext "DocumentCalc"
    DocumentCalc.Typekeys("<MOD2 LEFT LEFT>")
      Watnu = wiebreit
      WatWas = WatNu
      if Watnu = WatisS then
        Warnlog "ALT + LEFT + LEFT hasn't modify the columnwidth"
      elseif Watnu > WatisS then
        Warnlog "ALT + LEFT + LEFT has increased the columnwidth"
      else
        Printlog "  ALT + LEFT + LEFT has decreased the columnwitdh from " & WatisS & " about " & cdbl(WatisS) - cdbl(Watnu) & " downto " & Watnu
      end if

    Kontext "DocumentCalc"
    DocumentCalc.Typekeys("<MOD2 RIGHT RIGHT>")
      Watnu = wiebreit
      if Watnu = WatisS then
        Printlog "  ALT + RIGHT + RIGHT has set the default columnwidth"
      elseif Watnu < WatisS then
        Warnlog "ALT + RIGHT + RIGHT has increased the columnwidth to small"
      elseif Watnu > WatisS then
        Warnlog "ALT + RIGHT + RIGHT has increased the columnwidth too much"
      else WatNu = WatWas
        Warnlog "ALT + RIGHT + RIGHT hasn't modified the columnwidth"
      end if

    Kontext "DocumentCalc"
    DocumentCalc.Typekeys("<MOD2 RIGHT RIGHT>")
      Watnu = wiebreit
      WatWas = WatNu
      if Watnu = WatisS then
        Warnlog "ALT + RIGHT + RIGHT hasn't modified the columnwidth"
      elseif Watnu < WatisS then
        Warnlog "ALT + RIGHT + RIGHT has decreased the columnwidth"
      else
        Printlog "  ALT + RIGHT + RIGHT has decreased columnwidth from " & WatisS & " about " & cdbl(WatisS) - cdbl(Watnu) & " downto " & Watnu
      end if

    Kontext "DocumentCalc"
    DocumentCalc.Typekeys("<MOD2 LEFT LEFT>")
      Watnu = wiebreit
      if Watnu = WatisS then
        Printlog "  ALT + LEFT + LEFT has set the default columnwidth"
      elseif Watnu > WatisS then
        Warnlog "ALT + LEFT + LEFT has set columnwidth to big"
      elseif Watnu < WatisS then
        Warnlog "ALT + LEFT + LEFT has set columnwidth to small"
      else WatNu = WatWas
        Warnlog "ALT + LEFT + LEFT hasn't modified the columnwidth"
      end if


    Kontext "DocumentCalc"
    DocumentCalc.typekeys("<LEFT>")
      watwas = wiebreit
    Kontext "DocumentCalc"
    DocumentCalc.Typekeys("What should i say?<RETURN UP>")
      FormatColumnOptimalWidthCalc
      Kontext "SpalteOptimaleBreite"
        SpalteOptimaleBreite.Ok
        WatisS = wiebreit

    Kontext "DocumentCalc"
    DocumentCalc.typekeys("<RIGHT>")
    DocumentCalc.Typekeys("What should i say?<RETURN UP>")
    DocumentCalc.Typekeys("<MOD2 SHIFT LEFT>")
      Watnu = wiebreit
      if cdbl(Watnu) > cdbl(WatisS) - cdbl(WatisS) * 0.01 and cdbl(Watnu) < cdbl(WatisS) + cdbl(WatisS) * 0.01 then
        Printlog "  ALT + SHIFT + LEFT has optimized the columnwidth (+/- 1%)"
      elseif cdbl(Watnu) > cdbl(WatisS) then
        Warnlog "ALT + SHIFT + LEFT has increased the columnwidth too much"
      elseif cdbl(Watnu) < cdbl(WatisS) - cdbl(WatisS) * 0.01 then
        printlog "ALT + SHIFT + LEFT has increased the columnwidth too little"
      else WatNu = WatWas
        Warnlog "ALT + SHIFT + LEFT hasn't modified the columnwidth"
      end if
      watisS = Watnu

    Kontext "DocumentCalc"
    DocumentCalc.Typekeys("<DELETE>")
    Kontext "Inhalteloeschen"
    Inhalteloeschen.Ok
    Printlog "Cellcontents deleted"
    Kontext "DocumentCalc"
    DocumentCalc.Typekeys("<MOD2 SHIFT LEFT>")
      Watnu = wiebreit
      if Watnu = Watwas then
        Printlog "  ALT + SHIFT + LEFT has reset the columnwidth to default"
      elseif Watnu > Watwas and Watnu < WatisS then
        Warnlog "ALT + SHIFT + LEFT has decreased the columnwidth too little"
      elseif Watnu < WatisS then
        Warnlog "ALT + SHIFT + LEFT has decreased the columnwidth too much"
      else WatNu = WatisS
        Warnlog "ALT + SHIFT + LEFT hasn't modified the columnwidth"
      end if

  call hCloseDocument
endcase
'- - - - - - - - - - - - - - - - -
testcase tNextTable
printlog "- Tabellenblaetter wechseln"
dim ichheisse$, ichbin1$, ichbin2$, ichbin3$, ichbin4$

   select case isprache
        case 01   : ichheisse$ = "Sheet"
          case 03   : ichheisse$ = "Folha"
          case 07   : ichheisse$ = "Лист"
          case 31   : ichheisse$ = "Werkblad"
          case 33   : ichheisse$ = "Feuille"
          case 34   : ichheisse$ = "Hoja"
          case 39   : ichheisse$ = "Tabella"
          case 45   : ichheisse$ = "Ark"
          case 46   : ichheisse$ = "Tabell"
          case 48   : ichheisse$ = "Arkusz"
          case 49   : ichheisse$ = "Tabelle"
          case 55   : ichheisse$ = "Planilha"
          case 81   :   printlog "No adjustment available in language 81"
          case 82   :   printlog "No adjustment available in language 82"
          case 86   :   printlog "No adjustment available in language 86"
          case 88   :   printlog "No adjustment available in language 88"
      case else : QAErrorlog "The language adjustment is missing" : goto endsub
    end select

  call createC_010_Testdoc
  sleep(2)
  call fCalcSelectSheet ( 1 )

  ichbin1$ = werbistdu
    Printlog "  start bei " & ichheisse$ & ichbin1$
    Kontext "DocumentCalc"
    DocumentCalc.Typekeys "<MOD1 PAGEDOWN>"

  ichbin2$ = werbistdu
    if ichbin2$ = "2" then
      Printlog "  CTRL + BILD DOWN has been changed to tabel" & ichbin2$
    else
      Warnlog "  CTRL + PAGE DOWN hasn't been changed to table2 but to table" & ichbin2$
    end if
    Kontext "DocumentCalc"
    DocumentCalc.Typekeys "<MOD1 PAGEDOWN>"

  ichbin3$ = werbistdu
    if ichbin3$ = "3" then
      Printlog "  CTRL + PAGE DOWN is changed to table" & ichbin3$
    else
      Warnlog "  CTRL + PAGE DOWN isn't changed to table3 but to table" & ichbin3$
    end if
    Kontext "DocumentCalc"
    DocumentCalc.Typekeys "<MOD1 PAGEDOWN>"

  ichbin3$ = werbistdu
    if ichbin3$ = "3" then
      Printlog "  CTRL + PAGE DOWN on the last table doesn't change"
    else
      Warnlog "  CTRL + PAGE DOWN on the last table is change to table" & ichbin3$
    end if
    Kontext "DocumentCalc"
    DocumentCalc.Typekeys "<MOD1 PAGEUP PAGEUP>"

  ichbin1$ = werbistdu
    if ichbin1$ = "1" then
      Printlog "  CTRL + PAGEUP + PAGEUP is change to table" & ichbin1$
    else
      Warnlog "  CTRL + PAGEUP + PAGEUP isn't changed to table1 but to" & ichbin1$
    end if
    Kontext "DocumentCalc"
    DocumentCalc.Typekeys "<MOD1 PAGEUP>"

  ichbin1$ = werbistdu
    if ichbin1$ = "1" then
      Printlog "  CTRL + PAGEUP on the first table doesn't changed"
    else
      Warnlog "  CTRL + PAGEUP on the first table is changed to table" & ichbin1$
    end if

  call hCloseDocument
endcase
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
testcase tRelativAbsolut

Dim sheettag$, function$, wo$, ref(12)

Printlog "Modify references"
    select case isprache
      case 01   : sheettag$ = "Sheet"    : function$ = "sum"
      case 03   : sheettag$ = "Folha"    : function$ = "soma"
      case 07   : sheettag$ = "Лист"    : function$ = "sum"
      case 31   : sheettag$ = "Werkblad" : function$ = "som"
      case 33   : sheettag$ = "Feuille"  : function$ = "somme"
      case 34   : sheettag$ = "Hoja"     : function$ = "suma"
      case 39   : sheettag$ = "Tabella"  : function$ = "somma"
      case 45   : sheettag$ = "Ark"              : function$ = "sum"
      case 46   : sheettag$ = "Tabell"   : function$ = "summa"
      case 48   : sheettag$ = "Arkusz"   : function$ = "suma"
      case 49   : sheettag$ = "Tabelle"  : function$ = "summe"
      case 55   : sheettag$ = "Planilha"    : function$ = "soma"
      case 81   :       printlog "No adjustment available"      : call hCloseDocument: goto endsub
      case 82   :       printlog "No adjustment available"      : call hCloseDocument: goto endsub
      case 86   :       printlog "No adjustment available"  : call hCloseDocument: goto endsub
      case 88   :       printlog "No adjustment available"  : call hCloseDocument: goto endsub
      case else : QAerrorlog "The langage adjustment is still missing" : goto endsub
    end select

  call createC_010_Testdoc
  sleep(2)

  call fCalcSelectSheet ( 2 )
  call atGeheZuA1
    Kontext "DocumentCalc"
    DocumentCalc.Typekeys ("1<RETURN>2<RETURN>3<RETURN>4<RETURN><RIGHT><UP>5<UP>6<UP>7<UP>8<RETURN>"
    call cgotocell("C5")
      DocumentCalc.typekeys ("=A1<RETURN>")
      DocumentCalc.typekeys ("=" & function$ & "(A1:B4)<RETURN>")
      DocumentCalc.typekeys ("=" & sheettag$ & "1.C3<RETURN>")
      DocumentCalc.typekeys ("=" & function$ & "(" & sheettag$ & "1.C3:D6)<RETURN>")
      DocumentCalc.typekeys ("=" & chr$(39) & convertpath(gtesttoolpath & "calc/update/input/c_010/zusuchen.sxc") & chr$(39) & "#Wurmloch.E15<RETURN>")
      DocumentCalc.typekeys ("=" & function$ & "(" & chr$(39) & convertpath(gtesttoolpath & "calc/update/input/c_010/zusuchen.sxc") & chr$(39) & "#Wurmloch.E15:F18)<RETURN>"


    'C5 einfacher Zellbezug
    printlog "Reference modify with a simple cellreference"
      wo$ = "c5"
      ref(0) = 4
      ref(1) = "=A1"
      ref(2) = "=$A$1"
      ref(3) = "=A$1"
      ref(4) = "=$A1"
      ref(5) = "" : ref(6) = "" : ref(7) = "" : ref(8) = "" : ref(9) = "" : ref(10) = "" : ref(11) = "" : ref(12) = ""
    call referenz(wo$,ref())

    'C6 Summe von Zellbereich
    printlog "Refernce modify with a summmarize of a cellrange"
      wo$ = "C6"
      ref(0) = 4
      ref(1) = "=" & function$ & "(A1:B4)"
      ref(2) = "=" & function$ & "($A$1:$B$4)"
      ref(3) = "=" & function$ & "(A$1:B$4)"
      ref(4) = "=" & function$ & "($A1:$B4)"
      ref(5) = "" : ref(6) = "" : ref(7) = "" : ref(8) = "" : ref(9) = "" : ref(10) = "" : ref(11) = "" : ref(12) = ""
    call referenz(wo$,ref())

    'C7 einfacher Zellbezug auf ein anderes Tabellenblatt
    printlog "Reference modify with a simple reference to another table"
      wo$ = "C7"
      ref(0) = 8
      ref(1) = "=" & sheettag$ & "1.C3"
      ref(2) = "=$" & sheettag$ & "1.$C$3"
      ref(3) = "=$" & sheettag$ & "1.C$3"
      ref(4) = "=$" & sheettag$ & "1.$C3"
      ref(5) = "=$" & sheettag$ & "1.C3"
      ref(6) = "=" & sheettag$ & "1.$C$3"
      ref(7) = "=" & sheettag$ & "1.C$3"
      ref(8) =  "=" & sheettag$ & "1.$C3"
      ref(9) = "" : ref(10) = "" : ref(11) = "" : ref(12) = ""
    call referenz(wo$,ref())

    'C8 Summe von Zellbereich auf einem anderen Tabellenblatt
    printlog "Reference modify with a summarize of a cellrange to another table"
      wo$ = "C8"
      ref(0) = 8
      ref(1) = "=" & function$ & "(" & sheettag$ & "1.C3:D6)"
      ref(2) = "=" & function$ & "($" & sheettag$ & "1.$C$3:$D$6)"
      ref(3) = "=" & function$ & "($" & sheettag$ & "1.C$3:D$6)"
      ref(4) = "=" & function$ & "($" & sheettag$ & "1.$C3:$D6)"
      ref(5) = "=" & function$ & "($" & sheettag$ & "1.C3:D6)"
      ref(6) = "=" & function$ & "(" & sheettag$ & "1.$C$3:$D$6)"
      ref(7) = "=" & function$ & "(" & sheettag$ & "1.C$3:D$6)"
      ref(8) =  "=" & function$ & "(" & sheettag$ & "1.$C3:$D6)"
      ref(9) = "" : ref(10) = "" : ref(11) = "" : ref(12) = ""
    call referenz(wo$,ref())

    'C9 einfacher Zellbezug auf eine Tabellenblatt einer anderen Datei
    select case gPlatgroup
      case "unx" : sheettag$ = chr$(39) & "file://" & gtesttoolpath & "calc/update/input/c_010/zusuchen.sxc" & chr$(39)
      case else  : sheettag$ = chr$(39) & "file:///" & ReplaceCharacter(gtesttoolpath,"\","/") & "calc/update/input/c_010/zusuchen.sxc" & chr$(39)
    end select

    printlog "Reference modify with a simple cellreference to another table of another file"
      wo$ = "C9"
      ref(0) = 4
      ref(1) = "=" & sheettag$ & "#$Wurmloch.E15"
      ref(2) = "=" & sheettag$ & "#$Wurmloch.$E$15"
      ref(3) = "=" & sheettag$ & "#$Wurmloch.E$15"
      ref(4) = "=" & sheettag$ & "#$Wurmloch.$E15"
      ref(5) = "" : ref(6) = "" : ref(7) = "" : ref(8) = "" : ref(9) = "" : ref(10) = "" : ref(11) = "" : ref(12) = ""
    call referenz(wo$,ref())

      'C10 Summe von Zellbereich auf einem Tabellenblatt einer anderen Datei
      'same sheettag as used for C9
      printlog "Reference modify with a summarize of a cellrange to another table of another file"
        wo$ = "C10"
        ref(0) = 4
        ref(1) = "=" & function$ & "(" & sheettag$ & "#$Wurmloch.E15:F18)"
        ref(2) = "=" & function$ & "(" & sheettag$ & "#$Wurmloch.$E$15:$F$18)"
        ref(3) = "=" & function$ & "(" & sheettag$ & "#$Wurmloch.E$15:F$18)"
        ref(4) = "=" & function$ & "(" & sheettag$ & "#$Wurmloch.$E15:$F18)"
        ref(5) = "" : ref(6) = "" : ref(7) = "" : ref(8) = "" : ref(9) = "" : ref(10) = "" : ref(11) = "" : ref(12) = ""
        call referenz(wo$,ref())

call hCloseDocument
endcase
'- - - - - - - - - - - - - - - - - - - - - - - - - - - -

sub createC_010_Testdoc

        call hNewDocument
        sleep(2)

           Kontext "DocumentCalc"
           DocumentCalc.typekeys ("<RIGHT><RETURN><RIGHT>Spalte1<RIGHT>Spalte2<RIGHT>Spalte3<RIGHT>Spalte4<RETURN>")
           DocumentCalc.typekeys ("14<LEFT>13<LEFT>12<LEFT>11<LEFT>Zeile1<RETURN>")
           DocumentCalc.typekeys ("Zeile2<RIGHT>21<RIGHT>22<RIGHT>23<RIGHT>24<RETURN>")
           DocumentCalc.typekeys ("34<LEFT>33<LEFT>32<LEFT>31<LEFT>Zeile3<RETURN>")
           DocumentCalc.typekeys ("Zeile4<RIGHT>41<RIGHT>42<RIGHT>43<RIGHT>44<RETURN>")
        
           call CgotoCell("M3")
           DocumentCalc.typekeys ("Spalte5<RIGHT>Spalte6<RIGHT>Spalte7<RIGHT>Spalte8<RETURN>")
           DocumentCalc.typekeys ("14<LEFT>13<LEFT>12<LEFT>11<LEFT>Zeile5<RETURN>")
           DocumentCalc.typekeys ("Zeile6<RIGHT>21<RIGHT>22<RIGHT>23<RIGHT>24<RETURN>")
           DocumentCalc.typekeys ("34<LEFT>33<LEFT>32<LEFT>31<LEFT>Zeile7<RETURN>")
           DocumentCalc.typekeys ("Zeile8<RIGHT>41<RIGHT>42<RIGHT>43<RIGHT>44<RETURN>")
        
           call CgotoCell("B23")
           DocumentCalc.typekeys ("<RIGHT><RETURN><RIGHT>Spalte9<RIGHT>Spalte10<RIGHT>Spalte11<RIGHT>Spalte12<RETURN>")
           DocumentCalc.typekeys ("14<LEFT>13<LEFT>12<LEFT>11<LEFT>Zeile9<RETURN>")
           DocumentCalc.typekeys ("Zeile10<RIGHT>21<RIGHT>22<RIGHT>23<RIGHT>24<RETURN>")
           DocumentCalc.typekeys ("34<LEFT>33<LEFT>32<LEFT>31<LEFT>Zeile11<RETURN>")
           DocumentCalc.typekeys ("Zeile12<RIGHT>41<RIGHT>42<RIGHT>43<RIGHT>44<RETURN>")

        call hSpeichernunterkill convertpath(gOfficePath & "user/work/C_010.sxc")

end sub

