'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_chinesetranslate1.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/13 11:38:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Chinese Translation test
'*
'************************************************************************
'*
' #1 tDefaultSetting_1           'Default settings for different Chinese language
' #1 tDefaultSetting_2           'Default settings
' #1 tDefaultSetting_3           'Cursor's position
' #1 tChineseTranslate_1         'Translation for selected text
' #1 tChineseTranslate_2         'Translation for NO-selected document
' #1 tChineseTranslate_3         'Translation direction : T Chinese to S Chinese
' #1 tChineseTranslate_4         'Translation direction : S Chinese to T Chinese
' #1 tChineseTranslate_5         ''Use Taiwan , Hongkong SAR...'s statue
' #0 fSetAsian
' #0 fGetLanguageName
'*
'\***********************************************************************

testcase tDefaultSetting_1

  printlog "Default settings for different Chinese language"
 '/// <b> Default settings for different Chinese language</b>

  Call hNewDocument

  '/// Set default language(asian) for document is "Simplified Chinese"
   fSetAsian(fGetLanguageName(86))

  '/// Tools/language / Chinese translation
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"

    '/// "Traditional Chinese to Simplified Chinese" should be Checked by default
     if NOT TChineseToSChinese.IsChecked then
         warnlog "'Traditional Chinese to Simplified Chinese' should be Checked by default !"
     end if
   ChineseTranslation.Cancel

  '/// Set default language(asian) for document is "Traditional Chinese"
   fSetAsian(fGetLanguageName(88))

  '/// Tools/language / Chinese translation
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"

    '/// "Simplified Chinese to Traditional Chinese" should be Checked by default
     if NOT SChineseToTChinese.IsChecked then
         warnlog "'Simplified Chinese to Traditional Chinese' should be Checked by default !"
     end if
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tDefaultSetting_2

  printlog "Default settings "
 '/// <b> Default settings </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Tools/language / Chinese translation
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"

'    '/// "Use Taiwan,Hongkong SAR , and Macao SAR character variants"
'    '/// + should NOT be Checked by default
'     if UseSARCharacter.IsChecked then
'         warnlog "'Use Taiwan,Hongkong SAR , and Macao SAR character variants' should NOT be Checked by default !"
'     end if

    '/// "Common Terms" should NOT be Checked by default
     if TranslateCommonTerms.IsChecked then
         warnlog "'Common Terms' should NOT be Checked by default !"
     end if

    '/// Click 'Edit terms' button
     EditTerms.Click
     Kontext "ChineseDictionary"

      '/// "Traditional Chinese to Simplified Chinese" should be Checked by default
       if NOT TChineseToSChinese.IsChecked then
           warnlog "'Traditional Chinese to Simplified Chinese' should be Checked by default !"
       end if

      '/// "Reverse mapping" should NOT be Checked by default
       if ReverseMapping.IsChecked then
           warnlog "'Reverse mapping' should NOT be Checked by default !"
       end if

      '/// "Property" should be "other" by default
       if Property.GetSelIndex <> 1 then
           warnlog "'Property' should be 'Other' by default !"
       end if
     ChineseDictionary.Cancel

   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tDefaultSetting_3

  Dim sChinese1 , sChinese2 , sExpect1  as  String

  sChinese1 = "红上" :  sChinese2 = "蓝国"
  sExpect1  = "紅上"

  printlog "Cursor position"
 '/// <b> Cursor position </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input some chinese and A1 and B1 , select B1
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys sChinese1
   DocumentCalc.typeKeys "<Right>"
   sleep(1)
   DocumentCalc.typeKeys sChinese2
   DocumentCalc.typeKeys "<Home>"

  '/// Tools/language / Chinese translation , check
  '/// + "Simplified Chinese to Traditional Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check
   ChineseTranslation.OK

  '/// Check if the cursor position is changed -- Should NOT
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys "<Shift Right><Shift Left>"

   EditCopy
   if GetClipboardText <> sExpect1 then
       warnlog "#i34769# Cursor position should NOT change."
   end if    
   
  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_1

  Dim sChinese1 , sExpect1  as  String
  Dim sChinese2 , sExpect2  as  String

  sChinese1 = "红上" :  sChinese2 = "蓝国"
  sExpect1  = "红上" :  sExpect2  = "藍國"

  printlog "Translation for selected text"
 '/// <b> Translation for selected text </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input some chinese and A1 and B1 , select B1
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys sChinese1
   DocumentCalc.typeKeys "<Right>"
   DocumentCalc.typeKeys sChinese2
   DocumentCalc.typeKeys "<Shift Left><Shift Right>"

  '/// Tools/language / Chinese translation , check
  '/// + "Simplified Chinese to Traditional Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check
   ChineseTranslation.OK

  '/// Check if the only selected text is translated -- Should
   if cZellwert("A1")  <> sExpect1 then  warnlog "A1 isn't right !"
   if cZellwert("B1")  <> sExpect2 then  warnlog "B1 isn't right !"

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_2

  Dim sChinese1 , sExpect1  as  String
  Dim sChinese2 , sExpect2  as  String

  sChinese1 = "红上" :  sChinese2 = "蓝国" : 
  sExpect1  = "紅上" :  sExpect2  = "藍國"

  printlog "Translation for NO-selected document"
 '/// <b> Translation for NO-selected document </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input some chinese
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys sChinese1
   DocumentCalc.typeKeys "<Right>"
   DocumentCalc.typeKeys sChinese2

  '/// Tools/language / Chinese translation , check
  '/// + "Simplified Chinese to Traditional Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check
   ChineseTranslation.OK

  '/// Check if all document is translated -- Should
   if cZellwert("A1")  <> sExpect1 then  warnlog "A1 isn't right !"
   if cZellwert("B1")  <> sExpect2 then  warnlog "B1 isn't right !"

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_3

  Dim sChinese , sExpect  as  String

  sChinese = "红上藍國"
  sExpect  = "红上蓝国"

  printlog "Translation direction : T Chinese to S Chinese"
 '/// <b> Translation direction : T Chinese to S Chinese </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(88))

  '/// Input some chinese , include some
  '/// + tradition chinese and simplified chinese
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys sChinese

  '/// Tools/language / Chinese translation , check
  '/// + "Traditional Chinese to Simplified Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     TChineseToSChinese.Check
   ChineseTranslation.OK

  '/// Check if only traditional chinese is translated -- Should
   if cZellwert("A1")  <> sExpect then  warnlog "A1 isn't right !"

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_4

  Dim sChinese , sExpect  as  String

  sChinese = "红上藍國"
  sExpect  = "紅上藍國"

  printlog "Translation direction : S Chinese to T Chinese"
 '/// <b> Translation direction : S Chinese to T Chinese </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input some chinese , include some
  '/// + tradition chinese and simplified chinese
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys sChinese

  '/// Tools/language / Chinese translation , check
  '/// + "Simplified Chinese to Traditional Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check
   ChineseTranslation.OK

  '/// Check if only simplified chinese is translated -- Should
   if cZellwert("A1")  <> sExpect then  warnlog "A1 isn't right !"

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

function fSetAsian(sAsian as String)  as String

 'This function is set CJK language in Tools/Options/Language Settings / Languages
  ToolsOptions
  Call hToolsOptions("LANGUAGESETTINGS","LANGUAGES")
     fSetAsian = Asiatisch.GetSelText
    if sAsian = "Null" then
        Asiatisch.Select  1
        goto GoON
    end if
  try
      Asiatisch.Select  sAsian
  catch
      QAErrorLog "Failed to select asian document language. Most of the time this doesn't cause any problem."
  endcatch
  GoON:
  Kontext "ExtrasOptionenDlg"
  ExtrasOptionenDlg.OK

end function

'*****************************************************************
' This routine will return the Language name based on CountryID
'*****************************************************************
function fGetLanguageName( CountryID as Integer ) as String

  select case iSprache
      case 01   :        ' English (USA)
           select case CountryID
                  case 1:  fGetLanguageName = "English (USA)"
                  case 33: fGetLanguageName = "French (France)"
                  case 34: fGetLanguageName = "Spanish (Spain)"
                  case 39: fGetLanguageName = "Italian (Italy)"
                  case 46: fGetLanguageName = "Swedish (Sweden)"
                  case 49: fGetLanguageName = "German (Germany)"
                  case 55: fGetLanguageName = "Portuguese (Brazil)"
                  case 81: fGetLanguageName = "Japanese"
                  case 82: fGetLanguageName = "Korean (RoK)"
                  case 86: fGetLanguageName = "Chinese (simplified)"
                  case 88: fGetLanguageName = "Chinese (traditional)"
                  case else :
                           QAErrorLog "Now, the test does not support for the language " +iSprache
                           fGetLanguageName = ""
           end select
      case 33   :        ' France
           select case CountryID
                  case 1:  fGetLanguageName = "Anglais (U.S.A.)"
                  case 33: fGetLanguageName = "Français (France)"
                  case 34: fGetLanguageName = "Espagnol (Espagne)"
                  case 39: fGetLanguageName = "Italien (Italie)"
                  case 46: fGetLanguageName = "Suédois (Suède)"
                  case 49: fGetLanguageName = "Allemand (Allemagne)"
                  case 55: fGetLanguageName = "Portugais (Brésil)"
                  case 81: fGetLanguageName = "Japonais"
                  case 82: fGetLanguageName = "Coréen"
                  case 86: fGetLanguageName = "Chinois (simplifié)"
                  case 88: fGetLanguageName = "Chinois (traditionnel)"
                  case else :
                           QAErrorLog "Now, the test does not support for the language " +iSprache
                           fGetLanguageName = ""
           end select
      case 34   :        ' Spanish
           select case CountryID
                  case 1:  fGetLanguageName = "Inglés (EE.UU.)"
                  case 33: fGetLanguageName = "Francés (Francia)"
                  case 34: fGetLanguageName = "Español (España)"
                  case 39: fGetLanguageName = "Italiano (Italia)"
                  case 46: fGetLanguageName = "Sueco (Suecia)"
                  case 49: fGetLanguageName = "Alemán (Alemania)"
                  case 55: fGetLanguageName = "Portugués (Brasil)"
                  case 81: fGetLanguageName = "Japonés"
                  case 82: fGetLanguageName = "Coreano"
                  case 86: fGetLanguageName = "Chino (simple)"
                  case 88: fGetLanguageName = "Chino (tradicional)"
                  case else :
                           QAErrorLog "Now, the test does not support for the language " +iSprache
                           fGetLanguageName = ""
           end select
      case 39   :        ' Italy
           select case CountryID
                  case 1:  fGetLanguageName = "Inglese (US)"
                  case 33: fGetLanguageName = "Francese (Francia)"
                  case 34: fGetLanguageName = "Spagnolo (Spagna)"
                  case 39: fGetLanguageName = "Italiano (Italia)"
                  case 46: fGetLanguageName = "Svedese (Svezia)"
                  case 49: fGetLanguageName = "Tedesco (Germania)"
                  case 55: fGetLanguageName = "Portoghese (Brasile)"
                  case 81: fGetLanguageName = "Giapponese"
                  case 82: fGetLanguageName = "Coreano"
                  case 86: fGetLanguageName = "Cinese (semplificato)"
                  case 88: fGetLanguageName = "Cinese (tradizionale)"
                  case else :
                           QAErrorLog "Now, the test does not support for the language " +iSprache
                           fGetLanguageName = ""
           end select
      case 46   :        ' Swedish
           select case CountryID
                  case 1:  fGetLanguageName = "engelska"
                  case 33: fGetLanguageName = "franska (Frankrike)"
                  case 34: fGetLanguageName = "spanska (Spanien)"
                  case 39: fGetLanguageName = "italienska (Italien)"
                  case 46: fGetLanguageName = "svenska (Sverige)"
                  case 49: fGetLanguageName = "tyska (Tyskland)"
                  case 55: fGetLanguageName = "portugisiska (Brasilien)"
                  case 81: fGetLanguageName = "japanska"
                  case 82: fGetLanguageName = "koreanska"
                  case 86: fGetLanguageName = "kinesiska (enkel)"
                  case 88: fGetLanguageName = "kinesiska (trad.)"
                  case else :
                           QAErrorLog "Now, the test does not support for the language " +iSprache
                           fGetLanguageName = ""
           end select
       case 49   :        ' German
          select case CountryID
                  case 1:  fGetLanguageName = "Englisch (USA)"
                  case 33: fGetLanguageName = "Französisch (Frankreich)"
                  case 34: fGetLanguageName = "Spanisch (Spanien)"
                  case 39: fGetLanguageName = "Italienisch (Italien)"
                  case 46: fGetLanguageName = "Schwedisch (Schweden)"
                  case 49: fGetLanguageName = "Deutsch (Deutschland)"
                  case 55: fGetLanguageName = "Portugiesisch (Brasilien)"
                  case 81: fGetLanguageName = "Japanisch"
                  case 82: fGetLanguageName = "Koreanisch"
                  case 86: fGetLanguageName = "Chinesisch (einfach)"
                  case 88: fGetLanguageName = "Chinesisch (Trad.)"
                  case else :
                           QAErrorLog "Now, the test does not support for the language " +iSprache
                           fGetLanguageName = ""
          end select
       case 55   :        ' Portuguese
          select case CountryID
                  case 1:  fGetLanguageName = "Inglês (EUA)"
                  case 33: fGetLanguageName = "Francês (França)"
                  case 34: fGetLanguageName = "Espanhol (Espanha)"
                  case 39: fGetLanguageName = "Italiano (Itália)"
                  case 46: fGetLanguageName = "Sueco (Suécia)"
                  case 49: fGetLanguageName = "Alemão (Alemanha)"
                  case 55: fGetLanguageName = "Português (Brasil)"
                  case 81: fGetLanguageName = "Japonês"
                  case 82: fGetLanguageName = "Coreano"
                  case 86: fGetLanguageName = "Chinês (simplificado)"
                  case 88: fGetLanguageName = "Chinês (Tradicional)"
                  case else :
                           QAErrorLog "Now, the test does not support for the language " +iSprache
                           fGetLanguageName = ""
          end select
      case 81   :        ' Japanese
          select case CountryID
                 case 1:  fGetLanguageName = "英語(米国)"
                 case 33: fGetLanguageName = "フランス語(フランス)"
                 case 34: fGetLanguageName = "スペイン語(スペイン)"
                 case 39: fGetLanguageName = "イタリア語(イタリア)"
                 case 46: fGetLanguageName = "スウェーデン語(スウェーデン)"
                 case 49: fGetLanguageName = "ドイツ語(ドイツ)"
                 case 55: fGetLanguageName = "ポルトガル語(ブラジル)"
                 case 81: fGetLanguageName = "日本語"
                 case 82: fGetLanguageName = "韓国語"
                 case 86: fGetLanguageName = "中国語(簡体字)"
                 case 88: fGetLanguageName = "中国語(繁体字)"
                 case else :
                          QAErrorLog "Now, the test does not support for the language " +iSprache
                          fGetLanguageName = ""
          end select
      case 82   :        ' Korean
          select case CountryID
                 case 1:  fGetLanguageName = "영어(미국)"
                 case 33: fGetLanguageName = "스페인어(스페인)"
                 case 34: fGetLanguageName = "프랑스어(프랑스)"
                 case 39: fGetLanguageName = "이탈리아어 (이태리)"
                 case 46: fGetLanguageName = "스웨덴어(스웨덴)"
                 case 49: fGetLanguageName = "독일어(독일)"
                 case 55: fGetLanguageName = "포르투갈어(브라질)"
                 case 81: fGetLanguageName = "일본어"
                 case 82: fGetLanguageName = "한국어"
                 case 86: fGetLanguageName = "중국어(간체)"
                 case 88: fGetLanguageName = "중국어(번체)"
                 case else :
                          QAErrorLog "Now, the test does not support for the language " +iSprache
                          fGetLanguageName = ""
          end select
      case 86   :        ' Chinese (simplified)
          select case CountryID
                 case 1:  fGetLanguageName = "英语(美国)"
                 case 33: fGetLanguageName = "法语(法国)"
                 case 34: fGetLanguageName = "西班牙语(西班牙)"
                 case 39: fGetLanguageName = "意大利语(意大利)"
                 case 46: fGetLanguageName = "瑞典语(瑞典)"
                 case 49: fGetLanguageName = "德语(德国)"
                 case 55: fGetLanguageName = "葡萄牙语(巴西)"
                 case 81: fGetLanguageName = "日语"
                 case 82: fGetLanguageName = "朝鲜语"
                 case 86: fGetLanguageName = "中文(简体字)"
                 case 88: fGetLanguageName = "中文(繁体字)"
                 case else :
                          QAErrorLog "Now, the test does not support for the language " +iSprache
                          fGetLanguageName = ""
          end select

      case 88   :        ' Chinese (traditional)
          select case CountryID
                 case 1:  fGetLanguageName = "英語(美國)"
                 case 33: fGetLanguageName = "法語(法國)"
                 case 34: fGetLanguageName = "西班牙語(西班牙)"
                 case 39: fGetLanguageName = "意大利語(意大利)"
                 case 46: fGetLanguageName = "瑞典語(瑞典)"
                 case 49: fGetLanguageName = "德語(德國)"
                 case 55: fGetLanguageName = "葡萄牙語(巴西)"
                 case 81: fGetLanguageName = "日語"
                 case 82: fGetLanguageName = "韓語"
                 case 86: fGetLanguageName = "中文(簡體字)"
                 case 88: fGetLanguageName = "中文(繁體)"
                 case else :
                          QAErrorLog "Now, the test does not support for the language " +iSprache
                          fGetLanguageName = ""
          end select
      case else :        ' Fallback
          QAErrorLog "Now, the test does not support for the language " +iSprache
          fGetLanguageName = ""
 end select

end function

