'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: unredo10.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/15 13:51:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description	:	Complete Test for the undo/redo function which test
'*
'************************************************************************
'*
' #1 unredo10             ' Initial routine
' #1 tDelete_Cellcontents ' Delete cell content - Undo/Redo - Check results
' #1 tDelete_Sheet        ' Delete sheet - Undo/Redo - Check results
'*
'\***********************************************************************

	global file as string
	global index as integer

sub unredo10

Printlog Chr(13) + "--------- Delete Sheets with contents ---------"

        call tDelete_Cellcontents
        call tDelete_Sheet

end sub

'**************************************************************************************************

testcase tDelete_Cellcontents

	'dim file as string
	'dim font_index as integer
	file = convertpath(gtesttoolpath & "calc/special/input/delete_sheet.sxc")

'/// Open the file (gtesttoolpath & "calc/special/input/delete_sheet.sxc"), goto cell 'B7',
'/// call menuitem 'FormatCells', goto tagpage 'Fonts' and look, which style is selected
	printlog "* Delete cellcontents"
 	call hDateiOeffnen file

 	call cgotocell("B7")
 	' read out the current Font
 	FormatCells
 	Kontext
 	active.setpage TabFont
 	Kontext "TabFont"
 	try
 	   index = StyleWest.GetSelIndex
 	catch
 	   index = Style.GetSelIndex
 	endcatch
 	Kontext
 	TabFont.Cancel

'/// goto cell 'B7', press <DELETE> and check in the dialog 'Formats'
 	Kontext "DocumentCalc"
 	DocumentCalc.TypeKeys "<Mod1 Shift Right Down>"
 	DocumentCalc.TypeKeys "<Delete>"
 	Kontext "InhalteLoeschen"
 	if NOT Formate.Ischecked then Formate.Check
 	InhalteLoeschen.OK
 	Kontext "DocumentCalc"
 	DocumentCalc.TypeKeys "<Mod1 Home>"

'/// check if the delete-command has been executed
 	call cgotocell("B7")
 	FormatCells
 	Kontext
 	active.setpage TabFont
 	Kontext "TabFont"
 	try
 	   if StyleWest.GetSelIndex = 1 then
 	      printlog "OK, the delete-command has been executed"
 	   else
 	      warnlog "The delete-command hasn't benn executed or the checkbox Format in the dialogbox wasn't checked"
 	   end if
 	catch
 	   if Style.GetSelIndex = 1 then
 	      printlog "OK, the delete-command has been executed"
 	   else
 	      warnlog "The delete-command hasn't benn executed or the checkbox Format in the dialogbox wasn't checked"
 	   end if
 	endcatch
 	Kontext
 	TabFont.Cancel

'/// check if the undo-command works
 	Kontext "DocumentCalc"
 	DocumentCalc.TypeKeys "<Mod1 Home>"
 	EditUndo
 	call cgotocell("B7")
 	FormatCells
 	Kontext
 	active.setpage TabFont
 	Kontext "TabFont"
 	try
 	   if StyleWest.GetSelIndex = index then
 	      printlog "OK, the cellcontents are available again"
 	   else
 	      warnlog "The cellcontents aren't there or the contents has lost there current Font_index"
 	   end if
 	catch
 	   if Style.GetSelIndex = index then
 	      printlog "OK, the cellcontents are available again"
 	   else
 	      warnlog "The cellcontents aren't there or the contents has lost there current Font_index"
 	   end if
 	endcatch
 	Kontext
 	TabFont.Cancel

'/// check if the redo-function works
 	Kontext "DocumentCalc"
 	DocumentCalc.TypeKeys "<Mod1 Home>"
 	EditRedo
 	call cgotocell("B7")
 	FormatCells
 	Kontext
 	active.setpage TabFont
 	Kontext "TabFont"
 	try
 	   if StyleWest.GetSelIndex = 1 then
 	      printlog "OK, redo works"
 	   else
 	      warnlog "The redo-function doesn't work"
 	   end if
 	catch
 	   if Style.GetSelIndex = 1 then
 	      printlog "OK, redo works"
 	   else
 	      warnlog "The redo-function doesn't work"
 	   end if
 	endcatch
 	Kontext
 	TabFont.Cancel

	EditUndo

 	call hCloseDocument

endcase

testcase tDelete_Sheet

'/// Open the document (gtesttoolpath & "calc/special/input/delete_sheet.sxc") and count the
'/// number of the sheets
	dim count as integer
	file = convertpath(gtesttoolpath & "calc/special/input/delete_sheet.sxc")

	printlog "* Delete Sheets with contents"
 	call hDateiOeffnen file

 	' count the entries in the listbox
 	EditCopyMoveSheet
 	Kontext "TabelleVerschiebenKopieren"
 	count = EinfuegenVor.GetItemCount
 	TabelleVerschiebenKopieren.Cancel

 	' read out the FontStyle
 	call cgotocell("B7")
 	FormatCells
 	Kontext
 	active.setpage TabFont
 	Kontext "TabFont"
 	try
 	   index = StyleWest.GetSelIndex
 	catch
 	   index = Style.GetSelIndex
 	endcatch
 	Kontext
 	TabFont.Cancel

 	' now the main test begin
'/// Call menuitem 'EditDeleteSheet'. A warning must be appear, if you are sure that you want
'/// to delete this sheet permanently, confirm this and click on YES
 	EditDeleteSheet
 	Kontext
 	if active.exists then
 		active.yes
 	else
 		warnlog "No warning message appears, if i trie to delete a table"
 	end if

'/// check if the table as been deleted
 	EditCopyMoveSheet
 	Kontext "TabelleVerschiebenKopieren"
 	if EinfuegenVor.GetItemCount = (count - 1) then
 		printlog "OK, the table has been deleted"
 	else
 		warnlog "The table hasn't been deleted"
 	end if
 	TabelleVerschiebenKopieren.Cancel

'/// check if the undo-function works
 	EditUndo
 	EditCopyMoveSheet
 	Kontext "TabelleVerschiebenKopieren"
 	if EinfuegenVor.GetItemCount = count then
 		printlog "OK, the table has inserted again"
 	else
 		warnlog "The table hasn't been inserted"
 	end if
 	TabelleVerschiebenKopieren.Cancel
 	Kontext "DocumentCalc"
 	call cgotocell("B7")
 	FormatCells
 	Kontext
 	active.setpage TabFont
 	Kontext "TabFont"
 	try
 	   if StyleWest.GetSelIndex = index then
 	      printlog "OK, the current table has been inserted"
 	   else
 	      warnlog "The current table isn't there, it must be a new table:-> BUG!"
 	   end if
 	catch
 	   if Style.GetSelIndex = index then
 	      printlog "OK, the current table has been inserted"
 	   else
 	      warnlog "The current table isn't there, it must be a new table:-> BUG!"
 	   end if
 	endcatch
 	Kontext
 	TabFont.Cancel

'/// check if the redo-function works
 	EditRedo
 	EditCopyMoveSheet
 	Kontext "TabelleVerschiebenKopieren"
 	if EinfuegenVor.GetItemCount = (count - 1) then
 		printlog "OK, redo works"
 	else
 		warnlog "The redo-function doesn't work"
 	end if
 	TabelleVerschiebenKopieren.Cancel
 	EditUndo

	call hCloseDocument

endcase


