'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: page_styles.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/15 13:51:03 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Page styles test - testcases
'*
'************************************************************************
'*
' #1 tpage_styles     
'*
'\***********************************************************************

sub page_styles

Printlog Chr(13) + "--------- Page Styles ---------"

        call tpage_styles  

end sub

'**************************************************************************************************

testcase tpage_styles
'/// This test checks, if all approrpiate styles are present, and if these styles are
'/// taken over when they are selected.

   dim File as String
   dim SFile as String
   dim Styles(15) as String
   dim cnt as integer
   dim stylecnt as integer
   dim cmp as integer
   cnt = 1
   cmp = 1

'/// First the current calc document (gTesttoolPath & "calc/special/input/page_styles.sdc") is
'/// loaded. Then this document is saved in the calc xml fileformat in the local working
'/// directory. Then this file is closed and reopened.

   File = convertpath(gTesttoolPath & "calc/special/input/page_styles.sdc")
   SFile = convertpath(gOfficePath & "user/work/page_styles" & Ext)
   call hDateiOeffnen File, false
   sleep 3
   try
       if NOT hSpeichernUnterMitFilterKill (SFile, FileFormat) then
           warnlog "Saving test document localy failed -> Aborting"
           call hCloseDocument
           goto endsub
       endif
   catch 
       qaErrorLog "Most probably there's no filter name for this language available. Trying to save without filter."
       'PJ: I would consider calling the following code a hack!
       Kontext "SpeichernDlg"
       Dateiname.SetText SFile
       DateiTyp.Select 1
       Speichern.Click
       Kontext "Active"
       if active.exists(2) then
           active.YES
       endif
   endcatch
    
   sleep 3
   call hCloseDocument
   sleep 3
   call hDateiOeffnen SFile, false
   sleep 3
'/// Then call the stylist and click the button page styles. Then check if there are
'/// 10 different page styles available.
   Kontext "DocumentCalc"
   Kontext "Stylist"
   if NOT Stylist.exists then
      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "<F11>"
   end if
   sleep 5
   Kontext "Stylist"
   Seitenvorlagen.click
   Kontext "Vorlagenliste"
   Vorlagenliste.TypeKeys "<PAGEUP>"
   printlog "Style(" & cnt & ") " & Vorlagenliste.getSelText
   Styles(1) = Vorlagenliste.getSelText
   'now assign this collecting main of the side
   call CheckTemplateName(Vorlagenliste.getSelText)
'/// Check for every page style, if it was taken over, when you select it in the stylist.

   for cnt = 2 to 10
      sleep 3
      Vorlagenliste.TypeKeys "<DOWN>"
      sleep 3
      printlog "Style(" & cnt & ") " & Vorlagenliste.getSelText
      Styles(cnt) = Vorlagenliste.getSelText
      'now assign this collecting main of the side
      call CheckTemplateName(Vorlagenliste.getSelText)
   next cnt
   ' now check, if any templates are double present
   for cnt = 2 to 10
      printlog "Compare Style(" & cnt & ") with Style(" & cmp & ")"
      if Styles(cnt) = Styles(cmp) then
         warnlog "Style(" & cnt & ") is the same as Style(" & cmp & ")"
      end if
      cmp = cmp + 1
   next cnt
   cnt = Vorlagenliste.getItemCount
   if cnt <> 10 then
      warnlog "There are " & cnt & " page styles in this file instead of 3"
   end if
   Kontext "DocumentCalc"
   call hCloseDocument
   sleep 10
   ' now load and save the other documents
'/// When this document is completeley tested, do the same with the documents
'/// (gTesttoolPath & "calc/special/input/page_styles(1-7).sdc). This documents are
'/// only contains three page styles.
   for stylecnt = 1 to 7
      cmp = 1
      call hDateiOeffnen convertpath(gTesttoolPath & "calc/special/input/page_styles" & stylecnt & ".sdc"
      sleep 5
           try
               if NOT hSpeichernUnterMitFilterKill (convertpath(gOfficePath & "user/work/page_styles" & stylecnt & Ext), FileFormat) then
                   warnlog "Saving test document localy failed -> Aborting"
                   call hCloseDocument
                   goto endsub
               endif
           catch 
               qaErrorLog "Most probably there's no filter name for this language available. Trying to save without filter."
               'PJ: I would consider calling the following code a hack!
               Kontext "SpeichernDlg"
               Dateiname.SetText convertpath(gOfficePath & "user/work/page_styles" & stylecnt & Ext)
               DateiTyp.Select 1
               Speichern.Click
               Kontext "Active"
               if active.exists(2) then
                   active.YES
               endif
           endcatch
      sleep 5
      call hCloseDocument
      sleep 3
      call hDateiOeffnen convertpath(gOfficePath & "user/work/page_styles" & stylecnt & Ext)
      sleep 3
      Kontext "DocumentCalc"
      Kontext "Stylist"
      if NOT Stylist.exists then
         Kontext "DocumentCalc"
         DocumentCalc.TypeKeys "<F11>"
      end if
      sleep 5
      Kontext "Stylist"
      Seitenvorlagen.click
      Kontext "Vorlagenliste"
      Vorlagenliste.TypeKeys "<PAGEUP>"
      printlog "Style(" & stylecnt & ") " & Vorlagenliste.getSelText
      Styles(1) = Vorlagenliste.getSelText
      'now assign this collecting main of the side
      call CheckTemplateName(Vorlagenliste.getSelText)
      for cnt = 2 to 3
         sleep 3
         Vorlagenliste.TypeKeys "<DOWN>"
         sleep 3
         printlog "Style(" & cnt & ") " & Vorlagenliste.getSelText
         Styles(cnt) = Vorlagenliste.getSelText
         'now assign this collecting main of the side
         call CheckTemplateName(Vorlagenliste.getSelText)
      next cnt
      ' now check, if any templates are double present
      for cnt = 2 to 3
         printlog "Compare Style(" & cnt & ") with Style(" & cmp & ")"
         if Styles(cnt) = Styles(cmp) then
            warnlog "Style(" & cnt & ") is the same as Style(" & cmp & ")"
         end if
         cmp = cmp + 1
      next cnt
      cnt = Vorlagenliste.getItemCount
      if cnt <> 3 then
         warnlog "There are " & cnt & " page styles in this file instead of 3"
      end if
      printlog "There are " & cnt & " templates available"
      Kontext "DocumentCalc"
      call hCloseDocument
   next stylecnt

endcase
