'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_105c.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/15 13:33:00 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description  :  Detailed test of the functions in the Format menu - Part 3
'*
'************************************************************************
'*
' #1 C_105c     ' Initial routine
' #1 tControltype
' #1 tControlProperties
' #1 tFormularProperties
' #1 tTabOrder
'*
'\***********************************************************************

sub C_105c

Printlog Chr(13) + "--------- C_105c ---------"

  call tControltype("Pushbutton")
  call tControltype("Radiobutton")
  call tControltype("Checkbox")
  call tControltype("TextBox")
  call tControltype("Groupbox")
  call tControltype("Edit")
  call tControltype("FormatiertesFeld")
  call tControltype("Listbox")
  call tControltype("Combobox")
  call tControltype("GrafischeSchaltflaeche")
  call tControltype("GrafischesKontrollfeld")
  call tControltype("Dateiauswahl")
  call tControltype("Zeitfeld")
  call tControltype("NumerischesFeld")
  call tControltype("Waehrungsfeld")
  call tControltype("MarkiertesFeld")
  call tControltype("TabellenControl")
  call tControlProperties
  call tFormularProperties
  call tTabOrder

end sub
'
'---------------------------------------------------------------------------
'
'---------------------------------------------------------------------------
testcase tControltype(Controltype as string)
'/// This testcase test, if all controls could be inserted into a document.


        printlog "- " + Controltype
    call hNewDocument
    Kontext "Toolbar"
    ShowFormFunctions.TearOff
    Kontext "Formsbar"
    Formsbar.Move 20, 20

    select case Controltype
      case "Pushbutton" : Pushbutton.click
      case "Radiobutton" : Radiobutton.click
      case "Checkbox" : Checkbox.click
      case "TextBox" : TextBox.click
      case "Groupbox" : Groupbox.click
      case "Edit" : Edit.click
      case "FormatiertesFeld" : FormatiertesFeld.click
      case "Listbox" : Listbox.click
      case "Combobox" : Combobox.click
      case "GrafischeSchaltflaeche" : GrafischeSchaltflaeche.click
      case "GrafischesKontrollfeld" : GrafischesKontrollfeld.click
      case "Dateiauswahl" : Dateiauswahl.click
      case "Datumsfeld" : Datumsfeld.click
      case "Zeitfeld" : Zeitfeld.click
      case "NumerischesFeld" : NumerischesFeld.click
      case "Waehrungsfeld" : Waehrungsfeld.click
      case "MarkiertesFeld" : MarkiertesFeld.click
      case "TabellenControl" : TabellenControl.click
    end select

    call subCalcDrawControl(20,20,40,40,Controltype)
    kontext

    if active.exists then active.ok

    if allnsklor (Controltype,30,30) = true then
        Kontext "DocumentCalc"
        DocumentCalc.Typekeys "<DELETE>"
        call isseswech (Controltype,30,30)
    else
        Warnlog "Without selection, nothing is testable"
    end if
        Kontext "Formsbar"
        if Formsbar.Exists then Formsbar.Close

        call hCloseDocument

endcase
'
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'

testcase tControlProperties
'/// Check if control properties exist
        call hNewDocument
    Kontext "Toolbar"
    ShowFormFunctions.TearOff
    Kontext "Formsbar"
    Formsbar.Move 20, 20
    Edit.Click
    call subCalcDrawControl(20,20,40,40,"Edit")
    '******************************
    Kontext "Formsbar"
    _ControlEigenschaften.Click
    Kontext "ControlPropertiesDialog"
    printlog "TabGeneralControl"
    ControlPropertiesTabControl.SetPage TabGeneralControl
    sleep 1
    Kontext "TabGeneralControl"
    'Call DialogTest ( TabGeneralControl )
    Printlog "TabEventsControl"
    Kontext "ControlPropertiesDialog"
    ControlPropertiesTabControl.SetPage TabEventsControl
    Kontext "TabEventsControl"
    'Call DialogTest ( TabEventsControl )
    Sleep 3
    Kontext
    Kontext "ControlPropertiesDialog"
    If ControlPropertiesDialog.exists then ControlPropertiesDialog.close

    '********************************
    Kontext "Formsbar"
    if Formsbar.Exists then Formsbar.Close

        call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormularProperties
'/// Check if formular properties exist

    QAErrorLog "Curently disabled because of Redesign!"
    goto endsub
    call hNewDocument
    Kontext "Toolbar"
    ShowFormFunctions.TearOff
    Kontext "Formsbar"
    Formsbar.Move 20, 20
    Edit.Click
    call subCalcDrawControl(20,20,40,40,"Edit")
    '****
    Kontext "Formsbar"
    _FormularEigenschaften.Click
    Kontext "FormPropertiesDialog"
    FormPropertiesTabControl.SetPage TabGeneralForm
    Sleep 2
    Kontext "TabGeneralForm"
    printlog "TabGeneralForm"
    Sleep 2
    'Call DialogTest ( TabGeneralForm )
    Kontext "TabGeneralForm"
    FormPropertiesTabControl.SetPage TabDataForm
    Kontext "TabDataForm"
    Printlog "TabDataForm"
    'call Dialogtest ( FormPropertiesData )
    Kontext "FormPropertiesDialog"
    FormPropertiesTagControl.SetPage TabEventsForms
    Kontext "TabEventsForms"
    Printlog "TabEventsForms"
    'Call DialogTest ( TabEventsForms )
    Kontext "FormPropertiesDialog"    
    FormPropertiesDialog.close
    '****
    Kontext "Formsbar"
    if Formsbar.Exists then Formsbar.Close

    call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tTabOrder
'/// This test check, if the activating order dialog appears and if the button
'/// activating order is available.
    call hNewDocument

    Kontext "Toolbar"
    ShowFormFunctions.TearOff
    Kontext "Formsbar"
    Formsbar.Move 20, 20
    Edit.Click
    call subCalcDrawControl(20,20,30,30,"Edit")
    Kontext "Formsbar"
    Edit.Click
    call subCalcDrawControl(40,40,50,50,"Edit")
    Kontext "Formsbar"
    _Aktivierungsreihenfolge.Click
    Kontext "Aktivierungsreihenfolge"
    If Aktivierungsreihenfolge.Exists (2) then
        Indexkleiner.Click
        Aktivierungsreihenfolge.Cancel
    else
        Warnlog "Order of activating hasn't appeared"
    end if

    Kontext "Formsbar"
    if Formsbar.Exists then Formsbar.Close

    call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'

