/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.ResultSetMetaData;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;

public class ServerPreparedStatement
extends PreparedStatement {
    private static final byte MAX_DATE_REP_LENGTH = 5;
    private static final byte MAX_TIME_REP_LENGTH = 13;
    private static final byte MAX_DATETIME_REP_LENGTH = 12;
    private Buffer outByteBuffer;
    private Calendar dateTimeBindingCal = null;
    private SQLException invalidationException;
    private BindValue[] parameterBindings;
    private Field[] parameterFields;
    private Field[] resultFields;
    private boolean detectedLongParameterSwitch = false;
    private boolean invalid = false;
    private boolean isSelectQuery;
    private boolean sendTypesToServer = false;
    private int fieldCount;
    private int stringTypeCode = 254;
    private long serverStatementId;

    public ServerPreparedStatement(Connection conn, String sql, String catalog) throws SQLException {
        super(conn, catalog);
        this.checkNullOrEmptyQuery(sql);
        this.isSelectQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "SELECT");
        this.useTrueBoolean = this.connection.getIO().versionMeetsMinimum(3, 21, 23);
        this.hasLimitClause = sql.toUpperCase().indexOf("LIMIT") != -1;
        this.firstCharOfStmt = StringUtils.firstNonWsCharUc(sql);
        this.originalSql = sql;
        this.stringTypeCode = this.connection.getIO().versionMeetsMinimum(4, 1, 2) ? 253 : 254;
        try {
            this.serverPrepare(sql);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            throw new SQLException(ex.toString(), "S1000");
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new NotImplemented();
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
            this.serverLongData(parameterIndex, binding);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.setString(parameterIndex, ServerPreparedStatement.fixDecimalExponent(x.toString()));
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
            this.serverLongData(parameterIndex, binding);
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x.length() : -1L;
            this.serverLongData(parameterIndex, binding);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 1);
        Byte val = new Byte(x ? (byte)1 : 0);
        binding.value = val;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 1);
        Byte val = new Byte(x);
        binding.value = val;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 252);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkClosed();
        if (reader == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = reader;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
            this.serverLongData(parameterIndex, binding);
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x.getCharacterStream();
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x.length() : -1L;
            this.serverLongData(parameterIndex, binding);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 10);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 5);
        Double val = new Double(x);
        binding.value = val;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 4);
        Float val = new Float(x);
        binding.value = val;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 3);
        Integer val = new Integer(x);
        binding.value = val;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 8);
        Long val = new Long(x);
        binding.value = val;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new ResultSetMetaData(this.resultFields);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new NotImplemented();
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new NotImplemented();
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 2);
        Short val = new Short(x);
        binding.value = val;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, this.stringTypeCode);
            binding.value = x;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTimeInternal(parameterIndex, x, cal.getTimeZone());
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTimeInternal(parameterIndex, x, TimeZone.getDefault());
    }

    public void setTimeInternal(int parameterIndex, Time x, TimeZone tz) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 11);
            binding.value = TimeUtil.changeTimezone(this.connection, x, tz, this.connection.getServerTimezoneTZ());
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestampInternal(parameterIndex, x, TimeZone.getDefault());
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestampInternal(parameterIndex, x, cal.getTimeZone());
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x.toString());
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        throw new NotImplemented();
    }

    public synchronized void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        this.batchedArgs.add(new BatchedBindValues(this.parameterBindings));
    }

    public void clearParameters() throws SQLException {
        this.clearParametersInternal(true);
    }

    public void close() throws SQLException {
        this.realClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.2") + Messages.getString("ServerPreparedStatement.3"), "S1009");
        }
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            int[] nArray;
            this.clearWarnings();
            BindValue[] oldBindValues = this.parameterBindings;
            try {
                int[] updateCounts = null;
                if (this.batchedArgs != null) {
                    int nbrCommands = this.batchedArgs.size();
                    updateCounts = new int[nbrCommands];
                    if (this.retrieveGeneratedKeys) {
                        this.batchedGeneratedKeys = new ArrayList(nbrCommands);
                    }
                    for (int i = 0; i < nbrCommands; ++i) {
                        updateCounts[i] = -3;
                    }
                    Throwable sqlEx = null;
                    int commandIndex = 0;
                    for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                        Object arg = this.batchedArgs.get(commandIndex);
                        if (arg instanceof String) {
                            updateCounts[commandIndex] = this.executeUpdate((String)arg);
                            continue;
                        }
                        this.parameterBindings = ((BatchedBindValues)arg).batchedParameterValues;
                        try {
                            updateCounts[commandIndex] = this.executeUpdate(false);
                            if (!this.retrieveGeneratedKeys) continue;
                            java.sql.ResultSet rs = null;
                            try {
                                rs = this.getGeneratedKeysInternal();
                                while (rs.next()) {
                                    this.batchedGeneratedKeys.add(new byte[][]{rs.getBytes(1)});
                                }
                                continue;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (SQLException ex) {
                            updateCounts[commandIndex] = -3;
                            if (this.connection.getContinueBatchOnError()) {
                                sqlEx = ex;
                                continue;
                            }
                            int[] newUpdateCounts = new int[commandIndex];
                            System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                            throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                        }
                    }
                    if (sqlEx != null) {
                        throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                    }
                }
                nArray = updateCounts != null ? updateCounts : new int[]{};
                this.parameterBindings = oldBindValues;
            }
            catch (Throwable throwable) {
                this.parameterBindings = oldBindValues;
                this.clearBatch();
                throw throwable;
            }
            this.clearBatch();
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        StringBuffer toStringBuf = new StringBuffer();
        toStringBuf.append("com.mysql.jdbc.ServerPreparedStatement[");
        toStringBuf.append(this.serverStatementId);
        toStringBuf.append("] - ");
        PreparedStatement pStmtForSub = null;
        pStmtForSub = new PreparedStatement(this.connection, this.originalSql, this.currentCatalog);
        int numParameters = pStmtForSub.parameterCount;
        int ourNumParameters = this.parameterCount;
        for (int i = 0; i < numParameters && i < ourNumParameters; ++i) {
            if (this.parameterBindings[i] == null) continue;
            if (this.parameterBindings[i].isNull) {
                pStmtForSub.setNull(i + 1, 0);
                continue;
            }
            pStmtForSub.setObject(i + 1, this.parameterBindings[i].value);
        }
        toStringBuf.append(pStmtForSub.asSql());
        Object var7_7 = null;
        if (pStmtForSub == null) return toStringBuf.toString();
        try {
            pStmtForSub.close();
            return toStringBuf.toString();
        }
        catch (SQLException sqlEx2) {}
        return toStringBuf.toString();
        {
            catch (SQLException sqlEx) {
                toStringBuf.append(Messages.getString("ServerPreparedStatement.6"));
                toStringBuf.append(sqlEx);
                Object var7_8 = null;
                if (pStmtForSub == null) return toStringBuf.toString();
                try {
                    pStmtForSub.close();
                    return toStringBuf.toString();
                }
                catch (SQLException sqlEx2) {}
                return toStringBuf.toString();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (pStmtForSub == null) throw throwable;
            try {
                pStmtForSub.close();
                throw throwable;
            }
            catch (SQLException sqlEx2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void setTimestampInternal(int parameterIndex, Timestamp x, TimeZone tz) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 12);
            binding.value = TimeUtil.changeTimezone(this.connection, x, tz, this.connection.getServerTimezoneTZ());
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.invalid) {
            throw this.invalidationException;
        }
        super.checkClosed();
    }

    protected ResultSet executeInternal(int maxRowsToRetrieve, Buffer sendPacket, boolean createStreamingResultSet, boolean queryIsSelectOnly, boolean unpackFields) throws SQLException {
        ++this.numberOfExecutions;
        try {
            return this.serverExecute(maxRowsToRetrieve, createStreamingResultSet);
        }
        catch (SQLException sqlEx) {
            StringBuffer messageBuf;
            String extractedSql;
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            if (this.connection.getDumpQueriesOnException()) {
                extractedSql = this.toString();
                messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            if (this.connection.getDumpQueriesOnException()) {
                extractedSql = this.toString();
                messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
        catch (Exception ex) {
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            SQLException sqlEx = new SQLException(ex.toString(), "S1000");
            if (this.connection.getDumpQueriesOnException()) {
                String extractedSql = this.toString();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
    }

    protected Buffer fillSendPacket() throws SQLException {
        return null;
    }

    protected Buffer fillSendPacket(byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths) throws SQLException {
        return null;
    }

    protected void rePrepare() throws SQLException {
        this.invalidationException = null;
        try {
            this.serverPrepare(this.originalSql);
        }
        catch (SQLException sqlEx) {
            this.invalidationException = sqlEx;
        }
        catch (Exception ex) {
            this.invalidationException = new SQLException(ex.toString(), "S1000");
        }
        if (this.invalidationException != null) {
            this.invalid = true;
            this.parameterBindings = null;
            this.parameterFields = null;
            this.resultFields = null;
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.connection != null) {
                if (this.maxRowsChanged) {
                    this.connection.unsetMaxRows(this);
                }
                this.connection.unregisterStatement(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realClose(boolean calledExplicitly) throws SQLException {
        if (this.isClosed) {
            return;
        }
        SQLException exceptionDuringClose = null;
        try {
            Object object = this.connection.getMutex();
            synchronized (object) {
                MysqlIO mysql = this.connection.getIO();
                Buffer packet = mysql.getSharedSendPacket();
                packet.writeByte((byte)25);
                packet.writeLong(this.serverStatementId);
                mysql.sendCommand(25, null, packet, true, null);
            }
        }
        catch (SQLException sqlEx) {
            exceptionDuringClose = sqlEx;
        }
        this.clearParametersInternal(false);
        this.parameterBindings = null;
        this.parameterFields = null;
        this.resultFields = null;
        super.realClose(calledExplicitly);
        if (exceptionDuringClose != null) {
            throw exceptionDuringClose;
        }
    }

    synchronized byte[] getBytes(int parameterIndex) throws SQLException {
        BindValue bindValue = this.getBinding(parameterIndex, false);
        if (bindValue.isNull) {
            return null;
        }
        if (bindValue.isLongData) {
            throw new NotImplemented();
        }
        if (this.outByteBuffer == null) {
            this.outByteBuffer = Buffer.allocateNew(this.connection.getNetBufferLength(), false);
        }
        this.outByteBuffer.clear();
        int originalPosition = this.outByteBuffer.getPosition();
        this.storeBinding(this.outByteBuffer, bindValue, this.connection.getIO());
        int newPosition = this.outByteBuffer.getPosition();
        int length = newPosition - originalPosition;
        byte[] valueAsBytes = new byte[length];
        System.arraycopy(this.outByteBuffer.getByteBuffer(), originalPosition, valueAsBytes, 0, length);
        return valueAsBytes;
    }

    boolean isNull(int paramIndex) {
        throw new IllegalArgumentException(Messages.getString("ServerPreparedStatement.7"));
    }

    private BindValue getBinding(int parameterIndex, boolean forLongData) throws SQLException {
        if (this.parameterBindings.length == 0) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.8"), "S1009");
        }
        if (--parameterIndex < 0 || parameterIndex >= this.parameterBindings.length) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.9") + (parameterIndex + 1) + Messages.getString("ServerPreparedStatement.10") + this.parameterBindings.length, "S1009");
        }
        if (this.parameterBindings[parameterIndex] == null) {
            this.parameterBindings[parameterIndex] = new BindValue();
        } else if (this.parameterBindings[parameterIndex].isLongData && !forLongData) {
            this.detectedLongParameterSwitch = true;
        }
        return this.parameterBindings[parameterIndex];
    }

    private void setType(BindValue oldValue, int bufferType) {
        if (oldValue.bufferType != bufferType) {
            this.sendTypesToServer = true;
        }
        oldValue.bufferType = bufferType;
    }

    private void clearParametersInternal(boolean clearServerParameters) throws SQLException {
        boolean hadLongData = false;
        if (this.parameterBindings != null) {
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.parameterBindings[i] != null && this.parameterBindings[i].isLongData) {
                    hadLongData = true;
                }
                this.parameterBindings[i] = null;
            }
        }
        if (clearServerParameters && hadLongData) {
            this.serverResetStatement();
            this.detectedLongParameterSwitch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet serverExecute(int maxRowsToRetrieve, boolean createStreamingResultSet) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            int i;
            if (this.detectedLongParameterSwitch) {
                throw new SQLException(Messages.getString("ServerPreparedStatement.11") + Messages.getString("ServerPreparedStatement.12"), "S1C00");
            }
            for (int i2 = 0; i2 < this.parameterCount; ++i2) {
                if (this.parameterBindings[i2] != null) continue;
                throw new SQLException(Messages.getString("ServerPreparedStatement.13") + (i2 + 1) + Messages.getString("ServerPreparedStatement.14"), "S1009");
            }
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)23);
            packet.writeLong(this.serverStatementId);
            if (mysql.versionMeetsMinimum(4, 1, 2)) {
                packet.writeByte((byte)0);
                packet.writeLong(1L);
            }
            int nullCount = (this.parameterCount + 7) / 8;
            int nullBitsPosition = packet.getPosition();
            for (int i3 = 0; i3 < nullCount; ++i3) {
                packet.writeByte((byte)0);
            }
            byte[] nullBitsBuffer = new byte[nullCount];
            packet.writeByte(this.sendTypesToServer ? (byte)1 : 0);
            if (this.sendTypesToServer) {
                for (i = 0; i < this.parameterCount; ++i) {
                    packet.writeInt(this.parameterBindings[i].bufferType);
                }
            }
            for (i = 0; i < this.parameterCount; ++i) {
                if (this.parameterBindings[i].isLongData) continue;
                if (!this.parameterBindings[i].isNull) {
                    this.storeBinding(packet, this.parameterBindings[i], mysql);
                    continue;
                }
                int n = i / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << (i & 7));
            }
            int endPosition = packet.getPosition();
            packet.setPosition(nullBitsPosition);
            packet.writeBytesNoNull(nullBitsBuffer);
            packet.setPosition(endPosition);
            long begin = 0L;
            if (this.connection.getProfileSql() || this.connection.getLogSlowQueries() || this.connection.getGatherPerformanceMetrics()) {
                begin = System.currentTimeMillis();
            }
            Buffer resultPacket = mysql.sendCommand(23, null, packet, false, null);
            if (this.connection.getLogSlowQueries() || this.connection.getGatherPerformanceMetrics()) {
                long elapsedTime = System.currentTimeMillis() - begin;
                if (this.connection.getLogSlowQueries() && elapsedTime > (long)this.connection.getSlowQueryThresholdMillis()) {
                    StringBuffer mesgBuf = new StringBuffer(48 + this.originalSql.length());
                    mesgBuf.append(Messages.getString("ServerPreparedStatement.15"));
                    mesgBuf.append(this.connection.getSlowQueryThresholdMillis());
                    mesgBuf.append(Messages.getString("ServerPreparedStatement.16"));
                    mesgBuf.append(this.originalSql);
                    this.connection.getLog().logWarn(mesgBuf.toString());
                    if (this.connection.getExplainSlowQueries()) {
                        String queryAsString = this.asSql();
                        mysql.explainSlowQuery(queryAsString.getBytes(), queryAsString);
                    }
                }
                if (this.connection.getGatherPerformanceMetrics()) {
                    this.connection.registerQueryExecutionTime(elapsedTime);
                }
            }
            this.connection.incrementNumberOfPreparedExecutes();
            if (this.connection.getProfileSql()) {
                this.eventSink = ProfileEventSink.getInstance(this.connection);
                this.eventSink.consumeEvent(new ProfilerEvent(4, "", this.currentCatalog, this.connection.getId(), this.statementId, -1, System.currentTimeMillis(), (int)(System.currentTimeMillis() - begin), null, new Throwable(), null));
            }
            ResultSet rs = mysql.readAllResults(this, maxRowsToRetrieve, this.resultSetType, this.resultSetConcurrency, createStreamingResultSet, this.currentCatalog, resultPacket, true, this.fieldCount, true);
            if (!createStreamingResultSet) {
                this.serverResetStatement();
            }
            this.sendTypesToServer = false;
            this.results = rs;
            return rs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverLongData(int parameterIndex, BindValue longData) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)24);
            packet.writeLong(this.serverStatementId);
            packet.writeInt(parameterIndex - 1);
            Object value = longData.value;
            if (value instanceof byte[]) {
                packet.writeBytesNoNull((byte[])longData.value);
            } else if (value instanceof InputStream) {
                this.storeStream(packet, (InputStream)value);
            } else if (value instanceof Blob) {
                this.storeStream(packet, ((Blob)value).getBinaryStream());
            } else if (value instanceof Reader) {
                this.storeReader(packet, (Reader)value);
            } else {
                throw new SQLException(Messages.getString("ServerPreparedStatement.18") + value.getClass().getName() + "'", "S1009");
            }
            mysql.sendCommand(24, null, packet, true, null);
        }
    }

    private void serverPrepare(String sql) throws SQLException {
        MysqlIO mysql = this.connection.getIO();
        try {
            int i;
            long begin = 0L;
            this.isLoadDataQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "LOAD DATA");
            if (this.connection.getProfileSql()) {
                begin = System.currentTimeMillis();
            }
            String characterEncoding = null;
            String connectionEncoding = this.connection.getEncoding();
            if (!this.isLoadDataQuery && this.connection.getUseUnicode() && connectionEncoding != null) {
                characterEncoding = connectionEncoding;
            }
            Buffer prepareResultPacket = mysql.sendCommand(22, sql, null, false, characterEncoding);
            if (mysql.versionMeetsMinimum(4, 1, 1)) {
                prepareResultPacket.setPosition(1);
            } else {
                prepareResultPacket.setPosition(0);
            }
            this.serverStatementId = prepareResultPacket.readLong();
            this.fieldCount = prepareResultPacket.readInt();
            this.parameterCount = prepareResultPacket.readInt();
            this.parameterBindings = new BindValue[this.parameterCount];
            this.connection.incrementNumberOfPrepares();
            if (this.connection.getProfileSql()) {
                this.eventSink = ProfileEventSink.getInstance(this.connection);
                this.eventSink.consumeEvent(new ProfilerEvent(2, "", this.currentCatalog, this.connection.getId(), this.statementId, -1, System.currentTimeMillis(), (int)(System.currentTimeMillis() - begin), null, new Throwable(), sql));
            }
            if (this.parameterCount > 0 && mysql.versionMeetsMinimum(4, 1, 2) && !mysql.isVersion(5, 0, 0)) {
                this.parameterFields = new Field[this.parameterCount];
                Buffer metaDataPacket = mysql.readPacket();
                i = 0;
                while (!metaDataPacket.isLastDataPacket() && i < this.parameterCount) {
                    this.parameterFields[i++] = mysql.unpackField(metaDataPacket, false);
                    metaDataPacket = mysql.readPacket();
                }
            }
            if (this.fieldCount > 0) {
                this.resultFields = new Field[this.fieldCount];
                Buffer fieldPacket = mysql.readPacket();
                i = 0;
                while (!fieldPacket.isLastDataPacket() && i < this.fieldCount) {
                    this.resultFields[i++] = mysql.unpackField(fieldPacket, false);
                    fieldPacket = mysql.readPacket();
                }
            }
        }
        catch (SQLException sqlEx) {
            if (this.connection.getDumpQueriesOnException()) {
                StringBuffer messageBuf = new StringBuffer(this.originalSql.length() + 32);
                messageBuf.append("\n\nQuery being prepared when exception was thrown:\n\n");
                messageBuf.append(this.originalSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
        finally {
            this.connection.getIO().clearInputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverResetStatement() throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)26);
            packet.writeLong(this.serverStatementId);
            try {
                mysql.sendCommand(26, null, packet, !mysql.versionMeetsMinimum(4, 1, 2), null);
            }
            catch (SQLException sqlEx) {
                throw sqlEx;
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString(), "S1000");
            }
            finally {
                mysql.clearInputStream();
            }
        }
    }

    private void storeBinding(Buffer packet, BindValue bindValue, MysqlIO mysql) throws SQLException {
        try {
            Object value = bindValue.value;
            if (value instanceof Byte) {
                packet.writeByte((Byte)value);
            } else if (value instanceof Short) {
                packet.ensureCapacity(2);
                packet.writeInt(((Short)value).shortValue());
            } else if (value instanceof Integer) {
                packet.ensureCapacity(4);
                packet.writeLong(((Integer)value).intValue());
            } else if (value instanceof Long) {
                packet.ensureCapacity(8);
                packet.writeLongLong((Long)value);
            } else if (value instanceof Float) {
                packet.ensureCapacity(4);
                packet.writeFloat(((Float)value).floatValue());
            } else if (value instanceof Double) {
                packet.ensureCapacity(8);
                packet.writeDouble((Double)value);
            } else if (value instanceof String) {
                if (!this.isLoadDataQuery) {
                    packet.writeLenString((String)value, this.charEncoding, this.connection.getServerCharacterEncoding(), this.charConverter, this.connection.parserKnowsUnicode());
                } else {
                    packet.writeLenBytes(((String)value).getBytes());
                }
            } else if (value instanceof byte[]) {
                packet.writeLenBytes((byte[])value);
            } else if (value instanceof Time) {
                ServerPreparedStatement.storeTime(packet, (Time)value);
            } else if (value instanceof java.util.Date) {
                this.storeDateTime(packet, (java.util.Date)value, mysql);
            }
        }
        catch (UnsupportedEncodingException uEE) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.22") + this.connection.getEncoding() + "'", "S1000");
        }
    }

    private void storeDataTime412AndOlder(Buffer intoBuf, java.util.Date dt) throws SQLException {
        if (this.dateTimeBindingCal == null) {
            this.dateTimeBindingCal = Calendar.getInstance();
        }
        this.dateTimeBindingCal.setTime(dt);
        intoBuf.ensureCapacity(8);
        intoBuf.writeByte((byte)7);
        int year = this.dateTimeBindingCal.get(1);
        int month = this.dateTimeBindingCal.get(2) + 1;
        int date = this.dateTimeBindingCal.get(5);
        intoBuf.writeInt(year);
        intoBuf.writeByte((byte)month);
        intoBuf.writeByte((byte)date);
        if (dt instanceof Date) {
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
        } else {
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(11));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(12));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(13));
        }
    }

    private void storeDateTime(Buffer intoBuf, java.util.Date dt, MysqlIO mysql) throws SQLException {
        if (mysql.versionMeetsMinimum(4, 1, 3)) {
            this.storeDateTime413AndNewer(intoBuf, dt);
        } else {
            this.storeDataTime412AndOlder(intoBuf, dt);
        }
    }

    private void storeDateTime413AndNewer(Buffer intoBuf, java.util.Date dt) throws SQLException {
        if (this.dateTimeBindingCal == null) {
            this.dateTimeBindingCal = Calendar.getInstance();
        }
        this.dateTimeBindingCal.setTime(dt);
        byte length = 7;
        intoBuf.ensureCapacity(length);
        if (dt instanceof Timestamp) {
            length = 11;
        }
        intoBuf.writeByte(length);
        int year = this.dateTimeBindingCal.get(1);
        int month = this.dateTimeBindingCal.get(2) + 1;
        int date = this.dateTimeBindingCal.get(5);
        intoBuf.writeInt(year);
        intoBuf.writeByte((byte)month);
        intoBuf.writeByte((byte)date);
        if (dt instanceof Date) {
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
        } else {
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(11));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(12));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(13));
        }
        if (length == 11) {
            intoBuf.writeLong(((Timestamp)dt).getNanos());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeReader(Buffer packet, Reader inStream) throws SQLException {
        StringBuffer valueAsString;
        block8: {
            char[] buf = new char[4096];
            valueAsString = new StringBuffer();
            int numRead = 0;
            try {
                try {
                    while ((numRead = inStream.read(buf)) != -1) {
                        valueAsString.append(buf, 0, numRead);
                    }
                    Object var8_6 = null;
                    if (inStream == null) break block8;
                }
                catch (IOException ioEx) {
                    throw new SQLException(Messages.getString("ServerPreparedStatement.24") + ioEx.toString(), "S1000");
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (inStream == null) throw throwable;
                try {
                    inStream.close();
                    throw throwable;
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioEx) {}
            inStream.close();
        }
        byte[] valueAsBytes = StringUtils.getBytes(valueAsString.toString(), this.connection.getEncoding(), this.connection.getServerCharacterEncoding(), this.connection.parserKnowsUnicode());
        packet.writeBytesNoNull(valueAsBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeStream(Buffer packet, InputStream inStream) throws SQLException {
        byte[] buf = new byte[4096];
        int numRead = 0;
        try {
            try {
                while ((numRead = inStream.read(buf)) != -1) {
                    packet.writeBytesNoNull(buf, 0, numRead);
                }
                Object var7_5 = null;
                if (inStream == null) return;
            }
            catch (IOException ioEx) {
                throw new SQLException(Messages.getString("ServerPreparedStatement.25") + ioEx.toString(), "S1000");
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioEx) {}
        inStream.close();
        return;
    }

    private static void storeTime(Buffer intoBuf, Time tm) throws SQLException {
        intoBuf.ensureCapacity(9);
        intoBuf.writeByte((byte)8);
        intoBuf.writeByte((byte)0);
        intoBuf.writeLong(0L);
        Calendar cal = Calendar.getInstance();
        cal.setTime(tm);
        intoBuf.writeByte((byte)cal.get(11));
        intoBuf.writeByte((byte)cal.get(12));
        intoBuf.writeByte((byte)cal.get(13));
    }

    class BindValue {
        Object value;
        boolean isLongData;
        boolean isNull;
        int bufferType;
        long bindLength;

        BindValue() {
        }

        BindValue(BindValue copyMe) {
            this.value = copyMe.value;
            this.isLongData = copyMe.isLongData;
            this.isNull = copyMe.isNull;
            this.bufferType = copyMe.bufferType;
            this.bindLength = copyMe.bindLength;
        }
    }

    class BatchedBindValues {
        BindValue[] batchedParameterValues;

        BatchedBindValues(BindValue[] paramVals) {
            int numParams = paramVals.length;
            this.batchedParameterValues = new BindValue[numParams];
            for (int i = 0; i < numParams; ++i) {
                this.batchedParameterValues[i] = new BindValue(paramVals[i]);
            }
        }
    }
}

