// $Id: MSXKanji.cc 5076 2006-01-25 19:26:32Z m9710797 $

#include "MSXKanji.hh"
#include "Rom.hh"
#include "MSXException.hh"

namespace openmsx {

MSXKanji::MSXKanji(MSXMotherBoard& motherBoard, const XMLElement& config,
                   const EmuTime& time)
	: MSXDevice(motherBoard, config, time)
	, rom(new Rom(motherBoard, getName(), "Kanji ROM", config))
{
	int size = rom->getSize();
	if ((size != 0x20000) && (size != 0x40000)) {
		throw MSXException("MSXKanji: wrong kanji rom");
	}

	reset(time);
}

MSXKanji::~MSXKanji()
{
}

void MSXKanji::reset(const EmuTime& /*time*/)
{
	adr1 = 0;	// TODO check this
	adr2 = 0x20000;	// TODO check this
}

void MSXKanji::writeIO(word port, byte value, const EmuTime& /*time*/)
{
	//PRT_DEBUG("MSXKanji: write " << (int)port << " " << (int)value);
	switch (port & 0x03) {
	case 0:
		adr1 = (adr1 & 0x1f800) | ((value & 0x3f) << 5);
		break;
	case 1:
		adr1 = (adr1 & 0x007e0) | ((value & 0x3f) << 11);
		break;
	case 2:
		adr2 = (adr2 & 0x3f800) | ((value & 0x3f) << 5);
		break;
	case 3:
		adr2 = (adr2 & 0x207e0) | ((value & 0x3f) << 11);
		break;
	}
}

byte MSXKanji::readIO(word port, const EmuTime& time)
{
	byte result = peekIO(port, time);
	switch (port & 0x03) {
	case 1:
		adr1 = (adr1 & ~0x1f) | ((adr1 + 1) & 0x1f);
		break;
	case 3:
		adr2 = (adr2 & ~0x1f) | ((adr2 + 1) & 0x1f);
		break;
	}
	//PRT_DEBUG("MSXKanji: read " << (int)port << " " << (int)result);
	return result;
}

byte MSXKanji::peekIO(word port, const EmuTime& /*time*/) const
{
	byte result;
	switch (port & 0x03) {
	case 1:
		result = (*rom)[adr1];
		break;
	case 3:
		if (rom->getSize() == 0x40000) { // temp workaround
			result = (*rom)[adr2];
		} else {
			result = 0xFF;
		}
		break;
	default:
		result = 0xFF;
	}
	return result;
}

/*
This really works!

10 DIM A(32)
20 FOR I=0 TO 4095
30 OUT &HD8, I MOD 64: OUT &HD9, I\64
40 FOR J=0 TO 31: A(J)=INP(&HD9): NEXT
50 FOR J=0 TO 7
60 PRINT RIGHT$("0000000"+BIN$(A(J)), 8);
70 PRINT RIGHT$("0000000"+BIN$(A(J+8)), 8)
80 NEXT
90 FOR J=16 TO 23
100 PRINT RIGHT$("0000000"+BIN$(A(J)), 8);
110 PRINT RIGHT$("0000000"+BIN$(A(J+8)), 8)
120 NEXT
130 PRINT
140 NEXT
*/

} // namespace openmsx

