// $Id: WavWriter.hh,v 1.4 2005/11/14 21:52:55 m9710797 Exp $

#ifndef WAVWRITER_HH
#define WAVWRITER_HH

#include "noncopyable.hh"
#include <string>
#include <cstdio>

namespace openmsx {

class WavWriter : private noncopyable
{
public:
	WavWriter(const std::string& filename,
	          unsigned channels, unsigned bits, unsigned frequency);
	~WavWriter();

	void write8mono(unsigned char val);
	void write8mono(unsigned char* buf, size_t len);
	void write16stereo(short left, short right);

	/** Flush data to file and update header. Try to make (possibly)
	  * incomplete file already usable for external programs.
	  */
	void flush();

private:
	FILE* wavfp;
	unsigned bytes;
};

} // namespace openmsx

#endif
