// $Id: BreakPoint.hh,v 1.5 2006/04/20 18:13:15 m9710797 Exp $

#ifndef BREAKPOINT_HH
#define BREAKPOINT_HH

#include "BreakPointBase.hh"
#include "openmsx.hh"

namespace openmsx {

class CliComm;
class TclObject;

/** Base class for CPU breakpoints.
 *  For performance reasons every bp is associated with exactly one
 *  (immutable) address.
 */
class BreakPoint : public BreakPointBase
{
public:
	BreakPoint(CliComm& CliComm, word address,
	           std::auto_ptr<TclObject> command,
	           std::auto_ptr<TclObject> condition);

	word getAddress() const;
	unsigned getId() const;

private:
	word address;
	unsigned id;

	static unsigned lastId;
};

} // namespace openmsx

#endif
