// $Id: SDLConsole.hh,v 1.25 2006/02/27 21:49:16 m9710797 Exp $

#ifndef SDLCONSOLE_HH
#define SDLCONSOLE_HH

#include "OSDConsoleRenderer.hh"
#include "noncopyable.hh"
#include <memory>

class SDL_Surface;

namespace openmsx {

class SDLImage;

class SDLConsole : public OSDConsoleRenderer, private noncopyable
{
public:
	SDLConsole(Reactor& reactor, SDL_Surface* screen);

	virtual void loadFont(const std::string& filename);
	virtual void loadBackground(const std::string& filename);
	virtual unsigned getScreenW() const;
	virtual unsigned getScreenH() const;

	virtual void paint();
	virtual const std::string& getName();

private:
	void updateConsoleRect();

	SDL_Surface* outputScreen;
	std::auto_ptr<SDLImage> backgroundImage;
	std::string backgroundName;
};

} // namespace openmsx

#endif
