// $Id: V9990P1Converter.hh,v 1.4 2005/02/17 19:39:02 m9710797 Exp $

#ifndef __V9990P1CONVERTER_HH__
#define __V9990P1CONVERTER_HH__

#include "openmsx.hh"
#include "Renderer.hh"

namespace openmsx {

class V9990;
class V9990VRAM;

template <class Pixel, Renderer::Zoom zoom>
class V9990P1Converter
{
public:
	V9990P1Converter(V9990* vdp_, Pixel* palette64);
	~V9990P1Converter();

	void convertLine(Pixel* linePtr,
	                 int displayX, int displayWidth, int displayY);

private:
	V9990* vdp;
	Pixel* palette64;
	V9990VRAM* vram;

	Pixel raster(int xA, int yA,
	             unsigned int nameTableA, unsigned int patternTableA,
	             int xB, int yB,
	             unsigned int nameTableB, unsigned int patternTableB,
	             int *visibleSprites, unsigned int x, unsigned int y);
	byte getPixel(int x, int y,
	              unsigned int nameTable, unsigned int patternTable);
	void determineVisibleSprites(int* visibleSprites, int displayY);
	byte getSpritePixel(int* visibleSprites, int x, int y, bool front);
};

} // namespace

#endif // __V9990PATTERNCONVERTER_HH__
