// $Id: MSXS1985.hh,v 1.9 2005/01/17 19:29:31 m9710797 Exp $

/*
 * This class implements the
 *   backup RAM
 *   bitmap function
 * of the S1985 MSX-engine
 * 
 *  TODO explanation  
 */

#ifndef __S1985_HH__
#define __S1985_HH__

#include "MSXDevice.hh"
#include "MSXDeviceSwitch.hh"
#include <memory>

namespace openmsx {

class Ram;

class MSXS1985 : public MSXDevice, public MSXSwitchedDevice
{
public:
	MSXS1985(const XMLElement& config, const EmuTime& time);
	virtual ~MSXS1985();
	
	virtual void reset(const EmuTime& time);
	virtual byte readIO(byte port, const EmuTime& time);
	virtual byte peekIO(byte port, const EmuTime& time) const;
	virtual void writeIO(byte port, byte value, const EmuTime& time);

private:
	const std::auto_ptr<Ram> ram;
	nibble address;

	byte color1;
	byte color2;
	byte pattern;
};

} // namespace openmsx

#endif
