/*
 * Copyright (c) 2000, Amnon BARAK (amnon@cs.huji.ac.il). All rights reserved.
 *
 *       MOSIX tunepass.c,v 1.1.1.1 1999/01/28 09:58:13 arielr Exp
 *
 * Permission to use, copy and distribute this software is hereby granted 
 * under the terms of version 2 or any later version of the GNU General Public
 * License, as published by the Free Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/syscall.h>
#include <sys/time.h>
#include <sys/fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#define	PAGE1	10	/* page changed before mmap */

void
not_mosix()
{
	fprintf(stderr,"tunepass ignored: This is NOT a MOSIX system!\n");
	exit(1);
}

int main(int na, char **argv)
{
	register int i, j;
	int o;
	char other[15];
	struct timeval t1, t2;
	char *mp=NULL;
	int usec[2];
	int mig=0;
	

	if(write(open("/proc/self/lock", 1), "1\n", 2) != 2 ||
		(mig = open("/proc/self/migrate", 1)) == -1)
		not_mosix();
	write(mig, "0\n", 2);
	if(na != 2 || (o = atoi(argv[1])) <= 0)
	{
		fprintf(stderr, "Usage: tunepass other\n");
		exit(1);
	}
	sprintf(other, "%d\n", o);
	for(i = 0 ; i < 2 ; i++)
	{
		if(i)
		{
			mp = mmap(0, 4096*250, PROT_READ|PROT_WRITE,
				MAP_PRIVATE|MAP_ANON, -1, 0);
			for(j = 0 ; j < 4096*250 ; j += 4096)
				mp[j]++;
		}
		gettimeofday(&t1, 0);
		for(j = 0 ; j < 5 ; j++)
		{
			write(mig, other, strlen(other));
			write(mig, "0\n", 2);
		}
		gettimeofday(&t2, 0);
		usec[i] = (t2.tv_sec-t1.tv_sec) * 1000000 + t2.tv_usec - t1.tv_usec;
	}
	munmap(mp, 1024*1000);
	j = (usec[1] - usec[0]) / (10*250);
	i = usec[0]/10 - PAGE1*j;
	printf("#define	MIGRATION_COST_BASIC	%d\n", i);
	printf("#define	MIGRATION_COST_PER_PAGE	%d\n", j);

	return 0;
}
