/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Amnon Shiloh.
 */
#ifndef _MOS_DFSA_H
#define _MOS_DFSA_H

#include <linux/fs.h>
#include <linux/file.h>
#include <linux/mount.h>
#include <linux/dfsa_interface.h>

#ifdef CONFIG_MOSIX_DFSA

#define	MAXDFSAFS	8
#define	MAXDFSALINKS	8
#define	MAXDFSALINKLEN	128

struct dfsatab
{
	unsigned short len;
	char ndefs;
	struct dfsdef
	{
		char defno;	/* mount=1-MAXDFSAFS, symlink>MAXDFSAFS */
		char mounted;
		short offset;
	} dfsdef[0];
};

/* update flags (dupdates): */

int dfsa_addlink(char *);
int dfsa_dellink(char *);
int dfsa_clearlinks(void);
char *dfsa_showlinks(void);
void dfsa_adapt(struct dfsatab *);
int dfsa_sync(int);
void dfsa_everyone_was_updated(void);
void clear_dfsasync(void);
void remote_clear_dfsa(void);
void dfsa_tinit(void); 
void deputy_resync_dfsa(void);
char *deputy_pack_dfsa_changes(int *);
void remote_unpack_dfsa_changes(char *);
char *remote_pack_dfsa_changes(int *);
void deputy_unpack_dfsa_changes(char *);
void dfsa_check_comm_send(int *, char **, int *);
void dfsa_comm_recv(int, char *);
int enter_remote_dfsa_mode(void);
void leave_remote_dfsa_mode(void);
void dfsa_exit(void);

#endif
#endif
