/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Oren Laadan, Amnon Shiloh.
 */

/* interfacing the MOSIX communication package: */

#ifndef _MOS_COMM_H
#define _MOS_COMM_H

#ifdef __KERNEL__

struct mosix_link;			/* defined in mos/comm.c */
struct mosix_addr;			/* defined in include/mos/protocol.h */
struct mosix_task;
typedef struct mosix_link mosix_link;
typedef struct mosix_addr mosix_addr;

/*
 * values for mos# (e.g. in comm_open)
 * 1..65535	-> valid mos# (mig)
 * -1..-65535	-> valid mos# (info)
 */

#define COMM_TOADDR	(70001)
#define COMM_ACCEPT	(70002)
#define COMM_MIGD	(70003)
#define COMM_INFO	(70004)
#define	COMM_LOOSE	(70005)

/*
 * message flags:
 * lower 16 bits used for message types (see mos/protocol.h)
 * next 8 bits used for message flags (see below)
 * upper 8 bits used for mosix logging
 */
#define COMM_MFREGS	0x00800000
#define COMM_MFDATA	0x00400000
#define COMM_MFIDENT	0x00100000
#ifdef CONFIG_MOSIX_DFSA
#define	COMM_MFDFSA	0x00080000
#define	COMM_MFNODFSA	0x00040000
#define	COMM_MFDFSAOPTS	(COMM_MFDFSA|COMM_MFNODFSA)
#endif /* CONFIG_MOSIX_DFSA */

#define COMM_MFOPTIONS	0x00ff0000
#define	COMM_MFHEADOPTS	(COMM_MFREGS|COMM_MFIDENT)

#define	COMM_ZEROCOPYOK	0x40000000

/*
 * other flags
 */
#define COMM_ALLDATA	(-1)	/* copy/flush all available data */


/*
 * message format
 */
struct comm_header {
	unsigned short olen;
	unsigned short hlen;
	int type;
	int dlen;
	int regs;
	int dfsalen;
};

#define COMM_HLEN	(sizeof(struct comm_header))

/*
 * exported data
 */
extern int comm_type;
extern unsigned long comm_remote_timo;
extern unsigned long comm_connect_timo;
extern unsigned long comm_reconn_timo;

/*
 * communication module interface
 */

extern void comm_startup(void);
extern mosix_link *comm_open(int, mosix_addr *, unsigned long);
extern mosix_link *comm_use(struct task_struct *, mosix_link *);
extern void comm_close(mosix_link *);
extern int comm_accept(mosix_link *,mosix_link **, mosix_addr *,unsigned long);
extern int comm_send(int, void *, int, void *, int, int);
extern int comm_recv(void **, int *);
extern int comm_recvdata(void **);
extern int comm_copydata(void *, int, int);
extern int comm_hidedata(void);
extern void comm_flushdata(int);
extern void comm_free(void *);
extern int comm_peek(void);
extern int comm_wait(void);
extern int comm_send_urgent(void);
extern int comm_test_urgent(void);
extern void comm_take_urgent(void);
extern int comm_sendto(int, void *, int, mosix_link *, mosix_addr *);
extern int comm_recvfrom(void *,int, mosix_link *, mosix_addr *, unsigned long);
extern int comm_recvfrompe(void *,int, mosix_link *, int *, unsigned long);
extern int net_to_mos(mosix_addr *);

extern inline void comm_invalidate_address(mosix_addr *);
extern void comm_migration_mode(int);
extern int comm_getpeer(mosix_link *);
extern void comm_init_linkpool(void);
extern void comm_free_linkpool(void);
extern mosix_link *comm_borrow_linkpool(void);
extern void comm_return_linkpool(mosix_link *);
extern void comm_age_linkpool(void);
extern void rinode_flush_files(int);

extern spinlock_t skown_lock;

#endif /* __KERNEL__ */

#endif
