/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



/*   Binding, unbinding, special variables in general. */


	include(lisp.s)
	_beginfile
	.globl ksignalerr
/* Set the special variable in arg_y to the value in arg_z. 
   Error if arg_y is a constant. 
   arg_y is a known, non-nil symbol. */
_spentry(setqsym)
	__(lwz imm0,symbol.flags(arg_y))
	__(andi. imm0,imm0,(1<<sym_vbit_const))
	__(bne- cr0,1f)
	__(la loc_g,symbol.vcell(arg_y))
	__(push(loc_g,memo))
	__(stw arg_z,0(loc_g))
	__(blr)
1:
	__(mr arg_z,arg_y)
	__(lwi(arg_y,XCONST))
	__(set_nargs(2))
	__(b ksignalerr)

/* Bind special symbol in arg_y to value in arg_z. */
_spentry(bind)
	__(lwz temp1,symbol.vcell(arg_y))
	__(ref_global(imm1,db_link))
	__(vpush(temp1))
	__(vpush(arg_y))
	__(vpush(imm1))
	__(set_global(vsp,db_link))
	__(stw arg_z,symbol.vcell(arg_y))
	__(blr)

/* Bind special symbol in arg_z to its current value. */
_spentry(bind_self_boundp_check)
	__(lwz temp1,symbol.vcell(arg_z))
	__(tweqi temp1,unbound_marker)
	__(b bind_self_aux)

_spentry(bind_self)
	__(lwz temp1,symbol.vcell(arg_z))
bind_self_aux:
	__(ref_global(imm1,db_link))
	__(vpush(temp1))
	__(vpush(arg_z))
	__(vpush(imm1))
	__(set_global(vsp,db_link))
	__(blr)

/* Bind special symbol in arg_z to  NIL. */
_spentry(bind_nil)
	__(lwz temp1,symbol.vcell(arg_z))
	__(ref_global(imm1,db_link))
	__(vpush(temp1))
	__(vpush(arg_z))
	__(vpush(imm1))
	__(set_global(vsp,db_link))
	__(stw rnil,symbol.vcell(arg_z))
	__(blr)

/* Undo one special binding. */
_spentry(unbind)
	__(ref_global(imm1,db_link))
	__(lwz temp0,4(imm1))
	__(lwz temp1,8(imm1))
	__(lwz imm1,0(imm1))
	__(set_global(imm1,db_link))
	__(stw temp1,symbol.vcell(temp0))
	__(blr)

/* Undo N special bindings: imm0 = n, unboxed and >0. */
_spentry(unbind_n)
.unbind_n:
	__(ref_global(imm1,db_link))
1:
	__(subi imm0,imm0,1)
	__(cmpwi cr0,imm0,0)
	__(lwz temp0,4(imm1))
	__(lwz temp1,8(imm1))
	__(lwz imm1,0(imm1))
	__(stw temp1,symbol.vcell(temp0))
	__(bne cr0,1b)
	__(set_global(imm1,db_link))
	__(blr)

/* Unwind special bindings until the head of the linked list = imm0. 
   Clobbers arg_x, arg_y, imm2, imm1. */
_spentry(unbind_to)
	__(ref_global(imm1,db_link))
1:
	__(lwz imm2,0(imm1))
	__(lwz arg_x,4(imm1))
	__(cmpw cr0,imm0,imm2)
	__(lwz arg_y,8(imm1))
	__(mr imm1,imm2)
	__(stw arg_y,symbol.vcell(arg_x))
	__(bne cr0,1b)
	__(set_global(imm1,db_link))
	__(blr)

/* save the values of a list of special variables (arg_y); set them 
   to the corresponding values in the list in arg_z. 
   We've checked to make sure that arg_y is a proper list of bindable 
   symbols, but we're not sure what's in arg_z. 
   Save the special binding triplets on the tstack.  If there's not 
   enough room, die.  Prepend the triplets with a boxed triplet 
   count. */
_spentry(progvsave)
        /* First, determine the length of arg_y.  We */
        /* know that it's a proper list. */
	__(li imm0,-4)
	__(mr temp0,arg_y)
1:
	__(cmpw cr0,temp0,rnil)
	__(la imm0,4(imm0))
	__(_cdr(temp0,temp0))
	__(bne 1b)
	/* imm0 is now (boxed) triplet count. */
	/* Determine word count, add 1 (to align), and make room. */
	/* if count is 0, make an empty tsp frame and exit */
	__(cmpwi cr0,imm0,0)
	__(add imm1,imm0,imm0)
	__(add imm1,imm1,imm0)
	__(la imm1,4+7(imm1))
	__(clrrwi imm1,imm1,3)
	__(bne+ cr0,2f)
	 __(stwu tsp,-16(tsp))
	 __(stw rzero,4(tsp))
	 __(stw rzero,8(tsp))
	 __(stw rzero,12(tsp))
	 __(blr)
2:
	__(neg imm1,imm1)
	__(la imm1,-8(imm1))	/* tsp header */
	__(mr initptr,tsp)          /* uninterruptable */
	__(stwux tsp,tsp,imm1)
	__(stw rzero,4(tsp))
	__(sub initptr,tsp,imm1)	/* in case we just overflowed the stack segment */
	__(stw imm0,8(tsp))
	__(stw rzero,12(tsp))
	__(mr temp0,arg_y)
	__(ref_global(imm1,db_link))
	/*  Save all bindings, then do the setqs. */
3:
	__(_car(temp1,temp0))
	__(_cdr(temp0,temp0))
	__(cmpw cr0,temp0,rnil)
	__(lwz temp2,symbol.vcell(temp1))
	__(push(temp2,initptr))
	__(push(temp1,initptr))
	__(push(imm1,initptr))
	__(mr imm1,initptr)
	__(bne cr0,3b)
	__(set_global(imm1,db_link))
	/* Now do assignments.  The TSP frame is gc-safe, */
	/* so it's safe to error if arg_z isn't a proper list. */
	__(mr initptr,freeptr)
	__(mr temp0,arg_z)

4:
	__(trap_unless_lisptag_equal(temp0,tag_list,imm0))
	__(_car(temp1,arg_y))
	__(_cdr(arg_y,arg_y))
	__(cmpw cr1,arg_y,rnil)
	__(_car(temp2,temp0))
	__(_cdr(temp0,temp0))
	__(stw temp2,symbol.vcell(temp1))
	__(bne cr1,4b)
	__(blr)

/*
   Restore the special bindings from the top of the tstack, 
   leaving the tstack frame allocated. 
   Note that there might be 0 saved bindings, in which case 
   do nothing. 
   Note also that this is -only- called from an unwind-protect 
   cleanup form, and that .SPnthrowXXX is keeping one or more 
   values in a frame on top of the tstack. 
*/
	
_spentry(progvrestore)
	__(lwz imm0,0(tsp))	/* ignore .SPnthrowXXX values frame */
	__(lwz imm0,8(imm0))
	__(cmpwi cr0,imm0,0)
	__(unbox_fixnum(imm0,imm0))
	__(bne+ cr0,.unbind_n)
	__(blr)
	
	
	_endfile
