/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


/* Find and load the subprims; establish (& export) subprims_base.
   This must happen before clients (which import subprims_base) get loaded
   by the OS PEF loader. */
   

#ifdef VXWORKS
#include <vxWorks.h>
#endif
#include "lisp.h"
#include "memprotect.h"
#include "Threads.h"
#ifdef LINUX
#include <dlfcn.h>
#endif
#ifdef VXWORKS
#include <stdio.h>
#include <symLib.h>
#include <sysSymTbl.h>
#include <moduleLib.h>
#include <loadLib.h>
#include <unldLib.h>
#include <fcntl.h>
#include <memLib.h>
#endif

#ifdef DARWIN
#undef undefined
#include <mach-o/dyld.h>
#endif

extern LispObj subprims_base, ret1valn, lexpr_return, lexpr_return1v;
extern ProcPtr start_lisp;

LispObj *emulator_base = NULL;

Ptr subprims_ptr;




#ifdef VXWORKS
MODULE_ID subprims_module = (MODULE_ID)0;
extern void
load_module_low(char *, MODULE_ID*);
void *
dlsym1(void*, char *);
#endif

Boolean
load_subprims(char *libname)
{
  void *libhandle;
  void *address;

  if (subprims_base != (LispObj)NULL) {
    /* Subprims are statically linked into kernel, no need to open
       shared lib */
    return true;
  }
#ifdef LINUX
  if (libhandle = dlopen(libname, 0)) {
    if ((subprims_base = (LispObj) dlsym(libhandle, ".subprims_base")) &&
	(start_lisp = (ProcPtr) dlsym(libhandle, ".start_lisp")) &&
	(lexpr_return = (LispObj) dlsym(libhandle, ".nvalret")) &&
	(lexpr_return1v = (LispObj) dlsym(libhandle, ".popj")) &&
	(ret1valn = (LispObj) dlsym(libhandle, ".ret1valn"))) {
      return true;
    }
  }
#endif
#ifdef VXWORKS
  load_module_low(libname, &subprims_module);
  if (subprims_module != (MODULE_ID)0) {
    libhandle = (void *)-1;
    if ((subprims_base = (LispObj) dlsym1(libhandle, ".subprims_base")) &&
	(start_lisp = (ProcPtr) dlsym1(libhandle, ".start_lisp")) &&
	(lexpr_return = (LispObj) dlsym1(libhandle, ".nvalret")) &&
	(lexpr_return1v = (LispObj) dlsym1(libhandle, ".popj")) &&
	(ret1valn = (LispObj) dlsym1(libhandle, ".ret1valn"))) {
      return true;
    }
  }
#endif
  return false;
}

#ifdef VXWORKS
extern LispObj vx_signal, init_vxlow, vxlow_cleanup;
MODULE_ID vxlow_module = (MODULE_ID)0;

Boolean
load_vxlow(char *libname)
{
  void *libhandle;
  void *address;

  load_module_low(libname, &vxlow_module);
  if (vxlow_module != (MODULE_ID)0) {
    libhandle = (void *)-1;
    if ((vx_signal = (LispObj) dlsym1(libhandle, "vx_signal")) &&
	(init_vxlow = (LispObj) dlsym1(libhandle, "init_vxlow")) &&
	(vxlow_cleanup = (LispObj) dlsym1(libhandle, "vxlow_cleanup"))) {
      return true;
    }
  }
  return false;
}

void
bad()
{
  Bug("call to undefined foreign function");
}

#define ADD_LOCAL_SYMBOL(name) symAdd(local_symbols, #name, (char *)name, 0,0)

SYMTAB_ID local_symbols;
void
vxsymtab_init()
{
  extern int
    __xstat(),
    gettimeofday(),
    realpath(),
    __lxstat(),
    getrusage(),
    getuid(),
    __tcgetattr(),
    getpwuid(),
    acosh(),
    atanh(),
    asinh();

  local_symbols = symTblCreate(5, 0, memSysPartId);
  ADD_LOCAL_SYMBOL(__xstat);
  ADD_LOCAL_SYMBOL(gettimeofday);
  ADD_LOCAL_SYMBOL(realpath);
  ADD_LOCAL_SYMBOL(__lxstat);
  ADD_LOCAL_SYMBOL(getrusage);
  ADD_LOCAL_SYMBOL(getuid);
  ADD_LOCAL_SYMBOL(__tcgetattr);
  ADD_LOCAL_SYMBOL(getpwuid);
  ADD_LOCAL_SYMBOL(acosh);
  ADD_LOCAL_SYMBOL(atanh);
  ADD_LOCAL_SYMBOL(asinh);
}
  
#endif

void *
FindSymbol(void* handle, char *name)
{
#ifdef LINUX
  return dlsym(handle, name);
#endif
#ifdef DARWIN
  unsigned long address = 0;

  if (handle == NULL) {
    if (NSIsSymbolNameDefined(name)) { /* Keep dyld_lookup from crashing */
      _dyld_lookup_and_bind(name, &address, (void**) NULL);
    }
    return (void *)address;
  }
  Bug(NULL, "How did this happen ?");
#endif
#ifdef VXWORKS
  SYMTAB_ID symtab;
  SYM_TYPE symtype;
  char *value = NULL;

  if (handle == (void *) -1) {
    symtab = sysSymTbl;
  } else {
    symtab = (SYMTAB_ID) handle;
  }
  symFindByName(symtab, name, &value, &symtype);
  if ((value == NULL) && (symtab == sysSymTbl)) {
    if (local_symbols == (SYMTAB_ID) 0) {
      vxsymtab_init();
    }
    symFindByName(local_symbols, name, &value, &symtype);
  }
  if (value == NULL) {
    fprintf(stderr, "Symbol lookup failed for %s\n", name);
    fflush(stderr);
    value = (void *) bad;
  }
  return (void *) value;
#endif
}

#ifdef VXWORKS

#define is_26_bit(a) ((int)(a) == (((int)(a) << 6) >> 6))

/* Some modules may define entrypoints that are the targets of absolute
   branch instructions, or are the targets of pc-relative branch instructions
   from absolute locations (e.g., exception vectors in low memory.)  We need
   to load such modules at addresses in the low 26 bits of memory.  It's
   simple to do so using loadModuleAt(); it's trickier to allocate memory
   at such an address.
*/

void
free_memory_chain(char *head)
{
  while (head) {
    char *next = *(char **)head;
    free(head);
    head = next;
  }
}

char *
malloc26(int size)
{
  char *chain = NULL, *p;
  int big;
  
  /* Keep allocating the largest possible block in the system
     partition until we get a block that's in low memory or
     until the allocation fails. */

  while (1) {
    big = memPartFindMax(memSysPartId);
    p = (char *)malloc(big);
    if (p == NULL) {
      break;
    }
    if (is_26_bit(p) && is_26_bit(p+size-1)) {
      p = (char *)realloc(p,size);
      break;
    }
    *(char **)p = chain;
    chain = p;
  }
  free_memory_chain(chain);
  return p;
}

void
load_module_low(char *pathname, MODULE_ID *modp)
{
  MODULE_ID module = *modp;
  MODULE_INFO info;
  int fd, textstart, textsize, textend;
  char *low_text_start;

  if (module == (MODULE_ID)0) {
    fd = open(pathname, O_RDONLY, 0);
    if (fd != -1) {
      module = loadModule(fd, LOAD_ALL_SYMBOLS);
      if (module != (MODULE_ID)0) {
	moduleInfoGet(module, &info);
	textsize = info.segInfo.textSize;
	textstart = (int) info.segInfo.textAddr;
	textend = textstart+textsize-1;
	if (! (is_26_bit(textstart) && is_26_bit(textend))) {
	  /* Current address isn't good.  Unload, allocate low
	     memory for text segment, and use loadModuleAt() */
	  unldByModuleId(module, 0);
	  low_text_start = (char *)malloc26(textsize);
	  module = NULL;
	  if (low_text_start) {
	    module = loadModuleAt(fd, 
				  LOAD_GLOBAL_SYMBOLS, 
				  &low_text_start,
				  NULL,
				  NULL);
	  }
	}
	*modp = module;
	close(fd);
      }
    }
  }
}
#endif
