;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;




;; Level-2.lisp

(in-package :ccl)

(eval-when (eval compile)
  (require "LEVEL-2")
  (require "BACKQUOTE")
  (require "DEFSTRUCT-MACROS"))



(eval-when (eval compile)
  (require "LISPEQU"))








; This incredibly essential thing is part of ANSI CL; put it in the
; right package someday.
; Like maybe when it says something about doc strings, or otherwise
; becomes useful.

(defun parse-macro (name arglist body &optional env)
  (values (parse-macro-1 name arglist body env)))

; Return a list containing a special declaration for SYM
; if SYM is declared special in decls.
; This is so we can be pedantic about binding &WHOLE/&ENVIRONMENT args
; that have been scarfed out of a macro-like lambda list.
; The returned value is supposed to be suitable for splicing ...
(defun hoist-special-decls (sym decls)
  (when sym
    (dolist (decl decls)
      (dolist (spec (cdr decl))
        (when (eq (car spec) 'special)
          (dolist (s (%cdr spec))
            (when (eq s sym)
              (return-from hoist-special-decls `((declare (special ,sym)))))))))))

(defun parse-macro-1 (name arglist body &optional env)
  (unless (verify-lambda-list arglist t t t)
    (error "Invalid lambda list ~s" arglist))
  (multiple-value-bind (lambda-list whole environment)
                       (normalize-lambda-list arglist t t)
    (multiple-value-bind (body local-decs doc)
                         (parse-body body env t)
      (unless whole (setq whole (gensym)))
      (unless environment (setq environment (gensym)))
      (values
       `(lambda (,whole ,environment)
          (declare (ignore-if-unused ,environment))
          ,@(hoist-special-decls whole local-decs)
          ,@(hoist-special-decls environment local-decs)
          (macro-bind ,lambda-list ,whole
                      ,@local-decs 
                      (block ,name ,@body)))
       doc))))









(defun apply-to-htab-syms (function pkg-vector)
  (let* ((sym nil)
         (foundp nil))
    (dotimes (i (uvsize pkg-vector))
      (declare (fixnum i))
      (multiple-value-setq (sym foundp) (%htab-symbol pkg-vector i))
      (when foundp (funcall function sym)))))

(defun iterate-over-external-symbols (pkg-spec function)
  (apply-to-htab-syms function (car (pkg.etab (pkg-arg (or pkg-spec *package*))))))

(defun iterate-over-present-symbols (pkg-spec function)
  (let ((pkg (pkg-arg (or pkg-spec *package*))))
    (apply-to-htab-syms function (car (pkg.etab pkg)))
    (apply-to-htab-syms function (car (pkg.itab pkg)))))

(defun iterate-over-accessable-symbols (pkg-spec function)
  (let* ((pkg (pkg-arg (or pkg-spec *package*)))
         (used (pkg.used pkg))
         (shadowed (pkg.shadowed pkg)))
    (iterate-over-present-symbols pkg function)
    (when used
      (if shadowed
        (flet ((ignore-shadowed-conflicts (var)
                 (unless (%name-present-in-package-p (symbol-name var) pkg)
                   (funcall function var))))
          (declare (dynamic-extent #'ignore-shadowed-conflicts))
          (dolist (u used) (iterate-over-external-symbols u #'ignore-shadowed-conflicts)))
        (dolist (u used) (iterate-over-external-symbols u function))))))

(defun iterate-over-all-symbols (function)
  (dolist (pkg %all-packages%)
    (iterate-over-present-symbols pkg function)))          


;Eval definitions for things open-coded by the compiler.
;Don't use DEFUN since it should be illegal to DEFUN compiler special forms...
;Of course, these aren't special forms.
(macrolet ((%eval-redef (name vars &rest body)
             (when (null body) (setq body `((,name ,@vars))))
             `(setf (symbol-function ',name)
                    (qlfun ,name ,vars ,@body))))
  (%eval-redef %ilsl (n x))
  (%eval-redef %ilsr (n x))
  (%eval-redef neq (x y))
  (%eval-redef not (x))
  (%eval-redef null (x))
  (%eval-redef rplaca (x y))
  (%eval-redef rplacd (x y))
  (%eval-redef set-car (x y))
  (%eval-redef set-cdr (x y))
  (%eval-redef int>0-p (x))
  (%eval-redef %get-byte (ptr &optional (offset 0)) (%get-byte ptr offset))
  (%eval-redef %get-word (ptr &optional (offset 0)) (%get-word ptr offset))
  (%eval-redef %get-signed-byte (ptr &optional (offset 0)) (%get-signed-byte ptr offset))
  (%eval-redef %get-signed-word (ptr &optional (offset 0)) (%get-signed-word ptr offset))
  (%eval-redef %get-long (ptr &optional (offset 0)) (%get-long ptr offset))
  (%eval-redef %get-fixnum (ptr &optional (offset 0)) (%get-fixnum ptr offset))
  (%eval-redef %get-point (ptr &optional (offset 0)) (%get-point ptr offset))
  (%eval-redef %get-signed-long (ptr &optional (offset 0)) (%get-signed-long ptr offset))
  (%eval-redef %get-unsigned-long (ptr &optional (offset 0)) (%get-unsigned-long ptr offset))
  (%eval-redef %get-ptr (ptr &optional (offset 0)) (%get-ptr ptr offset))
  (%eval-redef %put-byte (ptr val &optional (offset 0)) (%put-byte ptr val offset))
  (%eval-redef %put-word (ptr val &optional (offset 0)) (%put-word ptr val offset))
  (%eval-redef %put-long (ptr val &optional (offset 0)) (%put-long ptr val offset))
  (%eval-redef %put-point (ptr val &optional (offset 0)) (%put-point ptr val offset))
  (%eval-redef %put-ptr (ptr val &optional (offset 0)) (%put-ptr ptr val offset))
  (%eval-redef %get-full-long (ptr &optional (offset 0)) (%get-full-long ptr offset))
  (%eval-redef %put-full-long (ptr val &optional (offset 0)) (%put-full-long ptr val offset))
  (%eval-redef %int-to-ptr (int))
  (%eval-redef %ptr-to-int (ptr))
  (%eval-redef %ptr-eql (ptr1 ptr2))
  (%eval-redef %setf-macptr (ptr1 ptr2))
  (%eval-redef %null-ptr-p (ptr))


  (%eval-redef %newgotag ())
  (%eval-redef %iasr (x y))

  
  (%eval-redef %set-byte (p o &optional (new (prog1 o (setq o 0))))
               (%set-byte p o new))
  (%eval-redef %set-word (p o &optional (new (prog1 o (setq o 0))))
               (%set-word p o new))
  (%eval-redef %set-long (p o &optional (new (prog1 o (setq o 0))))
               (%set-long p o new))
  (%eval-redef %set-ptr (p o &optional (new (prog1 o (setq o 0))))
               (%set-ptr p o new))

  
  (%eval-redef %word-to-int (word))
  (%eval-redef %inc-ptr (ptr &optional (by 1)) (%inc-ptr ptr by))
  
  (%eval-redef char-code (x))
  (%eval-redef code-char (x))
  (%eval-redef 1- (n))
  (%eval-redef 1+ (n))

  (%eval-redef uvref (x y))
  (%eval-redef uvset (x y z))
  (%eval-redef uvsize (x))

  (%eval-redef svref (x y))
  (%eval-redef svset (x y z))
  
 
  (%eval-redef integer-point-h (x))
  (%eval-redef integer-point-v (x))
  
  (%eval-redef car (x))
  (%eval-redef cdr (x))
  (%eval-redef cons (x y))
  (%eval-redef endp (x))

  (progn
    (%eval-redef %typed-miscref (s a i))
    (%eval-redef %typed-miscset (s a i v))
    (%eval-redef typecode (x))
    (%eval-redef lisptag (x))
    (%eval-redef fulltag (x))
    (%eval-redef %unbound-marker ())
    (%eval-redef %illegal-marker ())
    (%eval-redef %alloc-misc (x y))
    (%eval-redef %typed-misc-ref (x y z))
    (%eval-redef %typed-misc-set (w x y z))
    (%eval-redef %setf-double-float (x y))
    (%eval-redef %lisp-word-ref (x y))
    (%eval-redef %temp-cons (x y))
    (%eval-redef require-fixnum (x))
    (%eval-redef require-symbol (x))
    (%eval-redef require-list (x))
    (%eval-redef require-real (x))
    (%eval-redef require-simple-string (x))
    (%eval-redef require-simple-vector (x))
    (%eval-redef require-character (x))
    (%eval-redef require-number (x))
    (%eval-redef require-integer (x))
    (%eval-redef %reference-external-entry-point (x))
    )
  
  (%eval-redef listp (x))
  (%eval-redef %get-bit (ptr offset))
  (%eval-redef %set-bit (ptr offset val))
	       
)

; In the spirit of eval-redef ...


;; pointer hacking stuff 
;
;



;;; I'd guess that the majority of bitfields in the world whose width is
;;; greater than 1 have a width of two.  If that's true, this is probably
;;; faster than trying to be more clever about it would be.
(defun %get-bitfield (ptr start-bit width)
  (declare (fixnum start-bit width))
  (do* ((bit start-bit (1+ bit))
	(i 0 (1+ i))
	(val 0))
       ((= i width) val)
    (declare (fixnum val i bit))
    (setq val (logior (ash val 1) (%get-bit ptr bit)))))

(defun (setf %get-bitfield) (val ptr start width)
  (declare (fixnum val start width))
  (do* ((v val (ash v -1))
	(bit (1- (+ start width)) (1- bit))
	(i 0 (1+ i)))
       ((= i width) val)
    (declare (fixnum v bit i))
    (setf (%get-bit ptr bit) (logand v 1))))

; expands into compiler stuff

(setf (symbol-function '%get-unsigned-byte) (symbol-function '%get-byte))
(setf (symbol-function '%get-unsigned-word) (symbol-function '%get-word))
(setf (symbol-function '%get-signed-long) (symbol-function '%get-long))



(defun %clear-pointer (pointer &aux pointer-size)
  (when (and (setq pointer-size (pointer-size pointer))
             (plusp pointer-size))
    (%clear-block pointer pointer-size)))


#+ppc-target
(defppclapfunction %clear-block ((pointer arg_y) (length arg_z))
  (unbox-fixnum imm0 length)
  (cmpwi cr0 imm0 0)  ; or unbox-fixnum. above  (this was missing its last operand.)
  (macptr-ptr imm1 pointer)
  (add imm1 imm1 imm0) ; point past last byte
  (beq @done)
  @loop  
  (cmpwi cr0 imm0 1)                    ; set cr0_eq if last time through
  (stbu rzero -1 imm1)
  (subi imm0 imm0 1)
  (bne @loop)
  @done
  (mr arg_z pointer)
  (blr))

#+sparc-target
(defsparclapfunction %clear-block ((pointer %arg_y) (length %arg_z))
  (unbox-fixnum length %imm0)
  (tst %imm0)
  (macptr-ptr pointer %imm1)
  (be @done)
    (add %imm1 %imm0 %imm1) ; point past last byte

  @loop
  (deccc %imm0)
  (dec %imm1)
  (bne @loop)
   (stb %rzero (%imm1))
  @done
  (retl)
  (mov pointer %arg_z))



; end of moved stuff




(defun decompose-record-accessor (accessor &aux ret)
  (do* ((str (symbol-name accessor) (%substr str (+ i 1) len))
        (len (length str) (length str))
        (i (%str-member #\. str) (%str-member #\. str))
        (field (%substr str 0 (or i len)) (%substr str 0 (or i len))))
       ((not i) (nreverse (cons (make-keyword field) ret)))
    (push (make-keyword field) ret)))




(provide 'level-2)

	


;; end of level-2.lisp

