;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;
(eval-when (:compile-toplevel :execute)
  (require "SPARC-ARCH")
  (require "SPARC-LAPMACROS"))

; This assumes that macros & special-operators
; have something that's not FUNCTIONP in their
; function-cells.
(defsparclapfunction %function ((sym %arg_z))
  (check-nargs 1)
  (cmp sym %rnil)
  (let ((symptr %temp0)
        (symbol %temp1)
        (def %arg_z))
    (add %rnil arch::nilsym-offset symptr)
    (be.a @havesymptr)
      (mov sym symbol)
    (trap-unless-typecode= sym arch::subtag-symbol)
    (mov sym symptr)
    @havesymptr
    (ld (symptr arch::symbol.fcell) def)
    (extract-typecode def %imm0)
    (cmp %imm0 arch::subtag-function)
    (bne.a @done)
    (uuo_interr arch::error-udf symbol)
    @done
    (retl)
     (nop)))

; Traps unless sym is NIL or some other symbol.
(defsparclapfunction %symbol->symptr ((sym %arg_z))
  (cmp %arg_z %rnil)
  (be.a @done)
    (add %rnil arch::nilsym-offset %arg_z)
  (trap-unless-typecode= %arg_z arch::subtag-symbol)
  @done
  (retl)
    (nop))

; Traps unless symptr is a symbol; returns NIL if symptr is NILSYM.
(defsparclapfunction %symptr->symbol ((symptr %arg_z))
  (add %rnil arch::nilsym-offset %imm1)
  (cmp %imm1 symptr)
  (be.a @done)
    (mov %rnil %arg_z)
  (trap-unless-typecode= symptr arch::subtag-symbol %imm0)
  @done
  (retl)
    (nop))
