# cache.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Class ProgramCache

ProgramCache public init {} {
    $self set children_ {}
}

ProgramCache public addsource s {}

ProgramCache public addprog {src prog} {
    $self instvar progs_ children_
    set progs_([$prog unique_key]) $prog

    # push to listeners
    foreach child $children_ {
	$self sendprog $child add $prog
    }
}

ProgramCache public removeprog {src prog} {
    $self instvar progs_ children_
    set key [$prog unique_key]
    catch { unset progs_($key) }

    # push to listeners
    foreach child $children_ {
	$child send "remove $key\n\n"
    }
}

ProgramCache public updateprog {src prog} {
    $self instvar progs_ children_

    # push to listeners
    foreach child $children_ {
	$self sendprog $child update $prog
    }
}

ProgramCache public subscribe {child} {
    $self instvar children_ progs_
    lappend children_ $child

    # give this child all programs we have so far
    foreach k [array names progs_] {
	$self sendprog $child add $progs_($k)
    }
}

ProgramCache public unsubscribe {child} {
    $self instvar children_
    set i [lsearch -exact $children_ $child]
    if {$i >= 0} {
	set children_ [lreplace $children_ $i $i]
    }
}

ProgramCache private sendprog {child cmd prog} {
    $child send "$cmd\n"
    foreach m [$prog set msgs_] {
	$child send [$m set msgtext_]
    }
    $child send "\n\n"
}

#FIXME advertise
