# audio-monitor.tcl --
#
#       Defines class AudioMonitor, which is needed by the remote vic UI 
#       object
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/rvic/audio-monitor.tcl,v 1.2 2002/02/03 04:29:27 lim Exp $


import RTPAgent

# An agent to monitor RTP audio activity
Class AudioMonitor -superclass RTPAgent

#FIXME
AudioMonitor private create_session {} {
	return [new Session/RTP/Audio]
}

#
AudioMonitor instproc init { ab ui } {
	$self next $ab
	$self set ui_ $ui
}

#
AudioMonitor instproc activate src {
	$self instvar null_
	if ![info exists null_] {
		set null_ [new Module/AudioDecoder]
	}
	$src handler $null_
	$self next $src
# puts "activate [$src getid]"
}

#
AudioMonitor instproc trigger_media src {
	#FIXME race: if src disappears will get an undefined command
	after 500 "$src enable_trigger"
	$self next $src
	$self instvar ui_

	$ui_ switch_to $src
}

#
AudioMonitor instproc create-session sessionType {
	if { $sessionType == "rtpv2" || $sessionType == "rtp" } {
		set sessionType RTP
	}
	return [new Session/$sessionType/Audio]
}

