# application-uc.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/uc/application-uc.tcl,v 1.4 2002/02/03 04:22:33 lim Exp $


import UniversalUI

#
# application wrapper for the a (meta-) application UniversalUI
#
Class UniversalClientApp -superclass Application


#
# constructor: args passed directly to a new UniversalUI class
#
UniversalClientApp public init {argv} {
    $self next universalclient

    set o [$self options]
    $o register_option -rendez rendez
    $o add_default rendez 224.2.127.253/1202
    $o register_option -mysrvsdir mySrvsDir
    $o add_default mySrvsDir ~/.mash/mysrvs
    set argv [$o parse_args $argv]

    if {[llength $argv] % 2 != 0} {
	$self usage
    }

    frame .f
    pack .f
    set ui_ [eval new UniversalUI .f $argv]
}

#
UniversalClientApp public usage {} {
    global argv0
    puts "Usage: $argv0 ?-rendez <addrSpec>?"
    puts "              ?<UIobjectName> <addrSpec> ...?\n"
    exit
}

