/*
 * tkwidget.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/misc/tkwidget.cc,v 1.14 2002/02/03 04:11:42 lim Exp $";

#include <stdlib.h>
#include "tkwidget.h"
#include "tclcl.h"

TkWidget::TkWidget() :
        width_(0),
        height_(0),
	mono_(0),
	destroyed_(0),
        eventmask_(0),
        callback_pending_(0),
        damage_(0)
{
}

TkWidget::~TkWidget()
{
	/* we need to remove the event handler because we might be
	 * destroying this object and the window from otcl and not
	 * by calling destroy $path... */
	if (tk_)
	    Tk_DeleteEventHandler(tk_, eventmask_, handle, (ClientData) this);
}

void TkWidget::init(const char* path, const char* classname,
		    int reqw, int reqh, u_long extra_events)
{
	Tcl& tcl = Tcl::instance();
	tk_ = Tk_CreateWindowFromPath(tcl.interp(), tcl.tkmain(),
				      (char*)path, 0);
	if (tk_ == 0)
		abort();
	Tk_SetClass(tk_, (char*)classname);
	if (reqw != 0 || reqh != 0)
		Tk_GeometryRequest(tk_, reqw, reqh);
	eventmask_ = extra_events | (ExposureMask|StructureNotifyMask);
	Tk_CreateEventHandler(tk_, eventmask_, handle, (ClientData)this);
	/*
	 * Start with null geometry.  A ConfigureNotify event will
	 * set this right and initiate the resize action.
	 */
	Tk_MakeWindowExist(tk_);

	tcl.eval("winfo depth .");
	mono_ = strcmp(tcl.result(), "1") == 0;
}

Pixmap TkWidget::make_stipple(float level) const
{
	static Pixmap stipple[3];

	int index = int(3. * level);
	if (index > 2)
		index = 2;
	else if (index < 0)
		index = 0;
	Pixmap p = stipple[index];
	if (p == 0) {
		static char bits[3][2] = {
			{ 0x08, 0x02},
			{ 0x05, 0x0a},
			{ 0x0a, 0x0f}
		};
		p = XCreateBitmapFromData(Tk_Display(tk_), Tk_WindowId(tk_),
					  bits[index], 4, 2);
		stipple[index] = p;
	}
	return (p);
}

#if 0
XColor* TkWidget::getcolorbyvalue(const XColor* pColor)
{
         return Tk_GetColorByValue(tk_, pColor);
}
#endif

XColor* TkWidget::getcolor(const char* name, const char* backup) const
{
	Tcl& tcl = Tcl::instance();
	XColor* c = Tk_GetColor(tcl.interp(), tk_, Tk_GetUid((char*)name));
	if (c == 0) {
		fprintf(stderr,
                        "TkWidget: cannot lookup color: %s (trying %s)\n",
			name, backup);
		c = Tk_GetColor(tcl.interp(), tk_, (char*)backup);
		if (c == 0) {
			fprintf(stderr, "TkWidget: cannot lookup color: %s\n",
				backup);
			exit(1);
		}
	}
	return (c);
}

void TkWidget::set_gcv(XGCValues& v, u_long& mask,
		       Font fid, XColor* fc, XColor* bc) const
{
	mask = GCLineWidth|GCGraphicsExposures;
	v.graphics_exposures = 0;
	v.line_width = 1;
	if (fc != 0) {
		v.foreground = fc->pixel;
		mask |= GCForeground;
	}
	if (bc != 0) {
		v.background = bc->pixel;
		mask |= GCBackground;
	}
	if (fid != 0) {
		v.font = fid;
		mask |= GCFont;
	}
	if (mono_ && fc != 0) {
		float level = (float) fc->red + fc->green + fc->blue;
		level /= 3. * 65536.;
		if (level > 0.2 && level < 0.8) {
			mask |= GCStipple|GCFillStyle;
			v.stipple = make_stipple(level);
			v.fill_style = FillStippled;
		}
	}
}

#ifdef WIN32
const char* cszDefaultBG = "SystemButtonFace";
const char* cszDefaultFG = "SystemButtonText";
#else
const char* cszDefaultBG = "white";
const char* cszDefaultFG = "black";
#endif

/* function: gets foreground and background pairs, defaults to either
             black/white or win32 system colors if input is null or null
             string.
 * input:    char* description of color: fg, bg
 * output:   stored in *ppFg and *ppBg
 * special:  if ppFg and/or ppBg is null, the corresponding values
 *           will not be set.
 */
void TkWidget::getforeback(const char* fg, const char* bg,
                           XColor** ppFg, XColor** ppBg) const
{
        if (ppFg) {
                if (fg==0) {
                        *ppFg = 0;
                } else if (fg[0]=='\0') {
                        *ppFg = getcolor(cszDefaultFG, "black");
                } else {
                        *ppFg = getcolor(fg, "black");
                }
        }
        if (ppBg) {
                if (bg==0) {
                        *ppBg = 0;
                } else if (bg[0]=='\0') {
                        *ppBg = getcolor(cszDefaultBG, "white");
                } else {
                        *ppBg = getcolor(bg, "white");
                }
        }
}

GC TkWidget::lookup_gc(Font fid, const char* fg, const char* bg) const
{
	XGCValues v;
	u_long mask;
        XColor *fc, *bc;
	getforeback(fg, bg, &fc, &bc);
	set_gcv(v, mask, fid, fc, bc);
	return (Tk_GetGC(tk_, mask, &v));
}

void TkWidget::resize()
{
}

void TkWidget::handle(const XEvent&)
{
}

void TkWidget::handle(ClientData cd, XEvent* ep)
{
	TkWidget* w = (TkWidget*)cd;

	switch (ep->type) {
	case Expose:
		w->damage_ = 1;
		if (ep->xexpose.count == 0) {
			w->redraw();
                }
		break;

	case DestroyNotify:
		/* This will delete the SiteBox as well.
		   FIXME can handle be called again after this
		   happens?  E.g., do we have to use defereed
		   freeing?  This will be tricky to incorporate
		   with delete. */
		w->destroy();
#ifdef notyet
		if (w->ka_ != 0)
			w->ka_->kill(w);
#endif
		break;

	case MapNotify:
		if (w->damage_)
			w->redraw();
		break;

	case ConfigureNotify:
		if (w->width_ != ep->xconfigure.width ||
		    w->height_ != ep->xconfigure.height) {
			w->width_ = ep->xconfigure.width;
			w->height_ = ep->xconfigure.height;
			w->resize();
			w->damage_ = 1;
			w->redraw();
		}
		break;
        default:
		w->handle(*ep);
                break;

	}
}

void TkWidget::display(ClientData cd)
{
	TkWidget* w = (TkWidget*)cd;
	w->callback_pending_ = 0;
	if (!Tk_IsMapped(w->tk_)) {
		w->damage_ |= 2;
		return;
	}
	if (w->damage_ != 0) {
		w->damage_ = 0;
		w->draw();
	} else
		w->update();
}

void TkWidget::redraw()
{
	if (!callback_pending_) {
		callback_pending_ = 1;
		Tk_DoWhenIdle(display, (ClientData)this);
	}
}

int TkWidget::command(int argc, const char*const* argv)
{
	if (argc == 2) {
		if (strcmp(argv[1], "damage") == 0) {
			/*FIXME needs re-working*/
			redraw();
			return (TCL_OK);
		}
	}
	return (TclObject::command(argc, argv));
}
