/*
 * rtp-record.h --
 *
 *      RTP Recoder header file
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/archive/rtp-record.h,v 1.17 2002/02/03 03:09:26 lim Exp $
 */

#ifndef MASH_RTP_RECORD_H
#define MASH_RTP_RECORD_H

#include "net.h"
#include "rtp.h"
#include "timer.h"
#include "archive/archive-stream.h"
#include "misc/mtrace.h"
#include "archive/rtp-archive.h"
#include "misc/observe.h"


class RTPRecordStream;
class PacketModule;


struct all {
	u_int16_t rh_flags;
	u_int16_t rh_len;
	u_int32_t rh_ssrc;
	u_int32_t ntp_upper;
	u_int32_t ntp_lower;
	u_int32_t sr_ts;
	u_int32_t sr_np;
	u_int32_t sr_nb;
	u_int32_t rr_srcid;
	u_int32_t rr_loss;
	u_int32_t rr_ehsr;
	u_int32_t rr_dv;
	u_int32_t rr_lsr;
	u_int32_t rr_dlsr;
};


/* The 2 RTPRecordRcvr classes pass their data along to the RTPRecordStream */
/* class for writing to disk.  RTCPRecordRcvr receives control packets from */
/* the Session layer and RTPRecordRcvr receives data packets. */


class RTPRecordRcvr : public PacketModule, public Observer {
public:
	RTPRecordRcvr();
	~RTPRecordRcvr();

	virtual void recv(Buffer* p) {
		recv((pktbuf*)p);
	}
	virtual void recv(pktbuf* pb);

	int attach(int argc, const char*const *argv);
	RTPRecordStream *stream() {return stream_;}
private:
	RTPRecordStream *stream_;

};


class RTCPRecordRcvr : public PacketModule, public Observer {
public:
	RTCPRecordRcvr();
	~RTCPRecordRcvr();

	virtual void recv(Buffer* p) {
		recv((pktbuf*)p);
	}
	virtual void recv(pktbuf* pb);

	int attach(int argc, const char*const *argv);
	RTPRecordStream *stream() {return stream_;}
private:
	RTPRecordStream *stream_;

};



class RTPRecordStream : public RecordStream {
public:
	RTPRecordStream();
	~RTPRecordStream();
	int write_headers(int argc, const char * const *argv);
	int attach(int argc, const char*const *argv);
	int cattach(int argc, const char*const *argv);
	int source(int argc, const char*const *argv);
	Bool Record(pktbuf* pb);
	void Record_sdes();
	void Record_sr(rtcp_sr* rh, u_int32_t ssrc, int num);
	void Record_rr(rtcp_rr* rh, int num);
	void parse_rr(rtcp_rr* rr, int num);
	FileHeader *FileHeader_() { return &hdr_;}

	int init_file_header(int argc, const char * const *argv);
	int set_trigger(int argc, const char * const *argv);
	int error_rate(int argc, const char * const *argv);
	int ssrc(int argc, const char * const *argv);
private:
	int WriteHeaders();
	int SeekToStartOfData();

	RTPRecordRcvr *rcvr_;
	RTCPRecordRcvr *crcvr_;
	FileHeader hdr_;
	Bool firstTime_;
	Source *source_;
	RTPprivatehdr privatehdr_;
	u_int32_t bytesWritten_;
	u_int32_t first_rtp_;
	double first_ntp_;
	double error_rate_;
	int sent_pkts_;
	int last_seqno_;
	int lost_pkts_;
	int above_below_;
	int trigger_rate_;
	double lastNotify_;

};


#endif /* MASH_RTP_RECORD_H */
