#
# Copyright 2004 Sun Microsystems, Inc.  All Rights Reserved.
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
#
# This code is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 only, as
# published by the Free Software Foundation.
#
# This code is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# version 2 for more details (a copy is included in the LICENSE file that
# accompanied this code).
#
# You should have received a copy of the GNU General Public License version
# 2 along with this work; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
# CA 95054 USA or visit www.sun.com if you need additional information or
# have any questions.
#

# @test
# @bug 4990825
# @run shell/timeout=60 jstatdPort.sh
# @summary Test functionality of 'jstatd -p <port>&'

. ${TESTSRC-.}/../../jvmstat/testlibrary/utils.sh

setup
verify_os

cleanup() {
  kill_proc ${JSTATD_PID}
}

trap 'cleanup' 0 HUP INT QUIT TERM

JSTATD="${TESTJAVA}/bin/jstatd"
JPS="${TESTJAVA}/bin/jps"
JSTAT="${TESTJAVA}/bin/jstat"

HOSTNAME=`uname -n`
PORT=2099

JSTATD_OUT="jstatd_$$.out"

${JSTATD} -J-Djava.security.policy=${TESTSRC}/all.policy -p ${PORT} 2>&1 > ${JSTATD_OUT} &
JSTATD_PID=$!

echo "jstatd started as pid ${JSTATD_PID} on port ${PORT}"
sleep 3

${JPS} ${HOSTNAME}:${PORT} 2>&1 | awk -f ${TESTSRC}/jpsOutput1.awk

if [ $? -ne 0 ]
then
    echo "Output of jps differs from expected output. Failed."
    exit 1
fi

TARGET_PID=`${JPS} | grep "Jstatd" | cut -d" " -f1`

${JSTAT} -gcutil ${TARGET_PID}@${HOSTNAME}:${PORT} 250 5 2>&1 | awk -f ${TESTSRC}/jstatGcutilOutput1.awk
RC=$?

if [ ${RC} -ne 0 ]
then
    echo "jstat output differs from expected output"
fi

if [ -s ${JSTATD_OUT} ]
then
    echo "jstatd generated the following, unexpected output:"
    RC=1
fi

exit ${RC}
