/*      -*- linux-c -*-
 *
 * (C) Copyright IBM Corp. 2004
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  This
 * file and program are licensed under a BSD style license.  See
 * the Copying file included with the OpenHPI distribution for
 * full licensing terms.
 *
 * Author(s):
 *      Steve Sherman <stevees@us.ibm.com> 
 */

/******************************************************************* 
 * WARNING! This file is auto-magically generated by:
 *          ./SaHpi2code.pl. 
 *          Do not change this file manually. Update script instead
 *******************************************************************/

#include <strings.h>

#include <SaHpi.h>
#include <oh_utils.h>

/**
 * oh_lookup_language:
 * @value: enum value of type SaHpiLanguageT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiLanguageT.
 **/

char * oh_lookup_language(SaHpiLanguageT value)
{
        switch (value) {
        case SAHPI_LANG_UNDEF:
                return "UNDEF";
        case SAHPI_LANG_AFAR:
                return "AFAR";
        case SAHPI_LANG_ABKHAZIAN:
                return "ABKHAZIAN";
        case SAHPI_LANG_AFRIKAANS:
                return "AFRIKAANS";
        case SAHPI_LANG_AMHARIC:
                return "AMHARIC";
        case SAHPI_LANG_ARABIC:
                return "ARABIC";
        case SAHPI_LANG_ASSAMESE:
                return "ASSAMESE";
        case SAHPI_LANG_AYMARA:
                return "AYMARA";
        case SAHPI_LANG_AZERBAIJANI:
                return "AZERBAIJANI";
        case SAHPI_LANG_BASHKIR:
                return "BASHKIR";
        case SAHPI_LANG_BYELORUSSIAN:
                return "BYELORUSSIAN";
        case SAHPI_LANG_BULGARIAN:
                return "BULGARIAN";
        case SAHPI_LANG_BIHARI:
                return "BIHARI";
        case SAHPI_LANG_BISLAMA:
                return "BISLAMA";
        case SAHPI_LANG_BENGALI:
                return "BENGALI";
        case SAHPI_LANG_TIBETAN:
                return "TIBETAN";
        case SAHPI_LANG_BRETON:
                return "BRETON";
        case SAHPI_LANG_CATALAN:
                return "CATALAN";
        case SAHPI_LANG_CORSICAN:
                return "CORSICAN";
        case SAHPI_LANG_CZECH:
                return "CZECH";
        case SAHPI_LANG_WELSH:
                return "WELSH";
        case SAHPI_LANG_DANISH:
                return "DANISH";
        case SAHPI_LANG_GERMAN:
                return "GERMAN";
        case SAHPI_LANG_BHUTANI:
                return "BHUTANI";
        case SAHPI_LANG_GREEK:
                return "GREEK";
        case SAHPI_LANG_ENGLISH:
                return "ENGLISH";
        case SAHPI_LANG_ESPERANTO:
                return "ESPERANTO";
        case SAHPI_LANG_SPANISH:
                return "SPANISH";
        case SAHPI_LANG_ESTONIAN:
                return "ESTONIAN";
        case SAHPI_LANG_BASQUE:
                return "BASQUE";
        case SAHPI_LANG_PERSIAN:
                return "PERSIAN";
        case SAHPI_LANG_FINNISH:
                return "FINNISH";
        case SAHPI_LANG_FIJI:
                return "FIJI";
        case SAHPI_LANG_FAEROESE:
                return "FAEROESE";
        case SAHPI_LANG_FRENCH:
                return "FRENCH";
        case SAHPI_LANG_FRISIAN:
                return "FRISIAN";
        case SAHPI_LANG_IRISH:
                return "IRISH";
        case SAHPI_LANG_SCOTSGAELIC:
                return "SCOTSGAELIC";
        case SAHPI_LANG_GALICIAN:
                return "GALICIAN";
        case SAHPI_LANG_GUARANI:
                return "GUARANI";
        case SAHPI_LANG_GUJARATI:
                return "GUJARATI";
        case SAHPI_LANG_HAUSA:
                return "HAUSA";
        case SAHPI_LANG_HINDI:
                return "HINDI";
        case SAHPI_LANG_CROATIAN:
                return "CROATIAN";
        case SAHPI_LANG_HUNGARIAN:
                return "HUNGARIAN";
        case SAHPI_LANG_ARMENIAN:
                return "ARMENIAN";
        case SAHPI_LANG_INTERLINGUA:
                return "INTERLINGUA";
        case SAHPI_LANG_INTERLINGUE:
                return "INTERLINGUE";
        case SAHPI_LANG_INUPIAK:
                return "INUPIAK";
        case SAHPI_LANG_INDONESIAN:
                return "INDONESIAN";
        case SAHPI_LANG_ICELANDIC:
                return "ICELANDIC";
        case SAHPI_LANG_ITALIAN:
                return "ITALIAN";
        case SAHPI_LANG_HEBREW:
                return "HEBREW";
        case SAHPI_LANG_JAPANESE:
                return "JAPANESE";
        case SAHPI_LANG_YIDDISH:
                return "YIDDISH";
        case SAHPI_LANG_JAVANESE:
                return "JAVANESE";
        case SAHPI_LANG_GEORGIAN:
                return "GEORGIAN";
        case SAHPI_LANG_KAZAKH:
                return "KAZAKH";
        case SAHPI_LANG_GREENLANDIC:
                return "GREENLANDIC";
        case SAHPI_LANG_CAMBODIAN:
                return "CAMBODIAN";
        case SAHPI_LANG_KANNADA:
                return "KANNADA";
        case SAHPI_LANG_KOREAN:
                return "KOREAN";
        case SAHPI_LANG_KASHMIRI:
                return "KASHMIRI";
        case SAHPI_LANG_KURDISH:
                return "KURDISH";
        case SAHPI_LANG_KIRGHIZ:
                return "KIRGHIZ";
        case SAHPI_LANG_LATIN:
                return "LATIN";
        case SAHPI_LANG_LINGALA:
                return "LINGALA";
        case SAHPI_LANG_LAOTHIAN:
                return "LAOTHIAN";
        case SAHPI_LANG_LITHUANIAN:
                return "LITHUANIAN";
        case SAHPI_LANG_LATVIANLETTISH:
                return "LATVIANLETTISH";
        case SAHPI_LANG_MALAGASY:
                return "MALAGASY";
        case SAHPI_LANG_MAORI:
                return "MAORI";
        case SAHPI_LANG_MACEDONIAN:
                return "MACEDONIAN";
        case SAHPI_LANG_MALAYALAM:
                return "MALAYALAM";
        case SAHPI_LANG_MONGOLIAN:
                return "MONGOLIAN";
        case SAHPI_LANG_MOLDAVIAN:
                return "MOLDAVIAN";
        case SAHPI_LANG_MARATHI:
                return "MARATHI";
        case SAHPI_LANG_MALAY:
                return "MALAY";
        case SAHPI_LANG_MALTESE:
                return "MALTESE";
        case SAHPI_LANG_BURMESE:
                return "BURMESE";
        case SAHPI_LANG_NAURU:
                return "NAURU";
        case SAHPI_LANG_NEPALI:
                return "NEPALI";
        case SAHPI_LANG_DUTCH:
                return "DUTCH";
        case SAHPI_LANG_NORWEGIAN:
                return "NORWEGIAN";
        case SAHPI_LANG_OCCITAN:
                return "OCCITAN";
        case SAHPI_LANG_AFANOROMO:
                return "AFANOROMO";
        case SAHPI_LANG_ORIYA:
                return "ORIYA";
        case SAHPI_LANG_PUNJABI:
                return "PUNJABI";
        case SAHPI_LANG_POLISH:
                return "POLISH";
        case SAHPI_LANG_PASHTOPUSHTO:
                return "PASHTOPUSHTO";
        case SAHPI_LANG_PORTUGUESE:
                return "PORTUGUESE";
        case SAHPI_LANG_QUECHUA:
                return "QUECHUA";
        case SAHPI_LANG_RHAETOROMANCE:
                return "RHAETOROMANCE";
        case SAHPI_LANG_KIRUNDI:
                return "KIRUNDI";
        case SAHPI_LANG_ROMANIAN:
                return "ROMANIAN";
        case SAHPI_LANG_RUSSIAN:
                return "RUSSIAN";
        case SAHPI_LANG_KINYARWANDA:
                return "KINYARWANDA";
        case SAHPI_LANG_SANSKRIT:
                return "SANSKRIT";
        case SAHPI_LANG_SINDHI:
                return "SINDHI";
        case SAHPI_LANG_SANGRO:
                return "SANGRO";
        case SAHPI_LANG_SERBOCROATIAN:
                return "SERBOCROATIAN";
        case SAHPI_LANG_SINGHALESE:
                return "SINGHALESE";
        case SAHPI_LANG_SLOVAK:
                return "SLOVAK";
        case SAHPI_LANG_SLOVENIAN:
                return "SLOVENIAN";
        case SAHPI_LANG_SAMOAN:
                return "SAMOAN";
        case SAHPI_LANG_SHONA:
                return "SHONA";
        case SAHPI_LANG_SOMALI:
                return "SOMALI";
        case SAHPI_LANG_ALBANIAN:
                return "ALBANIAN";
        case SAHPI_LANG_SERBIAN:
                return "SERBIAN";
        case SAHPI_LANG_SISWATI:
                return "SISWATI";
        case SAHPI_LANG_SESOTHO:
                return "SESOTHO";
        case SAHPI_LANG_SUDANESE:
                return "SUDANESE";
        case SAHPI_LANG_SWEDISH:
                return "SWEDISH";
        case SAHPI_LANG_SWAHILI:
                return "SWAHILI";
        case SAHPI_LANG_TAMIL:
                return "TAMIL";
        case SAHPI_LANG_TELUGU:
                return "TELUGU";
        case SAHPI_LANG_TAJIK:
                return "TAJIK";
        case SAHPI_LANG_THAI:
                return "THAI";
        case SAHPI_LANG_TIGRINYA:
                return "TIGRINYA";
        case SAHPI_LANG_TURKMEN:
                return "TURKMEN";
        case SAHPI_LANG_TAGALOG:
                return "TAGALOG";
        case SAHPI_LANG_SETSWANA:
                return "SETSWANA";
        case SAHPI_LANG_TONGA:
                return "TONGA";
        case SAHPI_LANG_TURKISH:
                return "TURKISH";
        case SAHPI_LANG_TSONGA:
                return "TSONGA";
        case SAHPI_LANG_TATAR:
                return "TATAR";
        case SAHPI_LANG_TWI:
                return "TWI";
        case SAHPI_LANG_UKRAINIAN:
                return "UKRAINIAN";
        case SAHPI_LANG_URDU:
                return "URDU";
        case SAHPI_LANG_UZBEK:
                return "UZBEK";
        case SAHPI_LANG_VIETNAMESE:
                return "VIETNAMESE";
        case SAHPI_LANG_VOLAPUK:
                return "VOLAPUK";
        case SAHPI_LANG_WOLOF:
                return "WOLOF";
        case SAHPI_LANG_XHOSA:
                return "XHOSA";
        case SAHPI_LANG_YORUBA:
                return "YORUBA";
        case SAHPI_LANG_CHINESE:
                return "CHINESE";
        case SAHPI_LANG_ZULU:
                return "ZULU";
        default:
                return NULL;
        }
}

struct oh_language_map language_strings[] = {
       {SAHPI_LANG_UNDEF, "UNDEF"},
       {SAHPI_LANG_AFAR, "AFAR"},
       {SAHPI_LANG_ABKHAZIAN, "ABKHAZIAN"},
       {SAHPI_LANG_AFRIKAANS, "AFRIKAANS"},
       {SAHPI_LANG_AMHARIC, "AMHARIC"},
       {SAHPI_LANG_ARABIC, "ARABIC"},
       {SAHPI_LANG_ASSAMESE, "ASSAMESE"},
       {SAHPI_LANG_AYMARA, "AYMARA"},
       {SAHPI_LANG_AZERBAIJANI, "AZERBAIJANI"},
       {SAHPI_LANG_BASHKIR, "BASHKIR"},
       {SAHPI_LANG_BYELORUSSIAN, "BYELORUSSIAN"},
       {SAHPI_LANG_BULGARIAN, "BULGARIAN"},
       {SAHPI_LANG_BIHARI, "BIHARI"},
       {SAHPI_LANG_BISLAMA, "BISLAMA"},
       {SAHPI_LANG_BENGALI, "BENGALI"},
       {SAHPI_LANG_TIBETAN, "TIBETAN"},
       {SAHPI_LANG_BRETON, "BRETON"},
       {SAHPI_LANG_CATALAN, "CATALAN"},
       {SAHPI_LANG_CORSICAN, "CORSICAN"},
       {SAHPI_LANG_CZECH, "CZECH"},
       {SAHPI_LANG_WELSH, "WELSH"},
       {SAHPI_LANG_DANISH, "DANISH"},
       {SAHPI_LANG_GERMAN, "GERMAN"},
       {SAHPI_LANG_BHUTANI, "BHUTANI"},
       {SAHPI_LANG_GREEK, "GREEK"},
       {SAHPI_LANG_ENGLISH, "ENGLISH"},
       {SAHPI_LANG_ESPERANTO, "ESPERANTO"},
       {SAHPI_LANG_SPANISH, "SPANISH"},
       {SAHPI_LANG_ESTONIAN, "ESTONIAN"},
       {SAHPI_LANG_BASQUE, "BASQUE"},
       {SAHPI_LANG_PERSIAN, "PERSIAN"},
       {SAHPI_LANG_FINNISH, "FINNISH"},
       {SAHPI_LANG_FIJI, "FIJI"},
       {SAHPI_LANG_FAEROESE, "FAEROESE"},
       {SAHPI_LANG_FRENCH, "FRENCH"},
       {SAHPI_LANG_FRISIAN, "FRISIAN"},
       {SAHPI_LANG_IRISH, "IRISH"},
       {SAHPI_LANG_SCOTSGAELIC, "SCOTSGAELIC"},
       {SAHPI_LANG_GALICIAN, "GALICIAN"},
       {SAHPI_LANG_GUARANI, "GUARANI"},
       {SAHPI_LANG_GUJARATI, "GUJARATI"},
       {SAHPI_LANG_HAUSA, "HAUSA"},
       {SAHPI_LANG_HINDI, "HINDI"},
       {SAHPI_LANG_CROATIAN, "CROATIAN"},
       {SAHPI_LANG_HUNGARIAN, "HUNGARIAN"},
       {SAHPI_LANG_ARMENIAN, "ARMENIAN"},
       {SAHPI_LANG_INTERLINGUA, "INTERLINGUA"},
       {SAHPI_LANG_INTERLINGUE, "INTERLINGUE"},
       {SAHPI_LANG_INUPIAK, "INUPIAK"},
       {SAHPI_LANG_INDONESIAN, "INDONESIAN"},
       {SAHPI_LANG_ICELANDIC, "ICELANDIC"},
       {SAHPI_LANG_ITALIAN, "ITALIAN"},
       {SAHPI_LANG_HEBREW, "HEBREW"},
       {SAHPI_LANG_JAPANESE, "JAPANESE"},
       {SAHPI_LANG_YIDDISH, "YIDDISH"},
       {SAHPI_LANG_JAVANESE, "JAVANESE"},
       {SAHPI_LANG_GEORGIAN, "GEORGIAN"},
       {SAHPI_LANG_KAZAKH, "KAZAKH"},
       {SAHPI_LANG_GREENLANDIC, "GREENLANDIC"},
       {SAHPI_LANG_CAMBODIAN, "CAMBODIAN"},
       {SAHPI_LANG_KANNADA, "KANNADA"},
       {SAHPI_LANG_KOREAN, "KOREAN"},
       {SAHPI_LANG_KASHMIRI, "KASHMIRI"},
       {SAHPI_LANG_KURDISH, "KURDISH"},
       {SAHPI_LANG_KIRGHIZ, "KIRGHIZ"},
       {SAHPI_LANG_LATIN, "LATIN"},
       {SAHPI_LANG_LINGALA, "LINGALA"},
       {SAHPI_LANG_LAOTHIAN, "LAOTHIAN"},
       {SAHPI_LANG_LITHUANIAN, "LITHUANIAN"},
       {SAHPI_LANG_LATVIANLETTISH, "LATVIANLETTISH"},
       {SAHPI_LANG_MALAGASY, "MALAGASY"},
       {SAHPI_LANG_MAORI, "MAORI"},
       {SAHPI_LANG_MACEDONIAN, "MACEDONIAN"},
       {SAHPI_LANG_MALAYALAM, "MALAYALAM"},
       {SAHPI_LANG_MONGOLIAN, "MONGOLIAN"},
       {SAHPI_LANG_MOLDAVIAN, "MOLDAVIAN"},
       {SAHPI_LANG_MARATHI, "MARATHI"},
       {SAHPI_LANG_MALAY, "MALAY"},
       {SAHPI_LANG_MALTESE, "MALTESE"},
       {SAHPI_LANG_BURMESE, "BURMESE"},
       {SAHPI_LANG_NAURU, "NAURU"},
       {SAHPI_LANG_NEPALI, "NEPALI"},
       {SAHPI_LANG_DUTCH, "DUTCH"},
       {SAHPI_LANG_NORWEGIAN, "NORWEGIAN"},
       {SAHPI_LANG_OCCITAN, "OCCITAN"},
       {SAHPI_LANG_AFANOROMO, "AFANOROMO"},
       {SAHPI_LANG_ORIYA, "ORIYA"},
       {SAHPI_LANG_PUNJABI, "PUNJABI"},
       {SAHPI_LANG_POLISH, "POLISH"},
       {SAHPI_LANG_PASHTOPUSHTO, "PASHTOPUSHTO"},
       {SAHPI_LANG_PORTUGUESE, "PORTUGUESE"},
       {SAHPI_LANG_QUECHUA, "QUECHUA"},
       {SAHPI_LANG_RHAETOROMANCE, "RHAETOROMANCE"},
       {SAHPI_LANG_KIRUNDI, "KIRUNDI"},
       {SAHPI_LANG_ROMANIAN, "ROMANIAN"},
       {SAHPI_LANG_RUSSIAN, "RUSSIAN"},
       {SAHPI_LANG_KINYARWANDA, "KINYARWANDA"},
       {SAHPI_LANG_SANSKRIT, "SANSKRIT"},
       {SAHPI_LANG_SINDHI, "SINDHI"},
       {SAHPI_LANG_SANGRO, "SANGRO"},
       {SAHPI_LANG_SERBOCROATIAN, "SERBOCROATIAN"},
       {SAHPI_LANG_SINGHALESE, "SINGHALESE"},
       {SAHPI_LANG_SLOVAK, "SLOVAK"},
       {SAHPI_LANG_SLOVENIAN, "SLOVENIAN"},
       {SAHPI_LANG_SAMOAN, "SAMOAN"},
       {SAHPI_LANG_SHONA, "SHONA"},
       {SAHPI_LANG_SOMALI, "SOMALI"},
       {SAHPI_LANG_ALBANIAN, "ALBANIAN"},
       {SAHPI_LANG_SERBIAN, "SERBIAN"},
       {SAHPI_LANG_SISWATI, "SISWATI"},
       {SAHPI_LANG_SESOTHO, "SESOTHO"},
       {SAHPI_LANG_SUDANESE, "SUDANESE"},
       {SAHPI_LANG_SWEDISH, "SWEDISH"},
       {SAHPI_LANG_SWAHILI, "SWAHILI"},
       {SAHPI_LANG_TAMIL, "TAMIL"},
       {SAHPI_LANG_TELUGU, "TELUGU"},
       {SAHPI_LANG_TAJIK, "TAJIK"},
       {SAHPI_LANG_THAI, "THAI"},
       {SAHPI_LANG_TIGRINYA, "TIGRINYA"},
       {SAHPI_LANG_TURKMEN, "TURKMEN"},
       {SAHPI_LANG_TAGALOG, "TAGALOG"},
       {SAHPI_LANG_SETSWANA, "SETSWANA"},
       {SAHPI_LANG_TONGA, "TONGA"},
       {SAHPI_LANG_TURKISH, "TURKISH"},
       {SAHPI_LANG_TSONGA, "TSONGA"},
       {SAHPI_LANG_TATAR, "TATAR"},
       {SAHPI_LANG_TWI, "TWI"},
       {SAHPI_LANG_UKRAINIAN, "UKRAINIAN"},
       {SAHPI_LANG_URDU, "URDU"},
       {SAHPI_LANG_UZBEK, "UZBEK"},
       {SAHPI_LANG_VIETNAMESE, "VIETNAMESE"},
       {SAHPI_LANG_VOLAPUK, "VOLAPUK"},
       {SAHPI_LANG_WOLOF, "WOLOF"},
       {SAHPI_LANG_XHOSA, "XHOSA"},
       {SAHPI_LANG_YORUBA, "YORUBA"},
       {SAHPI_LANG_CHINESE, "CHINESE"},
       {SAHPI_LANG_ZULU, "ZULU"},
};

/**
 * oh_encode_language:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiLanguageT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_language(), back 
 * into an SaHpiLanguageT type. 
 *
 * Returns:
 * SaHpiLanguageT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_language(SaHpiTextBufferT *buffer, SaHpiLanguageT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_LANGUAGE; i++) {
		if (strcasecmp((char *)buffer->Data, language_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = language_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_texttype:
 * @value: enum value of type SaHpiTextTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiTextTypeT.
 **/

char * oh_lookup_texttype(SaHpiTextTypeT value)
{
        switch (value) {
        case SAHPI_TL_TYPE_UNICODE:
                return "UNICODE";
        case SAHPI_TL_TYPE_BCDPLUS:
                return "BCDPLUS";
        case SAHPI_TL_TYPE_ASCII6:
                return "ASCII6";
        case SAHPI_TL_TYPE_TEXT:
                return "TEXT";
        case SAHPI_TL_TYPE_BINARY:
                return "BINARY";
        default:
                return NULL;
        }
}

struct oh_texttype_map texttype_strings[] = {
       {SAHPI_TL_TYPE_UNICODE, "UNICODE"},
       {SAHPI_TL_TYPE_BCDPLUS, "BCDPLUS"},
       {SAHPI_TL_TYPE_ASCII6, "ASCII6"},
       {SAHPI_TL_TYPE_TEXT, "TEXT"},
       {SAHPI_TL_TYPE_BINARY, "BINARY"},
};

/**
 * oh_encode_texttype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiTextTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_texttype(), back 
 * into an SaHpiTextTypeT type. 
 *
 * Returns:
 * SaHpiTextTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_texttype(SaHpiTextBufferT *buffer, SaHpiTextTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_TEXTTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, texttype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = texttype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_entitytype:
 * @value: enum value of type SaHpiEntityTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiEntityTypeT.
 **/

char * oh_lookup_entitytype(SaHpiEntityTypeT value)
{
        switch (value) {
        case SAHPI_ENT_UNSPECIFIED:
                return "UNSPECIFIED";
        case SAHPI_ENT_OTHER:
                return "OTHER";
        case SAHPI_ENT_UNKNOWN:
                return "UNKNOWN";
        case SAHPI_ENT_PROCESSOR:
                return "PROCESSOR";
        case SAHPI_ENT_DISK_BAY:
                return "DISK_BAY";
        case SAHPI_ENT_PERIPHERAL_BAY:
                return "PERIPHERAL_BAY";
        case SAHPI_ENT_SYS_MGMNT_MODULE:
                return "SYS_MGMNT_MODULE";
        case SAHPI_ENT_SYSTEM_BOARD:
                return "SYSTEM_BOARD";
        case SAHPI_ENT_MEMORY_MODULE:
                return "MEMORY_MODULE";
        case SAHPI_ENT_PROCESSOR_MODULE:
                return "PROCESSOR_MODULE";
        case SAHPI_ENT_POWER_SUPPLY:
                return "POWER_SUPPLY";
        case SAHPI_ENT_ADD_IN_CARD:
                return "ADD_IN_CARD";
        case SAHPI_ENT_FRONT_PANEL_BOARD:
                return "FRONT_PANEL_BOARD";
        case SAHPI_ENT_BACK_PANEL_BOARD:
                return "BACK_PANEL_BOARD";
        case SAHPI_ENT_POWER_SYSTEM_BOARD:
                return "POWER_SYSTEM_BOARD";
        case SAHPI_ENT_DRIVE_BACKPLANE:
                return "DRIVE_BACKPLANE";
        case SAHPI_ENT_SYS_EXPANSION_BOARD:
                return "SYS_EXPANSION_BOARD";
        case SAHPI_ENT_OTHER_SYSTEM_BOARD:
                return "OTHER_SYSTEM_BOARD";
        case SAHPI_ENT_PROCESSOR_BOARD:
                return "PROCESSOR_BOARD";
        case SAHPI_ENT_POWER_UNIT:
                return "POWER_UNIT";
        case SAHPI_ENT_POWER_MODULE:
                return "POWER_MODULE";
        case SAHPI_ENT_POWER_MGMNT:
                return "POWER_MGMNT";
        case SAHPI_ENT_CHASSIS_BACK_PANEL_BOARD:
                return "CHASSIS_BACK_PANEL_BOARD";
        case SAHPI_ENT_SYSTEM_CHASSIS:
                return "SYSTEM_CHASSIS";
        case SAHPI_ENT_SUB_CHASSIS:
                return "SUB_CHASSIS";
        case SAHPI_ENT_OTHER_CHASSIS_BOARD:
                return "OTHER_CHASSIS_BOARD";
        case SAHPI_ENT_DISK_DRIVE_BAY:
                return "DISK_DRIVE_BAY";
        case SAHPI_ENT_PERIPHERAL_BAY_2:
                return "PERIPHERAL_BAY_2";
        case SAHPI_ENT_DEVICE_BAY:
                return "DEVICE_BAY";
        case SAHPI_ENT_COOLING_DEVICE:
                return "COOLING_DEVICE";
        case SAHPI_ENT_COOLING_UNIT:
                return "COOLING_UNIT";
        case SAHPI_ENT_INTERCONNECT:
                return "INTERCONNECT";
        case SAHPI_ENT_MEMORY_DEVICE:
                return "MEMORY_DEVICE";
        case SAHPI_ENT_SYS_MGMNT_SOFTWARE:
                return "SYS_MGMNT_SOFTWARE";
        case SAHPI_ENT_BIOS:
                return "BIOS";
        case SAHPI_ENT_OPERATING_SYSTEM:
                return "OPERATING_SYSTEM";
        case SAHPI_ENT_SYSTEM_BUS:
                return "SYSTEM_BUS";
        case SAHPI_ENT_GROUP:
                return "GROUP";
        case SAHPI_ENT_REMOTE:
                return "REMOTE";
        case SAHPI_ENT_EXTERNAL_ENVIRONMENT:
                return "EXTERNAL_ENVIRONMENT";
        case SAHPI_ENT_BATTERY:
                return "BATTERY";
        case SAHPI_ENT_CHASSIS_SPECIFIC:
                return "CHASSIS_SPECIFIC";
        case SAHPI_ENT_BOARD_SET_SPECIFIC:
                return "BOARD_SET_SPECIFIC";
        case SAHPI_ENT_OEM_SYSINT_SPECIFIC:
                return "OEM_SYSINT_SPECIFIC";
        case SAHPI_ENT_ROOT:
                return "ROOT";
        case SAHPI_ENT_RACK:
                return "RACK";
        case SAHPI_ENT_SUBRACK:
                return "SUBRACK";
        case SAHPI_ENT_COMPACTPCI_CHASSIS:
                return "COMPACTPCI_CHASSIS";
        case SAHPI_ENT_ADVANCEDTCA_CHASSIS:
                return "ADVANCEDTCA_CHASSIS";
        case SAHPI_ENT_RACK_MOUNTED_SERVER:
                return "RACK_MOUNTED_SERVER";
        case SAHPI_ENT_SYSTEM_BLADE:
                return "SYSTEM_BLADE";
        case SAHPI_ENT_SWITCH:
                return "SWITCH";
        case SAHPI_ENT_SWITCH_BLADE:
                return "SWITCH_BLADE";
        case SAHPI_ENT_SBC_BLADE:
                return "SBC_BLADE";
        case SAHPI_ENT_IO_BLADE:
                return "IO_BLADE";
        case SAHPI_ENT_DISK_BLADE:
                return "DISK_BLADE";
        case SAHPI_ENT_DISK_DRIVE:
                return "DISK_DRIVE";
        case SAHPI_ENT_FAN:
                return "FAN";
        case SAHPI_ENT_POWER_DISTRIBUTION_UNIT:
                return "POWER_DISTRIBUTION_UNIT";
        case SAHPI_ENT_SPEC_PROC_BLADE:
                return "SPEC_PROC_BLADE";
        case SAHPI_ENT_IO_SUBBOARD:
                return "IO_SUBBOARD";
        case SAHPI_ENT_SBC_SUBBOARD:
                return "SBC_SUBBOARD";
        case SAHPI_ENT_ALARM_MANAGER:
                return "ALARM_MANAGER";
        case SAHPI_ENT_SHELF_MANAGER:
                return "SHELF_MANAGER";
        case SAHPI_ENT_DISPLAY_PANEL:
                return "DISPLAY_PANEL";
        case SAHPI_ENT_SUBBOARD_CARRIER_BLADE:
                return "SUBBOARD_CARRIER_BLADE";
        case SAHPI_ENT_PHYSICAL_SLOT:
                return "PHYSICAL_SLOT";
        default:
                return oh_lookup_atcahpientitytype(value);
        }
}

struct oh_entitytype_map entitytype_strings[] = {
       {SAHPI_ENT_UNSPECIFIED, "UNSPECIFIED"},
       {SAHPI_ENT_OTHER, "OTHER"},
       {SAHPI_ENT_UNKNOWN, "UNKNOWN"},
       {SAHPI_ENT_PROCESSOR, "PROCESSOR"},
       {SAHPI_ENT_DISK_BAY, "DISK_BAY"},
       {SAHPI_ENT_PERIPHERAL_BAY, "PERIPHERAL_BAY"},
       {SAHPI_ENT_SYS_MGMNT_MODULE, "SYS_MGMNT_MODULE"},
       {SAHPI_ENT_SYSTEM_BOARD, "SYSTEM_BOARD"},
       {SAHPI_ENT_MEMORY_MODULE, "MEMORY_MODULE"},
       {SAHPI_ENT_PROCESSOR_MODULE, "PROCESSOR_MODULE"},
       {SAHPI_ENT_POWER_SUPPLY, "POWER_SUPPLY"},
       {SAHPI_ENT_ADD_IN_CARD, "ADD_IN_CARD"},
       {SAHPI_ENT_FRONT_PANEL_BOARD, "FRONT_PANEL_BOARD"},
       {SAHPI_ENT_BACK_PANEL_BOARD, "BACK_PANEL_BOARD"},
       {SAHPI_ENT_POWER_SYSTEM_BOARD, "POWER_SYSTEM_BOARD"},
       {SAHPI_ENT_DRIVE_BACKPLANE, "DRIVE_BACKPLANE"},
       {SAHPI_ENT_SYS_EXPANSION_BOARD, "SYS_EXPANSION_BOARD"},
       {SAHPI_ENT_OTHER_SYSTEM_BOARD, "OTHER_SYSTEM_BOARD"},
       {SAHPI_ENT_PROCESSOR_BOARD, "PROCESSOR_BOARD"},
       {SAHPI_ENT_POWER_UNIT, "POWER_UNIT"},
       {SAHPI_ENT_POWER_MODULE, "POWER_MODULE"},
       {SAHPI_ENT_POWER_MGMNT, "POWER_MGMNT"},
       {SAHPI_ENT_CHASSIS_BACK_PANEL_BOARD, "CHASSIS_BACK_PANEL_BOARD"},
       {SAHPI_ENT_SYSTEM_CHASSIS, "SYSTEM_CHASSIS"},
       {SAHPI_ENT_SUB_CHASSIS, "SUB_CHASSIS"},
       {SAHPI_ENT_OTHER_CHASSIS_BOARD, "OTHER_CHASSIS_BOARD"},
       {SAHPI_ENT_DISK_DRIVE_BAY, "DISK_DRIVE_BAY"},
       {SAHPI_ENT_PERIPHERAL_BAY_2, "PERIPHERAL_BAY_2"},
       {SAHPI_ENT_DEVICE_BAY, "DEVICE_BAY"},
       {SAHPI_ENT_COOLING_DEVICE, "COOLING_DEVICE"},
       {SAHPI_ENT_COOLING_UNIT, "COOLING_UNIT"},
       {SAHPI_ENT_INTERCONNECT, "INTERCONNECT"},
       {SAHPI_ENT_MEMORY_DEVICE, "MEMORY_DEVICE"},
       {SAHPI_ENT_SYS_MGMNT_SOFTWARE, "SYS_MGMNT_SOFTWARE"},
       {SAHPI_ENT_BIOS, "BIOS"},
       {SAHPI_ENT_OPERATING_SYSTEM, "OPERATING_SYSTEM"},
       {SAHPI_ENT_SYSTEM_BUS, "SYSTEM_BUS"},
       {SAHPI_ENT_GROUP, "GROUP"},
       {SAHPI_ENT_REMOTE, "REMOTE"},
       {SAHPI_ENT_EXTERNAL_ENVIRONMENT, "EXTERNAL_ENVIRONMENT"},
       {SAHPI_ENT_BATTERY, "BATTERY"},
       {SAHPI_ENT_CHASSIS_SPECIFIC, "CHASSIS_SPECIFIC"},
       {SAHPI_ENT_BOARD_SET_SPECIFIC, "BOARD_SET_SPECIFIC"},
       {SAHPI_ENT_OEM_SYSINT_SPECIFIC, "OEM_SYSINT_SPECIFIC"},
       {SAHPI_ENT_ROOT, "ROOT"},
       {SAHPI_ENT_RACK, "RACK"},
       {SAHPI_ENT_SUBRACK, "SUBRACK"},
       {SAHPI_ENT_COMPACTPCI_CHASSIS, "COMPACTPCI_CHASSIS"},
       {SAHPI_ENT_ADVANCEDTCA_CHASSIS, "ADVANCEDTCA_CHASSIS"},
       {SAHPI_ENT_RACK_MOUNTED_SERVER, "RACK_MOUNTED_SERVER"},
       {SAHPI_ENT_SYSTEM_BLADE, "SYSTEM_BLADE"},
       {SAHPI_ENT_SWITCH, "SWITCH"},
       {SAHPI_ENT_SWITCH_BLADE, "SWITCH_BLADE"},
       {SAHPI_ENT_SBC_BLADE, "SBC_BLADE"},
       {SAHPI_ENT_IO_BLADE, "IO_BLADE"},
       {SAHPI_ENT_DISK_BLADE, "DISK_BLADE"},
       {SAHPI_ENT_DISK_DRIVE, "DISK_DRIVE"},
       {SAHPI_ENT_FAN, "FAN"},
       {SAHPI_ENT_POWER_DISTRIBUTION_UNIT, "POWER_DISTRIBUTION_UNIT"},
       {SAHPI_ENT_SPEC_PROC_BLADE, "SPEC_PROC_BLADE"},
       {SAHPI_ENT_IO_SUBBOARD, "IO_SUBBOARD"},
       {SAHPI_ENT_SBC_SUBBOARD, "SBC_SUBBOARD"},
       {SAHPI_ENT_ALARM_MANAGER, "ALARM_MANAGER"},
       {SAHPI_ENT_SHELF_MANAGER, "SHELF_MANAGER"},
       {SAHPI_ENT_DISPLAY_PANEL, "DISPLAY_PANEL"},
       {SAHPI_ENT_SUBBOARD_CARRIER_BLADE, "SUBBOARD_CARRIER_BLADE"},
       {SAHPI_ENT_PHYSICAL_SLOT, "PHYSICAL_SLOT"},
};

/**
 * oh_encode_entitytype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiEntityTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_entitytype(), back 
 * into an SaHpiEntityTypeT type. 
 *
 * Returns:
 * SaHpiEntityTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_entitytype(SaHpiTextBufferT *buffer, SaHpiEntityTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_ENTITYTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, entitytype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = entitytype_strings[i].entity_type;
	}
	else {
		return(oh_encode_atcahpientitytype(buffer, type));
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_sensortype:
 * @value: enum value of type SaHpiSensorTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiSensorTypeT.
 **/

char * oh_lookup_sensortype(SaHpiSensorTypeT value)
{
        switch (value) {
        case SAHPI_TEMPERATURE:
                return "TEMPERATURE";
        case SAHPI_VOLTAGE:
                return "VOLTAGE";
        case SAHPI_CURRENT:
                return "CURRENT";
        case SAHPI_FAN:
                return "FAN";
        case SAHPI_PHYSICAL_SECURITY:
                return "PHYSICAL_SECURITY";
        case SAHPI_PLATFORM_VIOLATION:
                return "PLATFORM_VIOLATION";
        case SAHPI_PROCESSOR:
                return "PROCESSOR";
        case SAHPI_POWER_SUPPLY:
                return "POWER_SUPPLY";
        case SAHPI_POWER_UNIT:
                return "POWER_UNIT";
        case SAHPI_COOLING_DEVICE:
                return "COOLING_DEVICE";
        case SAHPI_OTHER_UNITS_BASED_SENSOR:
                return "OTHER_UNITS_BASED_SENSOR";
        case SAHPI_MEMORY:
                return "MEMORY";
        case SAHPI_DRIVE_SLOT:
                return "DRIVE_SLOT";
        case SAHPI_POST_MEMORY_RESIZE:
                return "POST_MEMORY_RESIZE";
        case SAHPI_SYSTEM_FW_PROGRESS:
                return "SYSTEM_FW_PROGRESS";
        case SAHPI_EVENT_LOGGING_DISABLED:
                return "EVENT_LOGGING_DISABLED";
        case SAHPI_RESERVED1:
                return "RESERVED1";
        case SAHPI_SYSTEM_EVENT:
                return "SYSTEM_EVENT";
        case SAHPI_CRITICAL_INTERRUPT:
                return "CRITICAL_INTERRUPT";
        case SAHPI_BUTTON:
                return "BUTTON";
        case SAHPI_MODULE_BOARD:
                return "MODULE_BOARD";
        case SAHPI_MICROCONTROLLER_COPROCESSOR:
                return "MICROCONTROLLER_COPROCESSOR";
        case SAHPI_ADDIN_CARD:
                return "ADDIN_CARD";
        case SAHPI_CHASSIS:
                return "CHASSIS";
        case SAHPI_CHIP_SET:
                return "CHIP_SET";
        case SAHPI_OTHER_FRU:
                return "OTHER_FRU";
        case SAHPI_CABLE_INTERCONNECT:
                return "CABLE_INTERCONNECT";
        case SAHPI_TERMINATOR:
                return "TERMINATOR";
        case SAHPI_SYSTEM_BOOT_INITIATED:
                return "SYSTEM_BOOT_INITIATED";
        case SAHPI_BOOT_ERROR:
                return "BOOT_ERROR";
        case SAHPI_OS_BOOT:
                return "OS_BOOT";
        case SAHPI_OS_CRITICAL_STOP:
                return "OS_CRITICAL_STOP";
        case SAHPI_SLOT_CONNECTOR:
                return "SLOT_CONNECTOR";
        case SAHPI_SYSTEM_ACPI_POWER_STATE:
                return "SYSTEM_ACPI_POWER_STATE";
        case SAHPI_RESERVED2:
                return "RESERVED2";
        case SAHPI_PLATFORM_ALERT:
                return "PLATFORM_ALERT";
        case SAHPI_ENTITY_PRESENCE:
                return "ENTITY_PRESENCE";
        case SAHPI_MONITOR_ASIC_IC:
                return "MONITOR_ASIC_IC";
        case SAHPI_LAN:
                return "LAN";
        case SAHPI_MANAGEMENT_SUBSYSTEM_HEALTH:
                return "MANAGEMENT_SUBSYSTEM_HEALTH";
        case SAHPI_BATTERY:
                return "BATTERY";
        case SAHPI_OPERATIONAL:
                return "OPERATIONAL";
        case SAHPI_OEM_SENSOR:
                return "OEM_SENSOR";
        default:
                return NULL;
        }
}

struct oh_sensortype_map sensortype_strings[] = {
       {SAHPI_TEMPERATURE, "TEMPERATURE"},
       {SAHPI_VOLTAGE, "VOLTAGE"},
       {SAHPI_CURRENT, "CURRENT"},
       {SAHPI_FAN, "FAN"},
       {SAHPI_PHYSICAL_SECURITY, "PHYSICAL_SECURITY"},
       {SAHPI_PLATFORM_VIOLATION, "PLATFORM_VIOLATION"},
       {SAHPI_PROCESSOR, "PROCESSOR"},
       {SAHPI_POWER_SUPPLY, "POWER_SUPPLY"},
       {SAHPI_POWER_UNIT, "POWER_UNIT"},
       {SAHPI_COOLING_DEVICE, "COOLING_DEVICE"},
       {SAHPI_OTHER_UNITS_BASED_SENSOR, "OTHER_UNITS_BASED_SENSOR"},
       {SAHPI_MEMORY, "MEMORY"},
       {SAHPI_DRIVE_SLOT, "DRIVE_SLOT"},
       {SAHPI_POST_MEMORY_RESIZE, "POST_MEMORY_RESIZE"},
       {SAHPI_SYSTEM_FW_PROGRESS, "SYSTEM_FW_PROGRESS"},
       {SAHPI_EVENT_LOGGING_DISABLED, "EVENT_LOGGING_DISABLED"},
       {SAHPI_RESERVED1, "RESERVED1"},
       {SAHPI_SYSTEM_EVENT, "SYSTEM_EVENT"},
       {SAHPI_CRITICAL_INTERRUPT, "CRITICAL_INTERRUPT"},
       {SAHPI_BUTTON, "BUTTON"},
       {SAHPI_MODULE_BOARD, "MODULE_BOARD"},
       {SAHPI_MICROCONTROLLER_COPROCESSOR, "MICROCONTROLLER_COPROCESSOR"},
       {SAHPI_ADDIN_CARD, "ADDIN_CARD"},
       {SAHPI_CHASSIS, "CHASSIS"},
       {SAHPI_CHIP_SET, "CHIP_SET"},
       {SAHPI_OTHER_FRU, "OTHER_FRU"},
       {SAHPI_CABLE_INTERCONNECT, "CABLE_INTERCONNECT"},
       {SAHPI_TERMINATOR, "TERMINATOR"},
       {SAHPI_SYSTEM_BOOT_INITIATED, "SYSTEM_BOOT_INITIATED"},
       {SAHPI_BOOT_ERROR, "BOOT_ERROR"},
       {SAHPI_OS_BOOT, "OS_BOOT"},
       {SAHPI_OS_CRITICAL_STOP, "OS_CRITICAL_STOP"},
       {SAHPI_SLOT_CONNECTOR, "SLOT_CONNECTOR"},
       {SAHPI_SYSTEM_ACPI_POWER_STATE, "SYSTEM_ACPI_POWER_STATE"},
       {SAHPI_RESERVED2, "RESERVED2"},
       {SAHPI_PLATFORM_ALERT, "PLATFORM_ALERT"},
       {SAHPI_ENTITY_PRESENCE, "ENTITY_PRESENCE"},
       {SAHPI_MONITOR_ASIC_IC, "MONITOR_ASIC_IC"},
       {SAHPI_LAN, "LAN"},
       {SAHPI_MANAGEMENT_SUBSYSTEM_HEALTH, "MANAGEMENT_SUBSYSTEM_HEALTH"},
       {SAHPI_BATTERY, "BATTERY"},
       {SAHPI_OPERATIONAL, "OPERATIONAL"},
       {SAHPI_OEM_SENSOR, "OEM_SENSOR"},
};

/**
 * oh_encode_sensortype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiSensorTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_sensortype(), back 
 * into an SaHpiSensorTypeT type. 
 *
 * Returns:
 * SaHpiSensorTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_sensortype(SaHpiTextBufferT *buffer, SaHpiSensorTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_SENSORTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, sensortype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = sensortype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_sensorreadingtype:
 * @value: enum value of type SaHpiSensorReadingTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiSensorReadingTypeT.
 **/

char * oh_lookup_sensorreadingtype(SaHpiSensorReadingTypeT value)
{
        switch (value) {
        case SAHPI_SENSOR_READING_TYPE_INT64:
                return "INT64";
        case SAHPI_SENSOR_READING_TYPE_UINT64:
                return "UINT64";
        case SAHPI_SENSOR_READING_TYPE_FLOAT64:
                return "FLOAT64";
        case SAHPI_SENSOR_READING_TYPE_BUFFER:
                return "BUFFER";
        default:
                return NULL;
        }
}

struct oh_sensorreadingtype_map sensorreadingtype_strings[] = {
       {SAHPI_SENSOR_READING_TYPE_INT64, "INT64"},
       {SAHPI_SENSOR_READING_TYPE_UINT64, "UINT64"},
       {SAHPI_SENSOR_READING_TYPE_FLOAT64, "FLOAT64"},
       {SAHPI_SENSOR_READING_TYPE_BUFFER, "BUFFER"},
};

/**
 * oh_encode_sensorreadingtype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiSensorReadingTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_sensorreadingtype(), back 
 * into an SaHpiSensorReadingTypeT type. 
 *
 * Returns:
 * SaHpiSensorReadingTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_sensorreadingtype(SaHpiTextBufferT *buffer, SaHpiSensorReadingTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_SENSORREADINGTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, sensorreadingtype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = sensorreadingtype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_sensoreventmaskaction:
 * @value: enum value of type SaHpiSensorEventMaskActionT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiSensorEventMaskActionT.
 **/

char * oh_lookup_sensoreventmaskaction(SaHpiSensorEventMaskActionT value)
{
        switch (value) {
        case SAHPI_SENS_ADD_EVENTS_TO_MASKS:
                return "ADD_EVENTS_TO_MASKS";
        case SAHPI_SENS_REMOVE_EVENTS_FROM_MASKS:
                return "REMOVE_EVENTS_FROM_MASKS";
        default:
                return NULL;
        }
}

struct oh_sensoreventmaskaction_map sensoreventmaskaction_strings[] = {
       {SAHPI_SENS_ADD_EVENTS_TO_MASKS, "ADD_EVENTS_TO_MASKS"},
       {SAHPI_SENS_REMOVE_EVENTS_FROM_MASKS, "REMOVE_EVENTS_FROM_MASKS"},
};

/**
 * oh_encode_sensoreventmaskaction:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiSensorEventMaskActionT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_sensoreventmaskaction(), back 
 * into an SaHpiSensorEventMaskActionT type. 
 *
 * Returns:
 * SaHpiSensorEventMaskActionT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_sensoreventmaskaction(SaHpiTextBufferT *buffer, SaHpiSensorEventMaskActionT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_SENSOREVENTMASKACTION; i++) {
		if (strcasecmp((char *)buffer->Data, sensoreventmaskaction_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = sensoreventmaskaction_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_sensorunits:
 * @value: enum value of type SaHpiSensorUnitsT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiSensorUnitsT.
 **/

char * oh_lookup_sensorunits(SaHpiSensorUnitsT value)
{
        switch (value) {
        case SAHPI_SU_UNSPECIFIED:
                return "Unspecified";
        case SAHPI_SU_DEGREES_C:
                return "Degrees C";
        case SAHPI_SU_DEGREES_F:
                return "Degrees F";
        case SAHPI_SU_DEGREES_K:
                return "Degrees K";
        case SAHPI_SU_VOLTS:
                return "Volts";
        case SAHPI_SU_AMPS:
                return "Amps";
        case SAHPI_SU_WATTS:
                return "Watts";
        case SAHPI_SU_JOULES:
                return "Joules";
        case SAHPI_SU_COULOMBS:
                return "Coulombs";
        case SAHPI_SU_VA:
                return "Va";
        case SAHPI_SU_NITS:
                return "Nits";
        case SAHPI_SU_LUMEN:
                return "Lumen";
        case SAHPI_SU_LUX:
                return "Lux";
        case SAHPI_SU_CANDELA:
                return "Candela";
        case SAHPI_SU_KPA:
                return "Kpa";
        case SAHPI_SU_PSI:
                return "Psi";
        case SAHPI_SU_NEWTON:
                return "Newton";
        case SAHPI_SU_CFM:
                return "Cfm";
        case SAHPI_SU_RPM:
                return "Rpm";
        case SAHPI_SU_HZ:
                return "Hz";
        case SAHPI_SU_MICROSECOND:
                return "Microsecond";
        case SAHPI_SU_MILLISECOND:
                return "Millisecond";
        case SAHPI_SU_SECOND:
                return "Second";
        case SAHPI_SU_MINUTE:
                return "Minute";
        case SAHPI_SU_HOUR:
                return "Hour";
        case SAHPI_SU_DAY:
                return "Day";
        case SAHPI_SU_WEEK:
                return "Week";
        case SAHPI_SU_MIL:
                return "Mil";
        case SAHPI_SU_INCHES:
                return "Inches";
        case SAHPI_SU_FEET:
                return "Feet";
        case SAHPI_SU_CU_IN:
                return "Cu In";
        case SAHPI_SU_CU_FEET:
                return "Cu Feet";
        case SAHPI_SU_MM:
                return "Mm";
        case SAHPI_SU_CM:
                return "Cm";
        case SAHPI_SU_M:
                return "M";
        case SAHPI_SU_CU_CM:
                return "Cu Cm";
        case SAHPI_SU_CU_M:
                return "Cu M";
        case SAHPI_SU_LITERS:
                return "Liters";
        case SAHPI_SU_FLUID_OUNCE:
                return "Fluid Ounce";
        case SAHPI_SU_RADIANS:
                return "Radians";
        case SAHPI_SU_STERADIANS:
                return "Steradians";
        case SAHPI_SU_REVOLUTIONS:
                return "Revolutions";
        case SAHPI_SU_CYCLES:
                return "Cycles";
        case SAHPI_SU_GRAVITIES:
                return "Gravities";
        case SAHPI_SU_OUNCE:
                return "Ounce";
        case SAHPI_SU_POUND:
                return "Pound";
        case SAHPI_SU_FT_LB:
                return "Ft Lb";
        case SAHPI_SU_OZ_IN:
                return "Oz In";
        case SAHPI_SU_GAUSS:
                return "Gauss";
        case SAHPI_SU_GILBERTS:
                return "Gilberts";
        case SAHPI_SU_HENRY:
                return "Henry";
        case SAHPI_SU_MILLIHENRY:
                return "Millihenry";
        case SAHPI_SU_FARAD:
                return "Farad";
        case SAHPI_SU_MICROFARAD:
                return "Microfarad";
        case SAHPI_SU_OHMS:
                return "Ohms";
        case SAHPI_SU_SIEMENS:
                return "Siemens";
        case SAHPI_SU_MOLE:
                return "Mole";
        case SAHPI_SU_BECQUEREL:
                return "Becquerel";
        case SAHPI_SU_PPM:
                return "Ppm";
        case SAHPI_SU_RESERVED:
                return "Reserved";
        case SAHPI_SU_DECIBELS:
                return "Decibels";
        case SAHPI_SU_DBA:
                return "Dba";
        case SAHPI_SU_DBC:
                return "Dbc";
        case SAHPI_SU_GRAY:
                return "Gray";
        case SAHPI_SU_SIEVERT:
                return "Sievert";
        case SAHPI_SU_COLOR_TEMP_DEG_K:
                return "Color Temp Deg K";
        case SAHPI_SU_BIT:
                return "Bit";
        case SAHPI_SU_KILOBIT:
                return "Kilobit";
        case SAHPI_SU_MEGABIT:
                return "Megabit";
        case SAHPI_SU_GIGABIT:
                return "Gigabit";
        case SAHPI_SU_BYTE:
                return "Byte";
        case SAHPI_SU_KILOBYTE:
                return "Kilobyte";
        case SAHPI_SU_MEGABYTE:
                return "Megabyte";
        case SAHPI_SU_GIGABYTE:
                return "Gigabyte";
        case SAHPI_SU_WORD:
                return "Word";
        case SAHPI_SU_DWORD:
                return "Dword";
        case SAHPI_SU_QWORD:
                return "Qword";
        case SAHPI_SU_LINE:
                return "Line";
        case SAHPI_SU_HIT:
                return "Hit";
        case SAHPI_SU_MISS:
                return "Miss";
        case SAHPI_SU_RETRY:
                return "Retry";
        case SAHPI_SU_RESET:
                return "Reset";
        case SAHPI_SU_OVERRUN:
                return "Overrun";
        case SAHPI_SU_UNDERRUN:
                return "Underrun";
        case SAHPI_SU_COLLISION:
                return "Collision";
        case SAHPI_SU_PACKETS:
                return "Packets";
        case SAHPI_SU_MESSAGES:
                return "Messages";
        case SAHPI_SU_CHARACTERS:
                return "Characters";
        case SAHPI_SU_ERRORS:
                return "Errors";
        case SAHPI_SU_CORRECTABLE_ERRORS:
                return "Correctable Errors";
        case SAHPI_SU_UNCORRECTABLE_ERRORS:
                return "Uncorrectable Errors";
        default:
                return NULL;
        }
}

struct oh_sensorunits_map sensorunits_strings[] = {
       {SAHPI_SU_UNSPECIFIED, "Unspecified"},
       {SAHPI_SU_DEGREES_C, "Degrees C"},
       {SAHPI_SU_DEGREES_F, "Degrees F"},
       {SAHPI_SU_DEGREES_K, "Degrees K"},
       {SAHPI_SU_VOLTS, "Volts"},
       {SAHPI_SU_AMPS, "Amps"},
       {SAHPI_SU_WATTS, "Watts"},
       {SAHPI_SU_JOULES, "Joules"},
       {SAHPI_SU_COULOMBS, "Coulombs"},
       {SAHPI_SU_VA, "Va"},
       {SAHPI_SU_NITS, "Nits"},
       {SAHPI_SU_LUMEN, "Lumen"},
       {SAHPI_SU_LUX, "Lux"},
       {SAHPI_SU_CANDELA, "Candela"},
       {SAHPI_SU_KPA, "Kpa"},
       {SAHPI_SU_PSI, "Psi"},
       {SAHPI_SU_NEWTON, "Newton"},
       {SAHPI_SU_CFM, "Cfm"},
       {SAHPI_SU_RPM, "Rpm"},
       {SAHPI_SU_HZ, "Hz"},
       {SAHPI_SU_MICROSECOND, "Microsecond"},
       {SAHPI_SU_MILLISECOND, "Millisecond"},
       {SAHPI_SU_SECOND, "Second"},
       {SAHPI_SU_MINUTE, "Minute"},
       {SAHPI_SU_HOUR, "Hour"},
       {SAHPI_SU_DAY, "Day"},
       {SAHPI_SU_WEEK, "Week"},
       {SAHPI_SU_MIL, "Mil"},
       {SAHPI_SU_INCHES, "Inches"},
       {SAHPI_SU_FEET, "Feet"},
       {SAHPI_SU_CU_IN, "Cu In"},
       {SAHPI_SU_CU_FEET, "Cu Feet"},
       {SAHPI_SU_MM, "Mm"},
       {SAHPI_SU_CM, "Cm"},
       {SAHPI_SU_M, "M"},
       {SAHPI_SU_CU_CM, "Cu Cm"},
       {SAHPI_SU_CU_M, "Cu M"},
       {SAHPI_SU_LITERS, "Liters"},
       {SAHPI_SU_FLUID_OUNCE, "Fluid Ounce"},
       {SAHPI_SU_RADIANS, "Radians"},
       {SAHPI_SU_STERADIANS, "Steradians"},
       {SAHPI_SU_REVOLUTIONS, "Revolutions"},
       {SAHPI_SU_CYCLES, "Cycles"},
       {SAHPI_SU_GRAVITIES, "Gravities"},
       {SAHPI_SU_OUNCE, "Ounce"},
       {SAHPI_SU_POUND, "Pound"},
       {SAHPI_SU_FT_LB, "Ft Lb"},
       {SAHPI_SU_OZ_IN, "Oz In"},
       {SAHPI_SU_GAUSS, "Gauss"},
       {SAHPI_SU_GILBERTS, "Gilberts"},
       {SAHPI_SU_HENRY, "Henry"},
       {SAHPI_SU_MILLIHENRY, "Millihenry"},
       {SAHPI_SU_FARAD, "Farad"},
       {SAHPI_SU_MICROFARAD, "Microfarad"},
       {SAHPI_SU_OHMS, "Ohms"},
       {SAHPI_SU_SIEMENS, "Siemens"},
       {SAHPI_SU_MOLE, "Mole"},
       {SAHPI_SU_BECQUEREL, "Becquerel"},
       {SAHPI_SU_PPM, "Ppm"},
       {SAHPI_SU_RESERVED, "Reserved"},
       {SAHPI_SU_DECIBELS, "Decibels"},
       {SAHPI_SU_DBA, "Dba"},
       {SAHPI_SU_DBC, "Dbc"},
       {SAHPI_SU_GRAY, "Gray"},
       {SAHPI_SU_SIEVERT, "Sievert"},
       {SAHPI_SU_COLOR_TEMP_DEG_K, "Color Temp Deg K"},
       {SAHPI_SU_BIT, "Bit"},
       {SAHPI_SU_KILOBIT, "Kilobit"},
       {SAHPI_SU_MEGABIT, "Megabit"},
       {SAHPI_SU_GIGABIT, "Gigabit"},
       {SAHPI_SU_BYTE, "Byte"},
       {SAHPI_SU_KILOBYTE, "Kilobyte"},
       {SAHPI_SU_MEGABYTE, "Megabyte"},
       {SAHPI_SU_GIGABYTE, "Gigabyte"},
       {SAHPI_SU_WORD, "Word"},
       {SAHPI_SU_DWORD, "Dword"},
       {SAHPI_SU_QWORD, "Qword"},
       {SAHPI_SU_LINE, "Line"},
       {SAHPI_SU_HIT, "Hit"},
       {SAHPI_SU_MISS, "Miss"},
       {SAHPI_SU_RETRY, "Retry"},
       {SAHPI_SU_RESET, "Reset"},
       {SAHPI_SU_OVERRUN, "Overrun"},
       {SAHPI_SU_UNDERRUN, "Underrun"},
       {SAHPI_SU_COLLISION, "Collision"},
       {SAHPI_SU_PACKETS, "Packets"},
       {SAHPI_SU_MESSAGES, "Messages"},
       {SAHPI_SU_CHARACTERS, "Characters"},
       {SAHPI_SU_ERRORS, "Errors"},
       {SAHPI_SU_CORRECTABLE_ERRORS, "Correctable Errors"},
       {SAHPI_SU_UNCORRECTABLE_ERRORS, "Uncorrectable Errors"},
};

/**
 * oh_encode_sensorunits:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiSensorUnitsT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_sensorunits(), back 
 * into an SaHpiSensorUnitsT type. 
 *
 * Returns:
 * SaHpiSensorUnitsT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_sensorunits(SaHpiTextBufferT *buffer, SaHpiSensorUnitsT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_SENSORUNITS; i++) {
		if (strcasecmp((char *)buffer->Data, sensorunits_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = sensorunits_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_sensormodunituse:
 * @value: enum value of type SaHpiSensorModUnitUseT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiSensorModUnitUseT.
 **/

char * oh_lookup_sensormodunituse(SaHpiSensorModUnitUseT value)
{
        switch (value) {
        case SAHPI_SMUU_NONE:
                return "NONE";
        case SAHPI_SMUU_BASIC_OVER_MODIFIER:
                return "BASIC_OVER_MODIFIER";
        case SAHPI_SMUU_BASIC_TIMES_MODIFIER:
                return "BASIC_TIMES_MODIFIER";
        default:
                return NULL;
        }
}

struct oh_sensormodunituse_map sensormodunituse_strings[] = {
       {SAHPI_SMUU_NONE, "NONE"},
       {SAHPI_SMUU_BASIC_OVER_MODIFIER, "BASIC_OVER_MODIFIER"},
       {SAHPI_SMUU_BASIC_TIMES_MODIFIER, "BASIC_TIMES_MODIFIER"},
};

/**
 * oh_encode_sensormodunituse:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiSensorModUnitUseT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_sensormodunituse(), back 
 * into an SaHpiSensorModUnitUseT type. 
 *
 * Returns:
 * SaHpiSensorModUnitUseT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_sensormodunituse(SaHpiTextBufferT *buffer, SaHpiSensorModUnitUseT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_SENSORMODUNITUSE; i++) {
		if (strcasecmp((char *)buffer->Data, sensormodunituse_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = sensormodunituse_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_sensoreventctrl:
 * @value: enum value of type SaHpiSensorEventCtrlT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiSensorEventCtrlT.
 **/

char * oh_lookup_sensoreventctrl(SaHpiSensorEventCtrlT value)
{
        switch (value) {
        case SAHPI_SEC_PER_EVENT:
                return "PER_EVENT";
        case SAHPI_SEC_READ_ONLY_MASKS:
                return "READ_ONLY_MASKS";
        case SAHPI_SEC_READ_ONLY:
                return "READ_ONLY";
        default:
                return NULL;
        }
}

struct oh_sensoreventctrl_map sensoreventctrl_strings[] = {
       {SAHPI_SEC_PER_EVENT, "PER_EVENT"},
       {SAHPI_SEC_READ_ONLY_MASKS, "READ_ONLY_MASKS"},
       {SAHPI_SEC_READ_ONLY, "READ_ONLY"},
};

/**
 * oh_encode_sensoreventctrl:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiSensorEventCtrlT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_sensoreventctrl(), back 
 * into an SaHpiSensorEventCtrlT type. 
 *
 * Returns:
 * SaHpiSensorEventCtrlT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_sensoreventctrl(SaHpiTextBufferT *buffer, SaHpiSensorEventCtrlT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_SENSOREVENTCTRL; i++) {
		if (strcasecmp((char *)buffer->Data, sensoreventctrl_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = sensoreventctrl_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_ctrltype:
 * @value: enum value of type SaHpiCtrlTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiCtrlTypeT.
 **/

char * oh_lookup_ctrltype(SaHpiCtrlTypeT value)
{
        switch (value) {
        case SAHPI_CTRL_TYPE_DIGITAL:
                return "DIGITAL";
        case SAHPI_CTRL_TYPE_DISCRETE:
                return "DISCRETE";
        case SAHPI_CTRL_TYPE_ANALOG:
                return "ANALOG";
        case SAHPI_CTRL_TYPE_STREAM:
                return "STREAM";
        case SAHPI_CTRL_TYPE_TEXT:
                return "TEXT";
        case SAHPI_CTRL_TYPE_OEM:
                return "OEM";
        default:
                return NULL;
        }
}

struct oh_ctrltype_map ctrltype_strings[] = {
       {SAHPI_CTRL_TYPE_DIGITAL, "DIGITAL"},
       {SAHPI_CTRL_TYPE_DISCRETE, "DISCRETE"},
       {SAHPI_CTRL_TYPE_ANALOG, "ANALOG"},
       {SAHPI_CTRL_TYPE_STREAM, "STREAM"},
       {SAHPI_CTRL_TYPE_TEXT, "TEXT"},
       {SAHPI_CTRL_TYPE_OEM, "OEM"},
};

/**
 * oh_encode_ctrltype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiCtrlTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_ctrltype(), back 
 * into an SaHpiCtrlTypeT type. 
 *
 * Returns:
 * SaHpiCtrlTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_ctrltype(SaHpiTextBufferT *buffer, SaHpiCtrlTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_CTRLTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, ctrltype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = ctrltype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_ctrlstatedigital:
 * @value: enum value of type SaHpiCtrlStateDigitalT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiCtrlStateDigitalT.
 **/

char * oh_lookup_ctrlstatedigital(SaHpiCtrlStateDigitalT value)
{
        switch (value) {
        case SAHPI_CTRL_STATE_OFF:
                return "OFF";
        case SAHPI_CTRL_STATE_ON:
                return "ON";
        case SAHPI_CTRL_STATE_PULSE_OFF:
                return "PULSE_OFF";
        case SAHPI_CTRL_STATE_PULSE_ON:
                return "PULSE_ON";
        default:
                return NULL;
        }
}

struct oh_ctrlstatedigital_map ctrlstatedigital_strings[] = {
       {SAHPI_CTRL_STATE_OFF, "OFF"},
       {SAHPI_CTRL_STATE_ON, "ON"},
       {SAHPI_CTRL_STATE_PULSE_OFF, "PULSE_OFF"},
       {SAHPI_CTRL_STATE_PULSE_ON, "PULSE_ON"},
};

/**
 * oh_encode_ctrlstatedigital:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiCtrlStateDigitalT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_ctrlstatedigital(), back 
 * into an SaHpiCtrlStateDigitalT type. 
 *
 * Returns:
 * SaHpiCtrlStateDigitalT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_ctrlstatedigital(SaHpiTextBufferT *buffer, SaHpiCtrlStateDigitalT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_CTRLSTATEDIGITAL; i++) {
		if (strcasecmp((char *)buffer->Data, ctrlstatedigital_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = ctrlstatedigital_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_ctrlmode:
 * @value: enum value of type SaHpiCtrlModeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiCtrlModeT.
 **/

char * oh_lookup_ctrlmode(SaHpiCtrlModeT value)
{
        switch (value) {
        case SAHPI_CTRL_MODE_AUTO:
                return "AUTO";
        case SAHPI_CTRL_MODE_MANUAL:
                return "MANUAL";
        default:
                return NULL;
        }
}

struct oh_ctrlmode_map ctrlmode_strings[] = {
       {SAHPI_CTRL_MODE_AUTO, "AUTO"},
       {SAHPI_CTRL_MODE_MANUAL, "MANUAL"},
};

/**
 * oh_encode_ctrlmode:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiCtrlModeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_ctrlmode(), back 
 * into an SaHpiCtrlModeT type. 
 *
 * Returns:
 * SaHpiCtrlModeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_ctrlmode(SaHpiTextBufferT *buffer, SaHpiCtrlModeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_CTRLMODE; i++) {
		if (strcasecmp((char *)buffer->Data, ctrlmode_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = ctrlmode_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_ctrloutputtype:
 * @value: enum value of type SaHpiCtrlOutputTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiCtrlOutputTypeT.
 **/

char * oh_lookup_ctrloutputtype(SaHpiCtrlOutputTypeT value)
{
        switch (value) {
        case SAHPI_CTRL_GENERIC:
                return "GENERIC";
        case SAHPI_CTRL_LED:
                return "LED";
        case SAHPI_CTRL_FAN_SPEED:
                return "FAN_SPEED";
        case SAHPI_CTRL_DRY_CONTACT_CLOSURE:
                return "DRY_CONTACT_CLOSURE";
        case SAHPI_CTRL_POWER_SUPPLY_INHIBIT:
                return "POWER_SUPPLY_INHIBIT";
        case SAHPI_CTRL_AUDIBLE:
                return "AUDIBLE";
        case SAHPI_CTRL_FRONT_PANEL_LOCKOUT:
                return "FRONT_PANEL_LOCKOUT";
        case SAHPI_CTRL_POWER_INTERLOCK:
                return "POWER_INTERLOCK";
        case SAHPI_CTRL_POWER_STATE:
                return "POWER_STATE";
        case SAHPI_CTRL_LCD_DISPLAY:
                return "LCD_DISPLAY";
        case SAHPI_CTRL_OEM:
                return "OEM";
        default:
                return NULL;
        }
}

struct oh_ctrloutputtype_map ctrloutputtype_strings[] = {
       {SAHPI_CTRL_GENERIC, "GENERIC"},
       {SAHPI_CTRL_LED, "LED"},
       {SAHPI_CTRL_FAN_SPEED, "FAN_SPEED"},
       {SAHPI_CTRL_DRY_CONTACT_CLOSURE, "DRY_CONTACT_CLOSURE"},
       {SAHPI_CTRL_POWER_SUPPLY_INHIBIT, "POWER_SUPPLY_INHIBIT"},
       {SAHPI_CTRL_AUDIBLE, "AUDIBLE"},
       {SAHPI_CTRL_FRONT_PANEL_LOCKOUT, "FRONT_PANEL_LOCKOUT"},
       {SAHPI_CTRL_POWER_INTERLOCK, "POWER_INTERLOCK"},
       {SAHPI_CTRL_POWER_STATE, "POWER_STATE"},
       {SAHPI_CTRL_LCD_DISPLAY, "LCD_DISPLAY"},
       {SAHPI_CTRL_OEM, "OEM"},
};

/**
 * oh_encode_ctrloutputtype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiCtrlOutputTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_ctrloutputtype(), back 
 * into an SaHpiCtrlOutputTypeT type. 
 *
 * Returns:
 * SaHpiCtrlOutputTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_ctrloutputtype(SaHpiTextBufferT *buffer, SaHpiCtrlOutputTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_CTRLOUTPUTTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, ctrloutputtype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = ctrloutputtype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_idrareatype:
 * @value: enum value of type SaHpiIdrAreaTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiIdrAreaTypeT.
 **/

char * oh_lookup_idrareatype(SaHpiIdrAreaTypeT value)
{
        switch (value) {
        case SAHPI_IDR_AREATYPE_INTERNAL_USE:
                return "INTERNAL_USE";
        case SAHPI_IDR_AREATYPE_CHASSIS_INFO:
                return "CHASSIS_INFO";
        case SAHPI_IDR_AREATYPE_BOARD_INFO:
                return "BOARD_INFO";
        case SAHPI_IDR_AREATYPE_PRODUCT_INFO:
                return "PRODUCT_INFO";
        case SAHPI_IDR_AREATYPE_OEM:
                return "OEM";
        case SAHPI_IDR_AREATYPE_UNSPECIFIED:
                return "UNSPECIFIED";
        default:
                return NULL;
        }
}

struct oh_idrareatype_map idrareatype_strings[] = {
       {SAHPI_IDR_AREATYPE_INTERNAL_USE, "INTERNAL_USE"},
       {SAHPI_IDR_AREATYPE_CHASSIS_INFO, "CHASSIS_INFO"},
       {SAHPI_IDR_AREATYPE_BOARD_INFO, "BOARD_INFO"},
       {SAHPI_IDR_AREATYPE_PRODUCT_INFO, "PRODUCT_INFO"},
       {SAHPI_IDR_AREATYPE_OEM, "OEM"},
       {SAHPI_IDR_AREATYPE_UNSPECIFIED, "UNSPECIFIED"},
};

/**
 * oh_encode_idrareatype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiIdrAreaTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_idrareatype(), back 
 * into an SaHpiIdrAreaTypeT type. 
 *
 * Returns:
 * SaHpiIdrAreaTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_idrareatype(SaHpiTextBufferT *buffer, SaHpiIdrAreaTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_IDRAREATYPE; i++) {
		if (strcasecmp((char *)buffer->Data, idrareatype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = idrareatype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_idrfieldtype:
 * @value: enum value of type SaHpiIdrFieldTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiIdrFieldTypeT.
 **/

char * oh_lookup_idrfieldtype(SaHpiIdrFieldTypeT value)
{
        switch (value) {
        case SAHPI_IDR_FIELDTYPE_CHASSIS_TYPE:
                return "CHASSIS_TYPE";
        case SAHPI_IDR_FIELDTYPE_MFG_DATETIME:
                return "MFG_DATETIME";
        case SAHPI_IDR_FIELDTYPE_MANUFACTURER:
                return "MANUFACTURER";
        case SAHPI_IDR_FIELDTYPE_PRODUCT_NAME:
                return "PRODUCT_NAME";
        case SAHPI_IDR_FIELDTYPE_PRODUCT_VERSION:
                return "PRODUCT_VERSION";
        case SAHPI_IDR_FIELDTYPE_SERIAL_NUMBER:
                return "SERIAL_NUMBER";
        case SAHPI_IDR_FIELDTYPE_PART_NUMBER:
                return "PART_NUMBER";
        case SAHPI_IDR_FIELDTYPE_FILE_ID:
                return "FILE_ID";
        case SAHPI_IDR_FIELDTYPE_ASSET_TAG:
                return "ASSET_TAG";
        case SAHPI_IDR_FIELDTYPE_CUSTOM:
                return "CUSTOM";
        case SAHPI_IDR_FIELDTYPE_UNSPECIFIED:
                return "UNSPECIFIED";
        default:
                return NULL;
        }
}

struct oh_idrfieldtype_map idrfieldtype_strings[] = {
       {SAHPI_IDR_FIELDTYPE_CHASSIS_TYPE, "CHASSIS_TYPE"},
       {SAHPI_IDR_FIELDTYPE_MFG_DATETIME, "MFG_DATETIME"},
       {SAHPI_IDR_FIELDTYPE_MANUFACTURER, "MANUFACTURER"},
       {SAHPI_IDR_FIELDTYPE_PRODUCT_NAME, "PRODUCT_NAME"},
       {SAHPI_IDR_FIELDTYPE_PRODUCT_VERSION, "PRODUCT_VERSION"},
       {SAHPI_IDR_FIELDTYPE_SERIAL_NUMBER, "SERIAL_NUMBER"},
       {SAHPI_IDR_FIELDTYPE_PART_NUMBER, "PART_NUMBER"},
       {SAHPI_IDR_FIELDTYPE_FILE_ID, "FILE_ID"},
       {SAHPI_IDR_FIELDTYPE_ASSET_TAG, "ASSET_TAG"},
       {SAHPI_IDR_FIELDTYPE_CUSTOM, "CUSTOM"},
       {SAHPI_IDR_FIELDTYPE_UNSPECIFIED, "UNSPECIFIED"},
};

/**
 * oh_encode_idrfieldtype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiIdrFieldTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_idrfieldtype(), back 
 * into an SaHpiIdrFieldTypeT type. 
 *
 * Returns:
 * SaHpiIdrFieldTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_idrfieldtype(SaHpiTextBufferT *buffer, SaHpiIdrFieldTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_IDRFIELDTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, idrfieldtype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = idrfieldtype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_watchdogaction:
 * @value: enum value of type SaHpiWatchdogActionT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiWatchdogActionT.
 **/

char * oh_lookup_watchdogaction(SaHpiWatchdogActionT value)
{
        switch (value) {
        case SAHPI_WA_NO_ACTION:
                return "NO_ACTION";
        case SAHPI_WA_RESET:
                return "RESET";
        case SAHPI_WA_POWER_DOWN:
                return "POWER_DOWN";
        case SAHPI_WA_POWER_CYCLE:
                return "POWER_CYCLE";
        default:
                return NULL;
        }
}

struct oh_watchdogaction_map watchdogaction_strings[] = {
       {SAHPI_WA_NO_ACTION, "NO_ACTION"},
       {SAHPI_WA_RESET, "RESET"},
       {SAHPI_WA_POWER_DOWN, "POWER_DOWN"},
       {SAHPI_WA_POWER_CYCLE, "POWER_CYCLE"},
};

/**
 * oh_encode_watchdogaction:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiWatchdogActionT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_watchdogaction(), back 
 * into an SaHpiWatchdogActionT type. 
 *
 * Returns:
 * SaHpiWatchdogActionT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_watchdogaction(SaHpiTextBufferT *buffer, SaHpiWatchdogActionT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_WATCHDOGACTION; i++) {
		if (strcasecmp((char *)buffer->Data, watchdogaction_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = watchdogaction_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_watchdogactionevent:
 * @value: enum value of type SaHpiWatchdogActionEventT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiWatchdogActionEventT.
 **/

char * oh_lookup_watchdogactionevent(SaHpiWatchdogActionEventT value)
{
        switch (value) {
        case SAHPI_WAE_NO_ACTION:
                return "NO_ACTION";
        case SAHPI_WAE_RESET:
                return "RESET";
        case SAHPI_WAE_POWER_DOWN:
                return "POWER_DOWN";
        case SAHPI_WAE_POWER_CYCLE:
                return "POWER_CYCLE";
        case SAHPI_WAE_TIMER_INT:
                return "TIMER_INT";
        default:
                return NULL;
        }
}

struct oh_watchdogactionevent_map watchdogactionevent_strings[] = {
       {SAHPI_WAE_NO_ACTION, "NO_ACTION"},
       {SAHPI_WAE_RESET, "RESET"},
       {SAHPI_WAE_POWER_DOWN, "POWER_DOWN"},
       {SAHPI_WAE_POWER_CYCLE, "POWER_CYCLE"},
       {SAHPI_WAE_TIMER_INT, "TIMER_INT"},
};

/**
 * oh_encode_watchdogactionevent:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiWatchdogActionEventT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_watchdogactionevent(), back 
 * into an SaHpiWatchdogActionEventT type. 
 *
 * Returns:
 * SaHpiWatchdogActionEventT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_watchdogactionevent(SaHpiTextBufferT *buffer, SaHpiWatchdogActionEventT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_WATCHDOGACTIONEVENT; i++) {
		if (strcasecmp((char *)buffer->Data, watchdogactionevent_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = watchdogactionevent_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_watchdogpretimerinterrupt:
 * @value: enum value of type SaHpiWatchdogPretimerInterruptT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiWatchdogPretimerInterruptT.
 **/

char * oh_lookup_watchdogpretimerinterrupt(SaHpiWatchdogPretimerInterruptT value)
{
        switch (value) {
        case SAHPI_WPI_NONE:
                return "NONE";
        case SAHPI_WPI_SMI:
                return "SMI";
        case SAHPI_WPI_NMI:
                return "NMI";
        case SAHPI_WPI_MESSAGE_INTERRUPT:
                return "MESSAGE_INTERRUPT";
        case SAHPI_WPI_OEM:
                return "OEM";
        default:
                return NULL;
        }
}

struct oh_watchdogpretimerinterrupt_map watchdogpretimerinterrupt_strings[] = {
       {SAHPI_WPI_NONE, "NONE"},
       {SAHPI_WPI_SMI, "SMI"},
       {SAHPI_WPI_NMI, "NMI"},
       {SAHPI_WPI_MESSAGE_INTERRUPT, "MESSAGE_INTERRUPT"},
       {SAHPI_WPI_OEM, "OEM"},
};

/**
 * oh_encode_watchdogpretimerinterrupt:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiWatchdogPretimerInterruptT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_watchdogpretimerinterrupt(), back 
 * into an SaHpiWatchdogPretimerInterruptT type. 
 *
 * Returns:
 * SaHpiWatchdogPretimerInterruptT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_watchdogpretimerinterrupt(SaHpiTextBufferT *buffer, SaHpiWatchdogPretimerInterruptT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_WATCHDOGPRETIMERINTERRUPT; i++) {
		if (strcasecmp((char *)buffer->Data, watchdogpretimerinterrupt_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = watchdogpretimerinterrupt_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_watchdogtimeruse:
 * @value: enum value of type SaHpiWatchdogTimerUseT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiWatchdogTimerUseT.
 **/

char * oh_lookup_watchdogtimeruse(SaHpiWatchdogTimerUseT value)
{
        switch (value) {
        case SAHPI_WTU_NONE:
                return "NONE";
        case SAHPI_WTU_BIOS_FRB2:
                return "BIOS_FRB2";
        case SAHPI_WTU_BIOS_POST:
                return "BIOS_POST";
        case SAHPI_WTU_OS_LOAD:
                return "OS_LOAD";
        case SAHPI_WTU_SMS_OS:
                return "SMS_OS";
        case SAHPI_WTU_OEM:
                return "OEM";
        case SAHPI_WTU_UNSPECIFIED:
                return "UNSPECIFIED";
        default:
                return NULL;
        }
}

struct oh_watchdogtimeruse_map watchdogtimeruse_strings[] = {
       {SAHPI_WTU_NONE, "NONE"},
       {SAHPI_WTU_BIOS_FRB2, "BIOS_FRB2"},
       {SAHPI_WTU_BIOS_POST, "BIOS_POST"},
       {SAHPI_WTU_OS_LOAD, "OS_LOAD"},
       {SAHPI_WTU_SMS_OS, "SMS_OS"},
       {SAHPI_WTU_OEM, "OEM"},
       {SAHPI_WTU_UNSPECIFIED, "UNSPECIFIED"},
};

/**
 * oh_encode_watchdogtimeruse:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiWatchdogTimerUseT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_watchdogtimeruse(), back 
 * into an SaHpiWatchdogTimerUseT type. 
 *
 * Returns:
 * SaHpiWatchdogTimerUseT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_watchdogtimeruse(SaHpiTextBufferT *buffer, SaHpiWatchdogTimerUseT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_WATCHDOGTIMERUSE; i++) {
		if (strcasecmp((char *)buffer->Data, watchdogtimeruse_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = watchdogtimeruse_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_hsindicatorstate:
 * @value: enum value of type SaHpiHsIndicatorStateT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiHsIndicatorStateT.
 **/

char * oh_lookup_hsindicatorstate(SaHpiHsIndicatorStateT value)
{
        switch (value) {
        case SAHPI_HS_INDICATOR_OFF:
                return "OFF";
        case SAHPI_HS_INDICATOR_ON:
                return "ON";
        default:
                return NULL;
        }
}

struct oh_hsindicatorstate_map hsindicatorstate_strings[] = {
       {SAHPI_HS_INDICATOR_OFF, "OFF"},
       {SAHPI_HS_INDICATOR_ON, "ON"},
};

/**
 * oh_encode_hsindicatorstate:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiHsIndicatorStateT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_hsindicatorstate(), back 
 * into an SaHpiHsIndicatorStateT type. 
 *
 * Returns:
 * SaHpiHsIndicatorStateT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_hsindicatorstate(SaHpiTextBufferT *buffer, SaHpiHsIndicatorStateT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_HSINDICATORSTATE; i++) {
		if (strcasecmp((char *)buffer->Data, hsindicatorstate_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = hsindicatorstate_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_hsaction:
 * @value: enum value of type SaHpiHsActionT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiHsActionT.
 **/

char * oh_lookup_hsaction(SaHpiHsActionT value)
{
        switch (value) {
        case SAHPI_HS_ACTION_INSERTION:
                return "INSERTION";
        case SAHPI_HS_ACTION_EXTRACTION:
                return "EXTRACTION";
        default:
                return NULL;
        }
}

struct oh_hsaction_map hsaction_strings[] = {
       {SAHPI_HS_ACTION_INSERTION, "INSERTION"},
       {SAHPI_HS_ACTION_EXTRACTION, "EXTRACTION"},
};

/**
 * oh_encode_hsaction:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiHsActionT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_hsaction(), back 
 * into an SaHpiHsActionT type. 
 *
 * Returns:
 * SaHpiHsActionT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_hsaction(SaHpiTextBufferT *buffer, SaHpiHsActionT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_HSACTION; i++) {
		if (strcasecmp((char *)buffer->Data, hsaction_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = hsaction_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_hsstate:
 * @value: enum value of type SaHpiHsStateT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiHsStateT.
 **/

char * oh_lookup_hsstate(SaHpiHsStateT value)
{
        switch (value) {
        case SAHPI_HS_STATE_INACTIVE:
                return "INACTIVE";
        case SAHPI_HS_STATE_INSERTION_PENDING:
                return "INSERTION_PENDING";
        case SAHPI_HS_STATE_ACTIVE:
                return "ACTIVE";
        case SAHPI_HS_STATE_EXTRACTION_PENDING:
                return "EXTRACTION_PENDING";
        case SAHPI_HS_STATE_NOT_PRESENT:
                return "NOT_PRESENT";
        default:
                return NULL;
        }
}

struct oh_hsstate_map hsstate_strings[] = {
       {SAHPI_HS_STATE_INACTIVE, "INACTIVE"},
       {SAHPI_HS_STATE_INSERTION_PENDING, "INSERTION_PENDING"},
       {SAHPI_HS_STATE_ACTIVE, "ACTIVE"},
       {SAHPI_HS_STATE_EXTRACTION_PENDING, "EXTRACTION_PENDING"},
       {SAHPI_HS_STATE_NOT_PRESENT, "NOT_PRESENT"},
};

/**
 * oh_encode_hsstate:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiHsStateT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_hsstate(), back 
 * into an SaHpiHsStateT type. 
 *
 * Returns:
 * SaHpiHsStateT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_hsstate(SaHpiTextBufferT *buffer, SaHpiHsStateT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_HSSTATE; i++) {
		if (strcasecmp((char *)buffer->Data, hsstate_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = hsstate_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_severity:
 * @value: enum value of type SaHpiSeverityT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiSeverityT.
 **/

char * oh_lookup_severity(SaHpiSeverityT value)
{
        switch (value) {
        case SAHPI_CRITICAL:
                return "CRITICAL";
        case SAHPI_MAJOR:
                return "MAJOR";
        case SAHPI_MINOR:
                return "MINOR";
        case SAHPI_INFORMATIONAL:
                return "INFORMATIONAL";
        case SAHPI_OK:
                return "OK";
        case SAHPI_DEBUG:
                return "DEBUG";
        case SAHPI_ALL_SEVERITIES:
                return "ALL_SEVERITIES";
        default:
                return NULL;
        }
}

struct oh_severity_map severity_strings[] = {
       {SAHPI_CRITICAL, "CRITICAL"},
       {SAHPI_MAJOR, "MAJOR"},
       {SAHPI_MINOR, "MINOR"},
       {SAHPI_INFORMATIONAL, "INFORMATIONAL"},
       {SAHPI_OK, "OK"},
       {SAHPI_DEBUG, "DEBUG"},
       {SAHPI_ALL_SEVERITIES, "ALL_SEVERITIES"},
};

/**
 * oh_encode_severity:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiSeverityT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_severity(), back 
 * into an SaHpiSeverityT type. 
 *
 * Returns:
 * SaHpiSeverityT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_severity(SaHpiTextBufferT *buffer, SaHpiSeverityT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_SEVERITY; i++) {
		if (strcasecmp((char *)buffer->Data, severity_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = severity_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_resourceeventtype:
 * @value: enum value of type SaHpiResourceEventTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiResourceEventTypeT.
 **/

char * oh_lookup_resourceeventtype(SaHpiResourceEventTypeT value)
{
        switch (value) {
        case SAHPI_RESE_RESOURCE_FAILURE:
                return "FAILURE";
        case SAHPI_RESE_RESOURCE_RESTORED:
                return "RESTORED";
        case SAHPI_RESE_RESOURCE_ADDED:
                return "ADDED";
        default:
                return NULL;
        }
}

struct oh_resourceeventtype_map resourceeventtype_strings[] = {
       {SAHPI_RESE_RESOURCE_FAILURE, "FAILURE"},
       {SAHPI_RESE_RESOURCE_RESTORED, "RESTORED"},
       {SAHPI_RESE_RESOURCE_ADDED, "ADDED"},
};

/**
 * oh_encode_resourceeventtype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiResourceEventTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_resourceeventtype(), back 
 * into an SaHpiResourceEventTypeT type. 
 *
 * Returns:
 * SaHpiResourceEventTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_resourceeventtype(SaHpiTextBufferT *buffer, SaHpiResourceEventTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_RESOURCEEVENTTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, resourceeventtype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = resourceeventtype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_domaineventtype:
 * @value: enum value of type SaHpiDomainEventTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiDomainEventTypeT.
 **/

char * oh_lookup_domaineventtype(SaHpiDomainEventTypeT value)
{
        switch (value) {
        case SAHPI_DOMAIN_REF_ADDED:
                return "ADDED";
        case SAHPI_DOMAIN_REF_REMOVED:
                return "REMOVED";
        default:
                return NULL;
        }
}

struct oh_domaineventtype_map domaineventtype_strings[] = {
       {SAHPI_DOMAIN_REF_ADDED, "ADDED"},
       {SAHPI_DOMAIN_REF_REMOVED, "REMOVED"},
};

/**
 * oh_encode_domaineventtype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiDomainEventTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_domaineventtype(), back 
 * into an SaHpiDomainEventTypeT type. 
 *
 * Returns:
 * SaHpiDomainEventTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_domaineventtype(SaHpiTextBufferT *buffer, SaHpiDomainEventTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_DOMAINEVENTTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, domaineventtype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = domaineventtype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_sweventtype:
 * @value: enum value of type SaHpiSwEventTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiSwEventTypeT.
 **/

char * oh_lookup_sweventtype(SaHpiSwEventTypeT value)
{
        switch (value) {
        case SAHPI_HPIE_AUDIT:
                return "AUDIT";
        case SAHPI_HPIE_STARTUP:
                return "STARTUP";
        case SAHPI_HPIE_OTHER:
                return "OTHER";
        default:
                return NULL;
        }
}

struct oh_sweventtype_map sweventtype_strings[] = {
       {SAHPI_HPIE_AUDIT, "AUDIT"},
       {SAHPI_HPIE_STARTUP, "STARTUP"},
       {SAHPI_HPIE_OTHER, "OTHER"},
};

/**
 * oh_encode_sweventtype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiSwEventTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_sweventtype(), back 
 * into an SaHpiSwEventTypeT type. 
 *
 * Returns:
 * SaHpiSwEventTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_sweventtype(SaHpiTextBufferT *buffer, SaHpiSwEventTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_SWEVENTTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, sweventtype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = sweventtype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_eventtype:
 * @value: enum value of type SaHpiEventTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiEventTypeT.
 **/

char * oh_lookup_eventtype(SaHpiEventTypeT value)
{
        switch (value) {
        case SAHPI_ET_RESOURCE:
                return "RESOURCE";
        case SAHPI_ET_DOMAIN:
                return "DOMAIN";
        case SAHPI_ET_SENSOR:
                return "SENSOR";
        case SAHPI_ET_SENSOR_ENABLE_CHANGE:
                return "SENSOR_ENABLE_CHANGE";
        case SAHPI_ET_HOTSWAP:
                return "HOTSWAP";
        case SAHPI_ET_WATCHDOG:
                return "WATCHDOG";
        case SAHPI_ET_HPI_SW:
                return "HPI_SW";
        case SAHPI_ET_OEM:
                return "OEM";
        case SAHPI_ET_USER:
                return "USER";
        default:
                return NULL;
        }
}

struct oh_eventtype_map eventtype_strings[] = {
       {SAHPI_ET_RESOURCE, "RESOURCE"},
       {SAHPI_ET_DOMAIN, "DOMAIN"},
       {SAHPI_ET_SENSOR, "SENSOR"},
       {SAHPI_ET_SENSOR_ENABLE_CHANGE, "SENSOR_ENABLE_CHANGE"},
       {SAHPI_ET_HOTSWAP, "HOTSWAP"},
       {SAHPI_ET_WATCHDOG, "WATCHDOG"},
       {SAHPI_ET_HPI_SW, "HPI_SW"},
       {SAHPI_ET_OEM, "OEM"},
       {SAHPI_ET_USER, "USER"},
};

/**
 * oh_encode_eventtype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiEventTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_eventtype(), back 
 * into an SaHpiEventTypeT type. 
 *
 * Returns:
 * SaHpiEventTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_eventtype(SaHpiTextBufferT *buffer, SaHpiEventTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_EVENTTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, eventtype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = eventtype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_statuscondtype:
 * @value: enum value of type SaHpiStatusCondTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiStatusCondTypeT.
 **/

char * oh_lookup_statuscondtype(SaHpiStatusCondTypeT value)
{
        switch (value) {
        case SAHPI_STATUS_COND_TYPE_SENSOR:
                return "SENSOR";
        case SAHPI_STATUS_COND_TYPE_RESOURCE:
                return "RESOURCE";
        case SAHPI_STATUS_COND_TYPE_OEM:
                return "OEM";
        case SAHPI_STATUS_COND_TYPE_USER:
                return "USER";
        default:
                return NULL;
        }
}

struct oh_statuscondtype_map statuscondtype_strings[] = {
       {SAHPI_STATUS_COND_TYPE_SENSOR, "SENSOR"},
       {SAHPI_STATUS_COND_TYPE_RESOURCE, "RESOURCE"},
       {SAHPI_STATUS_COND_TYPE_OEM, "OEM"},
       {SAHPI_STATUS_COND_TYPE_USER, "USER"},
};

/**
 * oh_encode_statuscondtype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiStatusCondTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_statuscondtype(), back 
 * into an SaHpiStatusCondTypeT type. 
 *
 * Returns:
 * SaHpiStatusCondTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_statuscondtype(SaHpiTextBufferT *buffer, SaHpiStatusCondTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_STATUSCONDTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, statuscondtype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = statuscondtype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_annunciatormode:
 * @value: enum value of type SaHpiAnnunciatorModeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiAnnunciatorModeT.
 **/

char * oh_lookup_annunciatormode(SaHpiAnnunciatorModeT value)
{
        switch (value) {
        case SAHPI_ANNUNCIATOR_MODE_AUTO:
                return "AUTO";
        case SAHPI_ANNUNCIATOR_MODE_USER:
                return "USER";
        case SAHPI_ANNUNCIATOR_MODE_SHARED:
                return "SHARED";
        default:
                return NULL;
        }
}

struct oh_annunciatormode_map annunciatormode_strings[] = {
       {SAHPI_ANNUNCIATOR_MODE_AUTO, "AUTO"},
       {SAHPI_ANNUNCIATOR_MODE_USER, "USER"},
       {SAHPI_ANNUNCIATOR_MODE_SHARED, "SHARED"},
};

/**
 * oh_encode_annunciatormode:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiAnnunciatorModeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_annunciatormode(), back 
 * into an SaHpiAnnunciatorModeT type. 
 *
 * Returns:
 * SaHpiAnnunciatorModeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_annunciatormode(SaHpiTextBufferT *buffer, SaHpiAnnunciatorModeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_ANNUNCIATORMODE; i++) {
		if (strcasecmp((char *)buffer->Data, annunciatormode_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = annunciatormode_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_annunciatortype:
 * @value: enum value of type SaHpiAnnunciatorTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiAnnunciatorTypeT.
 **/

char * oh_lookup_annunciatortype(SaHpiAnnunciatorTypeT value)
{
        switch (value) {
        case SAHPI_ANNUNCIATOR_TYPE_LED:
                return "LED";
        case SAHPI_ANNUNCIATOR_TYPE_DRY_CONTACT_CLOSURE:
                return "DRY_CONTACT_CLOSURE";
        case SAHPI_ANNUNCIATOR_TYPE_AUDIBLE:
                return "AUDIBLE";
        case SAHPI_ANNUNCIATOR_TYPE_LCD_DISPLAY:
                return "LCD_DISPLAY";
        case SAHPI_ANNUNCIATOR_TYPE_MESSAGE:
                return "MESSAGE";
        case SAHPI_ANNUNCIATOR_TYPE_COMPOSITE:
                return "COMPOSITE";
        case SAHPI_ANNUNCIATOR_TYPE_OEM:
                return "OEM";
        default:
                return NULL;
        }
}

struct oh_annunciatortype_map annunciatortype_strings[] = {
       {SAHPI_ANNUNCIATOR_TYPE_LED, "LED"},
       {SAHPI_ANNUNCIATOR_TYPE_DRY_CONTACT_CLOSURE, "DRY_CONTACT_CLOSURE"},
       {SAHPI_ANNUNCIATOR_TYPE_AUDIBLE, "AUDIBLE"},
       {SAHPI_ANNUNCIATOR_TYPE_LCD_DISPLAY, "LCD_DISPLAY"},
       {SAHPI_ANNUNCIATOR_TYPE_MESSAGE, "MESSAGE"},
       {SAHPI_ANNUNCIATOR_TYPE_COMPOSITE, "COMPOSITE"},
       {SAHPI_ANNUNCIATOR_TYPE_OEM, "OEM"},
};

/**
 * oh_encode_annunciatortype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiAnnunciatorTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_annunciatortype(), back 
 * into an SaHpiAnnunciatorTypeT type. 
 *
 * Returns:
 * SaHpiAnnunciatorTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_annunciatortype(SaHpiTextBufferT *buffer, SaHpiAnnunciatorTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_ANNUNCIATORTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, annunciatortype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = annunciatortype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_rdrtype:
 * @value: enum value of type SaHpiRdrTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiRdrTypeT.
 **/

char * oh_lookup_rdrtype(SaHpiRdrTypeT value)
{
        switch (value) {
        case SAHPI_NO_RECORD:
                return "NO_RECORD";
        case SAHPI_CTRL_RDR:
                return "CTRL_RDR";
        case SAHPI_SENSOR_RDR:
                return "SENSOR_RDR";
        case SAHPI_INVENTORY_RDR:
                return "INVENTORY_RDR";
        case SAHPI_WATCHDOG_RDR:
                return "WATCHDOG_RDR";
        case SAHPI_ANNUNCIATOR_RDR:
                return "ANNUNCIATOR_RDR";
        default:
                return NULL;
        }
}

struct oh_rdrtype_map rdrtype_strings[] = {
       {SAHPI_NO_RECORD, "NO_RECORD"},
       {SAHPI_CTRL_RDR, "CTRL_RDR"},
       {SAHPI_SENSOR_RDR, "SENSOR_RDR"},
       {SAHPI_INVENTORY_RDR, "INVENTORY_RDR"},
       {SAHPI_WATCHDOG_RDR, "WATCHDOG_RDR"},
       {SAHPI_ANNUNCIATOR_RDR, "ANNUNCIATOR_RDR"},
};

/**
 * oh_encode_rdrtype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiRdrTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_rdrtype(), back 
 * into an SaHpiRdrTypeT type. 
 *
 * Returns:
 * SaHpiRdrTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_rdrtype(SaHpiTextBufferT *buffer, SaHpiRdrTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_RDRTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, rdrtype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = rdrtype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_parmaction:
 * @value: enum value of type SaHpiParmActionT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiParmActionT.
 **/

char * oh_lookup_parmaction(SaHpiParmActionT value)
{
        switch (value) {
        case SAHPI_DEFAULT_PARM:
                return "DEFAULT_PARM";
        case SAHPI_SAVE_PARM:
                return "SAVE_PARM";
        case SAHPI_RESTORE_PARM:
                return "RESTORE_PARM";
        default:
                return NULL;
        }
}

struct oh_parmaction_map parmaction_strings[] = {
       {SAHPI_DEFAULT_PARM, "DEFAULT_PARM"},
       {SAHPI_SAVE_PARM, "SAVE_PARM"},
       {SAHPI_RESTORE_PARM, "RESTORE_PARM"},
};

/**
 * oh_encode_parmaction:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiParmActionT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_parmaction(), back 
 * into an SaHpiParmActionT type. 
 *
 * Returns:
 * SaHpiParmActionT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_parmaction(SaHpiTextBufferT *buffer, SaHpiParmActionT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_PARMACTION; i++) {
		if (strcasecmp((char *)buffer->Data, parmaction_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = parmaction_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_resetaction:
 * @value: enum value of type SaHpiResetActionT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiResetActionT.
 **/

char * oh_lookup_resetaction(SaHpiResetActionT value)
{
        switch (value) {
        case SAHPI_COLD_RESET:
                return "COLD_RESET";
        case SAHPI_WARM_RESET:
                return "WARM_RESET";
        case SAHPI_RESET_ASSERT:
                return "RESET_ASSERT";
        case SAHPI_RESET_DEASSERT:
                return "RESET_DEASSERT";
        default:
                return NULL;
        }
}

struct oh_resetaction_map resetaction_strings[] = {
       {SAHPI_COLD_RESET, "COLD_RESET"},
       {SAHPI_WARM_RESET, "WARM_RESET"},
       {SAHPI_RESET_ASSERT, "RESET_ASSERT"},
       {SAHPI_RESET_DEASSERT, "RESET_DEASSERT"},
};

/**
 * oh_encode_resetaction:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiResetActionT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_resetaction(), back 
 * into an SaHpiResetActionT type. 
 *
 * Returns:
 * SaHpiResetActionT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_resetaction(SaHpiTextBufferT *buffer, SaHpiResetActionT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_RESETACTION; i++) {
		if (strcasecmp((char *)buffer->Data, resetaction_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = resetaction_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_powerstate:
 * @value: enum value of type SaHpiPowerStateT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiPowerStateT.
 **/

char * oh_lookup_powerstate(SaHpiPowerStateT value)
{
        switch (value) {
        case SAHPI_POWER_OFF:
                return "OFF";
        case SAHPI_POWER_ON:
                return "ON";
        case SAHPI_POWER_CYCLE:
                return "CYCLE";
        default:
                return NULL;
        }
}

struct oh_powerstate_map powerstate_strings[] = {
       {SAHPI_POWER_OFF, "OFF"},
       {SAHPI_POWER_ON, "ON"},
       {SAHPI_POWER_CYCLE, "CYCLE"},
};

/**
 * oh_encode_powerstate:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiPowerStateT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_powerstate(), back 
 * into an SaHpiPowerStateT type. 
 *
 * Returns:
 * SaHpiPowerStateT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_powerstate(SaHpiTextBufferT *buffer, SaHpiPowerStateT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_POWERSTATE; i++) {
		if (strcasecmp((char *)buffer->Data, powerstate_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = powerstate_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_eventlogoverflowaction:
 * @value: enum value of type SaHpiEventLogOverflowActionT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiEventLogOverflowActionT.
 **/

char * oh_lookup_eventlogoverflowaction(SaHpiEventLogOverflowActionT value)
{
        switch (value) {
        case SAHPI_EL_OVERFLOW_DROP:
                return "OVERFLOW_DROP";
        case SAHPI_EL_OVERFLOW_OVERWRITE:
                return "OVERFLOW_OVERWRITE";
        default:
                return NULL;
        }
}

struct oh_eventlogoverflowaction_map eventlogoverflowaction_strings[] = {
       {SAHPI_EL_OVERFLOW_DROP, "OVERFLOW_DROP"},
       {SAHPI_EL_OVERFLOW_OVERWRITE, "OVERFLOW_OVERWRITE"},
};

/**
 * oh_encode_eventlogoverflowaction:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiEventLogOverflowActionT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_eventlogoverflowaction(), back 
 * into an SaHpiEventLogOverflowActionT type. 
 *
 * Returns:
 * SaHpiEventLogOverflowActionT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_eventlogoverflowaction(SaHpiTextBufferT *buffer, SaHpiEventLogOverflowActionT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_EVENTLOGOVERFLOWACTION; i++) {
		if (strcasecmp((char *)buffer->Data, eventlogoverflowaction_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = eventlogoverflowaction_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_error:
 * @value: enum value of type SaErrorT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaErrorT.
 **/

char * oh_lookup_error(SaErrorT value)
{
        switch (value) {
        case SA_OK:
                return "SA_OK";
        case SA_ERR_HPI_ERROR:
                return "ERROR";
        case SA_ERR_HPI_UNSUPPORTED_API:
                return "UNSUPPORTED_API";
        case SA_ERR_HPI_BUSY:
                return "BUSY";
        case SA_ERR_HPI_INTERNAL_ERROR:
                return "INTERNAL_ERROR";
        case SA_ERR_HPI_INVALID_CMD:
                return "INVALID_CMD";
        case SA_ERR_HPI_TIMEOUT:
                return "TIMEOUT";
        case SA_ERR_HPI_OUT_OF_SPACE:
                return "OUT_OF_SPACE";
        case SA_ERR_HPI_OUT_OF_MEMORY:
                return "OUT_OF_MEMORY";
        case SA_ERR_HPI_INVALID_PARAMS:
                return "INVALID_PARAMS";
        case SA_ERR_HPI_INVALID_DATA:
                return "INVALID_DATA";
        case SA_ERR_HPI_NOT_PRESENT:
                return "NOT_PRESENT";
        case SA_ERR_HPI_NO_RESPONSE:
                return "NO_RESPONSE";
        case SA_ERR_HPI_DUPLICATE:
                return "DUPLICATE";
        case SA_ERR_HPI_INVALID_SESSION:
                return "INVALID_SESSION";
        case SA_ERR_HPI_INVALID_DOMAIN:
                return "INVALID_DOMAIN";
        case SA_ERR_HPI_INVALID_RESOURCE:
                return "INVALID_RESOURCE";
        case SA_ERR_HPI_INVALID_REQUEST:
                return "INVALID_REQUEST";
        case SA_ERR_HPI_ENTITY_NOT_PRESENT:
                return "ENTITY_NOT_PRESENT";
        case SA_ERR_HPI_READ_ONLY:
                return "READ_ONLY";
        case SA_ERR_HPI_CAPABILITY:
                return "CAPABILITY";
        case SA_ERR_HPI_UNKNOWN:
                return "UNKNOWN";
        default:
                return NULL;
        }
}

struct oh_error_map error_strings[] = {
       {SA_OK, "SA_OK"},
       {SA_ERR_HPI_ERROR, "ERROR"},
       {SA_ERR_HPI_UNSUPPORTED_API, "UNSUPPORTED_API"},
       {SA_ERR_HPI_BUSY, "BUSY"},
       {SA_ERR_HPI_INTERNAL_ERROR, "INTERNAL_ERROR"},
       {SA_ERR_HPI_INVALID_CMD, "INVALID_CMD"},
       {SA_ERR_HPI_TIMEOUT, "TIMEOUT"},
       {SA_ERR_HPI_OUT_OF_SPACE, "OUT_OF_SPACE"},
       {SA_ERR_HPI_OUT_OF_MEMORY, "OUT_OF_MEMORY"},
       {SA_ERR_HPI_INVALID_PARAMS, "INVALID_PARAMS"},
       {SA_ERR_HPI_INVALID_DATA, "INVALID_DATA"},
       {SA_ERR_HPI_NOT_PRESENT, "NOT_PRESENT"},
       {SA_ERR_HPI_NO_RESPONSE, "NO_RESPONSE"},
       {SA_ERR_HPI_DUPLICATE, "DUPLICATE"},
       {SA_ERR_HPI_INVALID_SESSION, "INVALID_SESSION"},
       {SA_ERR_HPI_INVALID_DOMAIN, "INVALID_DOMAIN"},
       {SA_ERR_HPI_INVALID_RESOURCE, "INVALID_RESOURCE"},
       {SA_ERR_HPI_INVALID_REQUEST, "INVALID_REQUEST"},
       {SA_ERR_HPI_ENTITY_NOT_PRESENT, "ENTITY_NOT_PRESENT"},
       {SA_ERR_HPI_READ_ONLY, "READ_ONLY"},
       {SA_ERR_HPI_CAPABILITY, "CAPABILITY"},
       {SA_ERR_HPI_UNKNOWN, "UNKNOWN"},
};

/**
 * oh_encode_error:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaErrorT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_error(), back 
 * into an SaErrorT type. 
 *
 * Returns:
 * SaErrorT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_error(SaHpiTextBufferT *buffer, SaErrorT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_ERROR; i++) {
		if (strcasecmp((char *)buffer->Data, error_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = error_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_eventcategory:
 * @value: enum value of type SaHpiEventCategoryT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid SaHpiEventCategoryT.
 **/

char * oh_lookup_eventcategory(SaHpiEventCategoryT value)
{
        switch (value) {
        case SAHPI_EC_UNSPECIFIED:
                return "UNSPECIFIED";
        case SAHPI_EC_THRESHOLD:
                return "THRESHOLD";
        case SAHPI_EC_USAGE:
                return "USAGE";
        case SAHPI_EC_STATE:
                return "STATE";
        case SAHPI_EC_PRED_FAIL:
                return "PRED_FAIL";
        case SAHPI_EC_LIMIT:
                return "LIMIT";
        case SAHPI_EC_PERFORMANCE:
                return "PERFORMANCE";
        case SAHPI_EC_SEVERITY:
                return "SEVERITY";
        case SAHPI_EC_PRESENCE:
                return "PRESENCE";
        case SAHPI_EC_ENABLE:
                return "ENABLE";
        case SAHPI_EC_AVAILABILITY:
                return "AVAILABILITY";
        case SAHPI_EC_REDUNDANCY:
                return "REDUNDANCY";
        case SAHPI_EC_SENSOR_SPECIFIC:
                return "SENSOR_SPECIFIC";
        case SAHPI_EC_GENERIC:
                return "GENERIC";
        default:
                return NULL;
        }
}

struct oh_eventcategory_map eventcategory_strings[] = {
       {SAHPI_EC_UNSPECIFIED, "UNSPECIFIED"},
       {SAHPI_EC_THRESHOLD, "THRESHOLD"},
       {SAHPI_EC_USAGE, "USAGE"},
       {SAHPI_EC_STATE, "STATE"},
       {SAHPI_EC_PRED_FAIL, "PRED_FAIL"},
       {SAHPI_EC_LIMIT, "LIMIT"},
       {SAHPI_EC_PERFORMANCE, "PERFORMANCE"},
       {SAHPI_EC_SEVERITY, "SEVERITY"},
       {SAHPI_EC_PRESENCE, "PRESENCE"},
       {SAHPI_EC_ENABLE, "ENABLE"},
       {SAHPI_EC_AVAILABILITY, "AVAILABILITY"},
       {SAHPI_EC_REDUNDANCY, "REDUNDANCY"},
       {SAHPI_EC_SENSOR_SPECIFIC, "SENSOR_SPECIFIC"},
       {SAHPI_EC_GENERIC, "GENERIC"},
};

/**
 * oh_encode_eventcategory:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of SaHpiEventCategoryT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_eventcategory(), back 
 * into an SaHpiEventCategoryT type. 
 *
 * Returns:
 * SaHpiEventCategoryT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_eventcategory(SaHpiTextBufferT *buffer, SaHpiEventCategoryT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_EVENTCATEGORY; i++) {
		if (strcasecmp((char *)buffer->Data, eventcategory_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = eventcategory_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

