%define prefix /usr

Name: openhpi
Summary: openhpi - implementation of SAForum Hardware Platform Interface 
Version: 2.6.2
Release: 1
License: BSD
URL: http://openhpi.sourceforge.net
Group: Utilities
Vendor: OpenHPI Project
Packager: TariqX
Source: openhpi-2.6.2.tar.gz
Buildroot: /var/tmp/openhpi-root
BuildRequires: pkgconfig glib2-devel
BuildRequires: docbook-utils docbook-utils-pdf docbook-dtd41-sgml
Summary: Library that provides SAForum's HPI
Group: Utilities
AutoReq: yes
Requires: libc.so.6 libglib-2.0.so.0 libpthread.so.0

%package devel
Summary: Development files for HPI
Group: Utilities
AutoReq: yes
Requires: openhpi = 2.6.2
Requires: pkgconfig

%package clients
Summary: HPI command line applications
Group: Utilities
AutoReq: yes
Requires: openhpi = 2.6.2

%package daemon
Summary: HPI remote daemon
Group: Utilities
Autoreq: yes
Requires: openhpi = 2.6.2

%description 
This package contains an implementation of Service Availability Forum's 
HPI specification.  It includes support for multiple different types of
hardware including: IPMI, IBM Blade Center (via SNMP), Linux Watchdog devices,
and Sysfs based systems.

%description devel
Contains additional files need for a developer to create applications
and/or middleware that depends uses the Service Availability Forum's
HPI specification

%description clients
This package contains hpi command line utilities 

%description daemon
This package contains hpi daemon implementing a simple text remote protocol
for exchanging HPI data between applications.  This is an EXPERIMENTAL package

###################################################
%prep
###################################################

###################################################
%setup
###################################################

###################################################
%build
###################################################
./configure '--sysconfdir=/etc' '--with-varpath=/var/lib/openhpi' --sysconfdir=/etc \
    --localstatedir=/var --prefix=%{prefix}
make
make -C docs/hld pdf-am
make -C docs/hld openhpi-manual/book1.html

###################################################
%install
###################################################
if
  [ ! -z "${RPM_BUILD_ROOT}"  -a "${RPM_BUILD_ROOT}" != "/" ]
then
  rm -rf $RPM_BUILD_ROOT
fi
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/etc/openhpi
mkdir -p $RPM_BUILD_ROOT/var/lib/openhpi
install -m 644 examples/openhpi.conf.example $RPM_BUILD_ROOT/etc/openhpi/openhpi.conf
%post

###################################################
%files
###################################################
%defattr(-,root,root)
%doc README COPYING 
%doc docs/hld/*pdf
%doc docs/hld/openhpi-manual
%config /etc/openhpi/*
%dir /var/lib/openhpi
%{prefix}/lib/libopen*
%{prefix}/lib/openhpi/standard/libopen*
%{prefix}/lib/openhpi/client/libopen*
%{prefix}/lib/openhpi/lib*
%{prefix}/bin/openhpi-switcher
%{prefix}/man/man1/openhpi-switcher.1.gz
%{prefix}/man/man7/openhpi.7.gz
# dummy*
#%{prefix}/lib/openhpi/libsysfs*#
#%{prefix}/lib/openhpi/libsnmp_bc*
#%{prefix}/lib/openhpi/libwatchdog*
#%{prefix}/lib/openhpi/libipmi*

###################################################
%files devel
###################################################
%defattr(-,root,root)
%dir %{prefix}/include/openhpi
%{prefix}/include/openhpi/*h
%{prefix}/include/openhpi/*hpp
%{prefix}/lib/pkgconfig/openhpi.pc
%{prefix}/lib/pkgconfig/openhpiutils.pc


###################################################
%files clients
###################################################
%defattr(-,root,root)
%{prefix}/bin/hpi*

###################################################
%files daemon
###################################################
%defattr(-,root,root)
%{prefix}/bin/openhpid
%{prefix}/lib/liboh*

###################################################
%clean
###################################################
if
    [ -z "${RPM_BUILD_ROOT}"  -a "${RPM_BUILD_ROOT}" != "/" ]
then
    rm -rf $RPM_BUILD_ROOT
fi
rm -rf $RPM_BUILD_DIR/openhpi-2.6.2

