<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/OpenDbSnoopy.class.inc");
include_once("./functions/logging.php");
include_once("./functions/thumbnails.php");

/**
* This will always return an array, no
* matter what.  If no files in specified
* $from directory (with specified $ext)
* an empty array will be returned instead.
* 
* Does not RECURSE subdirectories.
* 
* Note: $ext IS CASE SENSITIVE!
*/
function get_file_list($dir, $ext=NULL)
{
	$handle=opendir($dir);
	while ($file = readdir($handle))
    {	
		if($file != "." && $file != ".." && !is_dir($dir.'/'.$file))
		{ 	 
			if($ext==NULL || eregi("[^$]+\.".$ext."$",$file))
			{
				$filelist[] = $file;
			}
		}
	}
	closedir($handle);

	if(is_array($filelist) && count($filelist)>0)
	    return $filelist;
	else // empty array as last resort.
		return array();
}

/**
	Get file extension.
*/
function get_file_ext($filename)
{
	$lastindex = strrpos($filename, ".");
	if($lastindex!==FALSE && $lastindex>0)
		return substr($filename,$lastindex+1);//+1 for the "."
	else
		return FALSE;// What else can I do!
}

function parse_file($filename)
{
	$lastindex = strrpos($filename, ".");
	if($lastindex!==FALSE && $lastindex>0)
	{
		return array('name'=>substr($filename,0, $lastindex), 
					'extension'=>substr($filename,$lastindex+1));//+1 for the "."
	}
	else
	{
		return FALSE;// What else can I do!
	}
}

/**
	Will return the filename extension if it is legal. Or false
	otherwise.
*/
function get_valid_extension($filename, $extensions)
{
	$ext = strtolower(get_file_ext($filename));
	if($ext!==FALSE)
	{
		// If no extension specified this indicates that all are legal.
		if(strlen($extensions)==0)
		{
			return $ext;
		}
		else
		{
			// As $extensions is not empty, $extensions_r will have
			// at least one element.
			$extensions_r = explode(",", strtolower($extensions));
			if(in_array($ext, $extensions_r))
			{
				return $ext;
			}
		}
	}

	//else
	return FALSE;
}

/**
	@param $filename_mask	This parameter expects a {ext} variable, which
			will be replaced with the actual extension of the original
			file at $url.
*/
function save_url_file($url, $save_dir, $filename, $dooverwrite)
{
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	if(is_dir($save_dir))
	{
		if(substr($save_dir,-1) == "/")
			$save_dir = substr($save_dir,0,-1);
			
		$snoopy =& new OpenDbSnoopy();
		$buf = $snoopy->fetchURI($url, FALSE);
		if($buf!==FALSE)
		{
			if($dooverwrite || !@file_exists($save_dir."/".$filename))
			{
				if(write_file_contents($save_dir."/".$filename, $buf, $error))
				{
					if($CONFIG_VARS['thumbnail.enable']!==FALSE && is_thumbable_image_file($filename))
					{
						opendb_log("URL File saved. (directory=".$save_dir.", file=".$filename.", update_who=".$HTTP_SESSION_VARS['user_id'].")");
						
						// ignore any errors - logged to opendb log.
						generate_thumbnail($save_dir, $filename, $errors);
					}
					
					return $save_dir."/".$filename;
				}
				else
				{
					opendb_log("URL File could not be saved. (directory=".$save_dir.", file=".$filename.") [".$error."]");
					return FALSE;
				}
			}
			else
			{
				opendb_log("URL File already exists. (directory=".$save_dir.", file=".$filename.")");
				return FALSE;
			}
		}
		else
		{
			opendb_log("URL file could not be downloaded. [".$snoopy->status.":".$snoopy->error."]");
			return FALSE;
		}
	}
	else
	{
		opendb_log("Invalid item files directory specified. (directory=".$save_dir.")");
		return FALSE;
	}
}

/**
	@param $http_post_file	- Assumes a $HTTP_POST_FILES entry!
*/
function save_upload_file($http_tmp_name, $save_dir, $filename, $dooverwrite)
{
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	if(is_dir($save_dir))
	{
		if(substr($save_dir,-1) == "/")
			$save_dir = substr($save_dir,0,-1);

		if(is_uploaded_file($http_tmp_name))
		{
			if($dooverwrite || !@file_exists($save_dir."/".$filename))
			{
				if( ($contents = read_file_contents($http_tmp_name, $error)) !== FALSE)
				{
					if(write_file_contents($save_dir."/".$filename, $contents, $error))
					{
						if($CONFIG_VARS['thumbnail.enable']!==FALSE && is_thumbable_image_file($filename))
						{
							opendb_log("Upload File saved. (directory=".$save_dir.", file=".$filename.", update_who=".$HTTP_SESSION_VARS['user_id'].")");
							
							// ignore any errors - logged to opendb log.
							generate_thumbnail($save_dir, $filename, $errors);
						}
						
						return $save_dir."/".$filename;
					}
					else
					{
						opendb_log("Upload File could not be saved. (directory=".$save_dir.", file=".$filename.") [".$error."]");
						return FALSE;
					}
				}
				else
				{
					opendb_log("Upload File could not be read. (upload_file=".$http_tmp_name.") [".$error."]");
					return FALSE;
				}
			}
			else
			{
				opendb_log("Upload File already exists. (directory=".$save_dir.", file=".$filename.")");
				return FALSE;
			}
		}
		else
		{
			opendb_log("Invalid upload file specified.");
			return FALSE;
		}			
	}
	else
	{
		opendb_log("Invalid item files directory specified. (directory=".$save_dir.")");
		return FALSE;
	}		
}

/**
	Load the contents of a file into a buffer.

	The &$error string will contain any errors
	returned from trying to open file.
*/
function read_file_contents($filename, &$error)
{
	$buffer = "";
	
	// make sure this file even exists
	if(file_exists($filename))
	{
		// open file - in binary mode.
		$fileptr = @fopen($filename, "rb");
		if($fileptr)
		{
			// get file contents (read)
			$size   = @filesize($filename);
			$buffer = @fread($fileptr, $size);
	
			// close file, all done!
			@fclose($fileptr);

			return $buffer;
		}
		else
		{
			$error = "Failure opening file.";
		}
	}
	else
	{
		$error = "File does not exist.";
	}
	
	//else
	return FALSE;
}

/**
	Write a $string to filename
	 
	Warning: Does not care if it already exists,
			 will overwrite it!

	The &$error string will contain any errors
	returned from trying to open file.
*/
function write_file_contents($filename, $buffer, &$error)
{
	global $CONFIG_VARS;
	
	$file = @fopen($filename, 'wb');
	if($file !== FALSE)
	{
		$written = @fwrite($file, $buffer);
		if($written != -1)
		{
			@fclose($file);

			// attempt to change the mode of the file.			
			if(is_numeric($CONFIG_VARS['file_upload.chmod_mask']))
			{
				// still assumes octal.
				if(strlen($CONFIG_VARS['file_upload.chmod_mask']) == 3)
					$mode_dec = octdec('0'.$CONFIG_VARS['file_upload.chmod_mask']);
				else
					$mode_dec = octdec($CONFIG_VARS['file_upload.chmod_mask']);
				
				if(!chmod($filename, $mode_dec))
				{
					opendb_logger(OPENDB_LOG_ERROR, 'functions/fileutils.php', 'write_file_contents', 'Could not chmod file', NULL, array($filename));
				}
			}
			
			return TRUE;
		}
		else
		{
			@fclose($file);
			$error = "Failure writing file.";
			return FALSE;
		}
	}
	else
	{
		$error = "Failure opening file for writing.";
		return FALSE;
	}
}
?>