<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// For is_exists_attribute_type(...) function
include_once("./admin/s_attribute_type/functions.php");
include_once("./functions/item_attribute.php");

/**
	This function checks if the s_attribute_type is configured
	to be a lookup type.  It does not check for the existence
	of s_attribute_type_lookup records, because this would
	preclude the editing of new s_attribute_types.
*/
function is_lookup_s_attribute_type($s_attribute_type)
{
	if(is_exists_attribute_type($s_attribute_type))
	{
		$s_attribute_type_r = fetch_attribute_type_r($s_attribute_type);
		if(is_lookup_input_type($s_attribute_type_r['input_type']))
			return TRUE;
	}

	//else
	return FALSE;
}

/**
	Is input_type a lookup type.
*/
function is_lookup_input_type($lookup)
{
	include("./admin/s_attribute_type_lookup/config.php");
	
	// Work out what format the argument was passed.
	if(is_array($lookup) && strlen($lookup['input_type'])>0)
		$input_type = trim($lookup['input_type']);
	else if(strlen($lookup)>0)
		$input_type = trim($lookup);

	if(strlen($input_type)>0)
	{
		$widget = prc_function_spec($input_type);
		if(strlen($widget['type'])>0 && in_array($widget['type'], $lookup_input_type_funcs))
			return TRUE;
	}

	//else
	return FALSE;
}

function fetch_s_attribute_type_lookup_cnt($s_attribute_type)
{
	global $CONFIG_VARS;

	$query = "SELECT count('x') as count FROM s_attribute_type_lookup WHERE s_attribute_type = '".$s_attribute_type."'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
			return $found['count'];
	}
}

/**
	Check if record exists.
*/
function is_exists_s_atribute_type_lookup($s_attribute_type, $value)
{
	$query = "SELECT 'x' FROM s_attribute_type_lookup WHERE s_attribute_type = '".$s_attribute_type."' AND value = '$value'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

/**
	Assumes that is_exists_s_atribute_type_lookup($s_attribute_type, $value) has been called 
	before this function to ensure we are not inserting a duplicate.  Mysql will fall over any
	way.
*/
function insert_s_attribute_type_lookup($s_attribute_type, $value, $display, $img, $checked_ind, $order_no)
{
	global $HTTP_SESSION_VARS;
	
	$display = addslashes(trim(strip_tags($display)));

	// Validate checked_ind
	if(strcasecmp($checked_ind,"Y")===0 || strcasecmp($checked_ind,"N")===0)
		$checked_ind = strtoupper($checked_ind);
	else
		$checked_ind = "";

	$query = "INSERT INTO s_attribute_type_lookup (s_attribute_type, value, display, img, checked_ind, order_no) "
			."VALUES ('$s_attribute_type', '".$value."', '".$display."', '$img', '$checked_ind', ".(is_numeric($order_no)?"'$order_no'":"NULL").")";
	$update = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($update && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Inserted s_attribute_type_lookup (s_attribute_type=$s_attribute_type, value=$value, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to insert s_attribute_type_lookup (s_attribute_type=$s_attribute_type, value=$value, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

/**
*/
function update_s_attribute_type_lookup($s_attribute_type, $value, $display, $img, $checked_ind, $order_no)
{
	global $HTTP_SESSION_VARS;
	
	$display = addslashes(trim(strip_tags($display)));

	// Validate checked_ind
	if(strcasecmp($checked_ind,"Y")===0 || strcasecmp($checked_ind,"N")===0)
		$checked_ind = strtoupper($checked_ind);
	else
		$checked_ind = "";

	$query = "UPDATE s_attribute_type_lookup "
			."SET display = '".$display."', "
			."img = '$img', "
			."checked_ind = '$checked_ind', "
			."order_no = ".(is_numeric($order_no)?"'$order_no'":"NULL")." "
			."WHERE s_attribute_type = '$s_attribute_type' AND "
			."value = '$value'";

	$update = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($update && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Updated s_attribute_type_lookup (s_attribute_type=$s_attribute_type, value=$value, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to update s_attribute_type_lookup (s_attribute_type=$s_attribute_type, value=$value, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

/**
	Assumes record exists!
*/
function delete_s_attribute_type_lookup($s_attribute_type, $value)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM s_attribute_type_lookup "
			."WHERE s_attribute_type = '$s_attribute_type' AND "
			."value = '$value'";

	$delete = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($delete && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Deleted s_attribute_type_lookup (s_attribute_type=$s_attribute_type, value=$value, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete s_attribute_type_lookup (s_attribute_type=$s_attribute_type, value=$value, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}
?>