// AISDisplayModeView.h : interface of the CAISDisplayModeView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIEWERVIEW_H__4EF39FBC_4EBB_11D1_8D67_0800369C8A03__INCLUDED_)
#define AFX_VIEWERVIEW_H__4EF39FBC_4EBB_11D1_8D67_0800369C8A03__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <AISDisplayModeDoc.h>
#include <OCC_3dView.h>

enum View3D_CurrentAction { 
	CurrentAction3d_Nothing,
	CurrentAction3d_DynamicZooming,
	CurrentAction3d_WindowZooming,
	CurrentAction3d_DynamicPanning,
	CurrentAction3d_GlobalPanning,
	CurrentAction3d_DynamicRotation,
	CurrentAction3d_FirstPointLight,
	CurrentAction3d_SecondPointLight
};

class CAISDisplayModeView : public OCC_3dView
{
protected: // create from serialization only
	CAISDisplayModeView();
	DECLARE_DYNCREATE(CAISDisplayModeView)

// Attributes
public:
	CAISDisplayModeDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAISDisplayModeView)
	public:
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CAISDisplayModeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CAISDisplayModeView)
	afx_msg void OnBUTTONPan();
	afx_msg void OnBUTTONPanGlo();
	afx_msg void OnBUTTONRot();
	afx_msg void OnBUTTONZoomProg();
	afx_msg void OnBUTTONZoomWin();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLigths();
	afx_msg void OnUpdateBUTTONPanGlo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONPan(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONZoomProg(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONZoomWin(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONRot(CCmdUI* pCmdUI);

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
    View3D_CurrentAction myCurrentMode;
};

#ifndef _DEBUG  // debug version in AISDisplayModeView.cpp
inline CAISDisplayModeDoc* CAISDisplayModeView::GetDocument()
   { return (CAISDisplayModeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_VIEWERVIEW_H__4EF39FBC_4EBB_11D1_8D67_0800369C8A03__INCLUDED_)
