// File:	StepToGeom_MakePolyline2d.cxx
// Created:	Mon Feb 15 15:05:36 1999
// Author:	Andrey BETENEV
//		<abv@doomox.nnov.matra-dtv.fr>

#include <StepToGeom_MakePolyline2d.ixx>
#include <StepToGeom_MakeCartesianPoint2d.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <Geom2d_CartesianPoint.hxx>

#include <TColgp_Array1OfPnt2d.hxx>
#include <TColStd_Array1OfReal.hxx>
#include <TColStd_Array1OfInteger.hxx>

//=======================================================================
//function : StepToGeom_MakePolyline2d
//purpose  : 
//=======================================================================

StepToGeom_MakePolyline2d::StepToGeom_MakePolyline2d (const Handle(StepGeom_Polyline) &PL)
{
  done = Standard_False;
  if ( PL.IsNull() || PL->NbPoints() <2 ) return;
  
  Standard_Integer nbp = PL->NbPoints();
  TColgp_Array1OfPnt2d Poles ( 1, nbp );
  TColStd_Array1OfReal Knots ( 1, nbp );
  TColStd_Array1OfInteger Mults ( 1, nbp );
  
  for ( Standard_Integer i=1; i <= nbp; i++ ) {
    Knots.SetValue ( i, i-1 );
    Mults.SetValue ( i, 1 );
    Handle(StepGeom_CartesianPoint) CP = PL->PointsValue ( i );
    StepToGeom_MakeCartesianPoint2d MkPoint ( CP );
    Handle(Geom2d_CartesianPoint) P = MkPoint.Value();
    Poles.SetValue ( i, P->Pnt2d() );
  }
  Mults.SetValue ( 1, 2 );
  Mults.SetValue ( nbp, 2 );
  
  myBSpl = new Geom2d_BSplineCurve ( Poles, Knots, Mults, 1 );
  done = Standard_True;
}

//=======================================================================
//function : Value
//purpose  : 
//=======================================================================

const Handle(Geom2d_BSplineCurve) &StepToGeom_MakePolyline2d::Value () const
{
  return myBSpl;
}
