// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Voxel_BooleanOperation_HeaderFile
#define _Voxel_BooleanOperation_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Voxel_BoolDS;
class Voxel_ColorDS;
class Voxel_FloatDS;
class Voxel_DS;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Boolean operations (fuse, cut) <br>
//!          for voxels of the same dimension. <br>
class Voxel_BooleanOperation  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! An empty constructor. <br>
Standard_EXPORT Voxel_BooleanOperation();

//! Fuses two cubes of voxels. <br>
//!          It modifies the first cube of voxels. <br>
//!          It returns false in case of different dimension of the cube, <br>
//!          different number of voxels. <br>
Standard_EXPORT   Standard_Boolean Fuse(Voxel_BoolDS& theVoxels1,const Voxel_BoolDS& theVoxels2) const;

//! Fuses two cubes of voxels. <br>
//!          It modifies the first cube of voxels. <br>
//!          It returns false in case of different dimension of the cube, <br>
//!          different number of voxels. <br>
//!          It summerizes the value of corresponding voxels and puts the result to theVoxels1. <br>
//!          If the result exceeds 15 or becomes greater, it keeps 15. <br>
Standard_EXPORT   Standard_Boolean Fuse(Voxel_ColorDS& theVoxels1,const Voxel_ColorDS& theVoxels2) const;

//! Fuses two cubes of voxels. <br>
//!          It modifies the first cube of voxels. <br>
//!          It returns false in case of different dimension of the cube, <br>
//!          different number of voxels. <br>
//!          It summerizes the value of corresponding voxels and puts the result to theVoxels1. <br>
Standard_EXPORT   Standard_Boolean Fuse(Voxel_FloatDS& theVoxels1,const Voxel_FloatDS& theVoxels2) const;

//! Cuts two cubes of voxels. <br>
//!          It modifies the first cube of voxels. <br>
//!          It returns false in case of different dimension of the cube, <br>
//!          different number of voxels. <br>
Standard_EXPORT   Standard_Boolean Cut(Voxel_BoolDS& theVoxels1,const Voxel_BoolDS& theVoxels2) const;

//! Cuts two cubes of voxels. <br>
//!          It modifies the first cube of voxels. <br>
//!          It returns false in case of different dimension of the cube, <br>
//!          different number of voxels. <br>
//!          It subtracts the value of corresponding voxels and puts the result to theVoxels1. <br>
Standard_EXPORT   Standard_Boolean Cut(Voxel_ColorDS& theVoxels1,const Voxel_ColorDS& theVoxels2) const;

//! Cuts two cubes of voxels. <br>
//!          It modifies the first cube of voxels. <br>
//!          It returns false in case of different dimension of the cube, <br>
//!          different number of voxels. <br>
//!          It subtracts the value of corresponding voxels and puts the result to theVoxels1. <br>
Standard_EXPORT   Standard_Boolean Cut(Voxel_FloatDS& theVoxels1,const Voxel_FloatDS& theVoxels2) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean Check(const Voxel_DS& theVoxels1,const Voxel_DS& theVoxels2) const;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
