// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeUpgrade_ConvertSurfaceToBezierBasis_HeaderFile
#define _ShapeUpgrade_ConvertSurfaceToBezierBasis_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis_HeaderFile
#include <Handle_ShapeUpgrade_ConvertSurfaceToBezierBasis.hxx>
#endif

#ifndef _Handle_ShapeExtend_CompositeSurface_HeaderFile
#include <Handle_ShapeExtend_CompositeSurface.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _ShapeUpgrade_SplitSurface_HeaderFile
#include <ShapeUpgrade_SplitSurface.hxx>
#endif
class ShapeExtend_CompositeSurface;


//! Converts a plane, bspline surface, surface of revolution, surface <br>
//!          of extrusion, offset surface to grid of bezier basis surface ( <br>
//!           bezier surface, <br>
//!           surface of revolution based on bezier curve, <br>
//!           offset surface based on any previous type). <br>
class ShapeUpgrade_ConvertSurfaceToBezierBasis : public ShapeUpgrade_SplitSurface {

public:
 // Methods PUBLIC
 // 

//! Empty constructor. <br>
Standard_EXPORT ShapeUpgrade_ConvertSurfaceToBezierBasis();

//! Splits a list of beziers computed by Compute method according <br>
//!          the split values and splitting parameters. <br>
Standard_EXPORT virtual  void Build(const Standard_Boolean Segment) ;

//! Converts surface into a grid of bezier based surfaces, and <br>
//!          stores this grid. <br>
Standard_EXPORT virtual  void Compute(const Standard_Boolean Segment) ;

//! Returns the grid of bezier based surfaces correspondent to <br>
//!          original surface. <br>
Standard_EXPORT   Handle_ShapeExtend_CompositeSurface Segments() const;
//! Sets mode for conversion Geom_Plane to Bezier <br>
  void SetPlaneMode(const Standard_Boolean mode) ;
//! Returns the Geom_Pline conversion mode. <br>
  Standard_Boolean GetPlaneMode() const;
//! Sets mode for conversion Geom_SurfaceOfRevolution to Bezier <br>
  void SetRevolutionMode(const Standard_Boolean mode) ;
//! Returns the Geom_SurfaceOfRevolution conversion mode. <br>
  Standard_Boolean GetRevolutionMode() const;
//! Sets mode for conversion Geom_SurfaceOfLinearExtrusion to Bezier <br>
  void SetExtrusionMode(const Standard_Boolean mode) ;
//! Returns the Geom_SurfaceOfLinearExtrusion conversion mode. <br>
  Standard_Boolean GetExtrusionMode() const;
//! Sets mode for conversion Geom_BSplineSurface to Bezier <br>
  void SetBSplineMode(const Standard_Boolean mode) ;
//! Returns the Geom_BSplineSurface conversion mode. <br>
  Standard_Boolean GetBSplineMode() const;
//Standard_EXPORT ~ShapeUpgrade_ConvertSurfaceToBezierBasis();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_ShapeExtend_CompositeSurface mySegments;
Standard_Boolean myPlaneMode;
Standard_Boolean myRevolutionMode;
Standard_Boolean myExtrusionMode;
Standard_Boolean myBSplineMode;


};


#include <ShapeUpgrade_ConvertSurfaceToBezierBasis.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
