// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSelect_SetGlobalParameter_HeaderFile
#define _IGESSelect_SetGlobalParameter_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSelect_SetGlobalParameter_HeaderFile
#include <Handle_IGESSelect_SetGlobalParameter.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _IGESSelect_ModelModifier_HeaderFile
#include <IGESSelect_ModelModifier.hxx>
#endif
#ifndef _Handle_IGESData_IGESModel_HeaderFile
#include <Handle_IGESData_IGESModel.hxx>
#endif
class TCollection_HAsciiString;
class IFSelect_ContextModif;
class IGESData_IGESModel;
class Interface_CopyTool;
class TCollection_AsciiString;


//! Sets a Global (Header) Parameter to a new value, directly given <br>
//!           Controls the form of the parameter (Integer, Real, String <br>
//!           with such or such form), but not the consistence of the new <br>
//!           value regarding the rest of the file. <br>
//! <br>
//!           The new value is given under the form of a HAsciiString, even <br>
//!           for Integer or Real values. For String values, Hollerith forms <br>
//!           are accepted but not mandatory <br>
//!  Warning : a Null (not set) value is not accepted. For an empty string, <br>
//!           give a Text Parameter which is empty <br>
class IGESSelect_SetGlobalParameter : public IGESSelect_ModelModifier {

public:
 // Methods PUBLIC
 // 

//! Creates an SetGlobalParameter, to be applied on Global <br>
//!           Parameter <numpar> <br>
Standard_EXPORT IGESSelect_SetGlobalParameter(const Standard_Integer numpar);

//! Returns the global parameter number to which this modifiers <br>
//!           applies <br>
Standard_EXPORT   Standard_Integer GlobalNumber() const;

//! Sets a Text Parameter for the new value <br>
Standard_EXPORT   void SetValue(const Handle(TCollection_HAsciiString)& text) ;

//! Returns the value to set to the global parameter (Text Param) <br>
Standard_EXPORT   Handle_TCollection_HAsciiString Value() const;

//! Specific action : only <target> is used : the form of the new <br>
//!           value is checked regarding the parameter number (given at <br>
//!           creation time). <br>
Standard_EXPORT   void Performing(IFSelect_ContextModif& ctx,const Handle(IGESData_IGESModel)& target,Interface_CopyTool& TC) const;

//! Returns a text which is <br>
//!           "Sets Global Parameter <numpar> to <new value>" <br>
Standard_EXPORT   TCollection_AsciiString Label() const;
//Standard_EXPORT ~IGESSelect_SetGlobalParameter();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer thenum;
Handle_TCollection_HAsciiString theval;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
