// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_SelectRoots_HeaderFile
#define _IFSelect_SelectRoots_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_SelectRoots_HeaderFile
#include <Handle_IFSelect_SelectRoots.hxx>
#endif

#ifndef _IFSelect_SelectExtract_HeaderFile
#include <IFSelect_SelectExtract.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
class Interface_EntityIterator;
class Interface_Graph;
class Standard_Transient;
class Interface_InterfaceModel;
class TCollection_AsciiString;


//! A SelectRoots sorts the Entities which are local roots of a <br>
//!           set of Entities (not shared by other Entities inside this set, <br>
//!           even if they are shared by other Entities outside it) <br>
class IFSelect_SelectRoots : public IFSelect_SelectExtract {

public:
 // Methods PUBLIC
 // 

//! Creates a SelectRoots <br>
Standard_EXPORT IFSelect_SelectRoots();

//! Returns the list of local roots. It is redefined for a purpose <br>
//!           of effeciency : calling a Sort routine for each Entity would <br>
//!           cost more ressource than to work in once using a Map <br>
//!           RootResult takes in account the Direct status <br>
Standard_EXPORT virtual  Interface_EntityIterator RootResult(const Interface_Graph& G) const;

//! Returns always True, because RootResult has done work <br>
Standard_EXPORT   Standard_Boolean Sort(const Standard_Integer rank,const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) const;

//! Returns a text defining the criterium : "Local Root Entities" <br>
Standard_EXPORT   TCollection_AsciiString ExtractLabel() const;
//Standard_EXPORT ~IFSelect_SelectRoots();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Returns True, because RootResult assures uniqueness <br>
Standard_EXPORT virtual  Standard_Boolean HasUniqueResult() const;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
