// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAlgo_HeaderFile
#define _BRepAlgo_HeaderFile

#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Wire;
class TopoDS_Shape;
class TopTools_ListOfShape;
class BRepAlgo_BooleanOperation;
class BRepAlgo_Fuse;
class BRepAlgo_Cut;
class BRepAlgo_Common;
class BRepAlgo_Section;
class BRepAlgo_Loop;
class BRepAlgo_Tool;
class BRepAlgo_Image;
class BRepAlgo_AsDes;
class BRepAlgo_FaceRestrictor;
class BRepAlgo_BooleanOperations;
class BRepAlgo_DSAccess;
class BRepAlgo_TopOpe;
class BRepAlgo_EdgeConnector;
class BRepAlgo_NormalProjection;
class BRepAlgo_DataMapOfShapeBoolean;
class BRepAlgo_DataMapOfShapeListOfInteger;
class BRepAlgo_DataMapOfShapeInterference;
class BRepAlgo_SequenceOfSequenceOfInteger;
class BRepAlgo_DataMapNodeOfDataMapOfShapeBoolean;
class BRepAlgo_DataMapIteratorOfDataMapOfShapeBoolean;
class BRepAlgo_DataMapNodeOfDataMapOfShapeListOfInteger;
class BRepAlgo_DataMapIteratorOfDataMapOfShapeListOfInteger;
class BRepAlgo_DataMapNodeOfDataMapOfShapeInterference;
class BRepAlgo_DataMapIteratorOfDataMapOfShapeInterference;
class BRepAlgo_SequenceNodeOfSequenceOfSequenceOfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! The BRepAlgo package provides a full range of <br>
//! services to perform Old Boolean Operations in Open CASCADE. <br>
//!   Attention: <br>
//! The New Boolean Operation has replaced the Old <br>
//! Boolean Operations algorithm in the BrepAlgoAPI <br>
//! package in Open CASCADE. <br>
class BRepAlgo  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT static  TopoDS_Wire ConcatenateWire(const TopoDS_Wire& Wire,const GeomAbs_Shape Option,const Standard_Real AngularTolerance = 1.0e-4) ;

//! Checks if the  shape is "correct". If not, returns <br>
//!          <Standard_False>, else returns <Standard_True>. <br>
Standard_EXPORT static  Standard_Boolean IsValid(const TopoDS_Shape& S) ;

//! Checks if  the  Generated and Modified Faces  from <br>
//!          the shapes <arguments> in  the shape <result>  are <br>
//!          "correct". The args   may be empty, then all faces <br>
//!          will be checked. <br>
//!          If <Closed> is True,  only  closed shape are valid. <br>
//!           If <GeomCtrl>  is    False the geometry  of   new <br>
//!            vertices and edges   are   not verified and  the <br>
//!          auto-intersection of new wires are not searched. <br>
Standard_EXPORT static  Standard_Boolean IsValid(const TopTools_ListOfShape& theArgs,const TopoDS_Shape& theResult,const Standard_Boolean closedSolid = Standard_False,const Standard_Boolean GeomCtrl = Standard_True) ;

//! Checks if the shape is  "correct". If not, returns <br>
//!          <Standard_False>,  else   returns <Standard_True>. <br>
//!          This method differs from  the previous one in  the <br>
//!          fact that no   geometric contols (intersection  of <br>
//!          wires, pcurve validity) are performed. <br>
Standard_EXPORT static  Standard_Boolean IsTopologicallyValid(const TopoDS_Shape& S) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class BRepAlgo_BooleanOperation;
friend class BRepAlgo_Fuse;
friend class BRepAlgo_Cut;
friend class BRepAlgo_Common;
friend class BRepAlgo_Section;
friend class BRepAlgo_Loop;
friend class BRepAlgo_Tool;
friend class BRepAlgo_Image;
friend class BRepAlgo_AsDes;
friend class BRepAlgo_FaceRestrictor;
friend class BRepAlgo_BooleanOperations;
friend class BRepAlgo_DSAccess;
friend class BRepAlgo_TopOpe;
friend class BRepAlgo_EdgeConnector;
friend class BRepAlgo_NormalProjection;
friend class BRepAlgo_DataMapOfShapeBoolean;
friend class BRepAlgo_DataMapOfShapeListOfInteger;
friend class BRepAlgo_DataMapOfShapeInterference;
friend class BRepAlgo_SequenceOfSequenceOfInteger;
friend class BRepAlgo_DataMapNodeOfDataMapOfShapeBoolean;
friend class BRepAlgo_DataMapIteratorOfDataMapOfShapeBoolean;
friend class BRepAlgo_DataMapNodeOfDataMapOfShapeListOfInteger;
friend class BRepAlgo_DataMapIteratorOfDataMapOfShapeListOfInteger;
friend class BRepAlgo_DataMapNodeOfDataMapOfShapeInterference;
friend class BRepAlgo_DataMapIteratorOfDataMapOfShapeInterference;
friend class BRepAlgo_SequenceNodeOfSequenceOfSequenceOfInteger;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
