// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_FaceBuilder_HeaderFile
#define _BOP_FaceBuilder_HeaderFile

#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _BOP_LoopSet_HeaderFile
#include <BOP_LoopSet.hxx>
#endif
#ifndef _BOP_BlockIterator_HeaderFile
#include <BOP_BlockIterator.hxx>
#endif
#ifndef _BOP_BlockBuilder_HeaderFile
#include <BOP_BlockBuilder.hxx>
#endif
#ifndef _BOP_FaceAreaBuilder_HeaderFile
#include <BOP_FaceAreaBuilder.hxx>
#endif
#ifndef _BOP_PWireEdgeSet_HeaderFile
#include <BOP_PWireEdgeSet.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
class BOP_WireEdgeSet;
class TopTools_ListOfShape;
class TopoDS_Shape;
class TopoDS_Wire;
class TopoDS_Edge;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!   The  algorithm to   construct Faces from a WireEdgeSet <br>
//! <br>
class BOP_FaceBuilder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_FaceBuilder();


//! Launches the algorithm consisting of four steps <br>
//! 1.  Split the WES on wires <br>
//! 2.  Make Loops from wires <br>
//! 3.  Make Areas from Loops <br>
//! 4.  Make Faces from Areas <br>
Standard_EXPORT   void Do(const BOP_WireEdgeSet& aWES,const Standard_Boolean aForceClass = Standard_True) ;


//! Selector <br>
Standard_EXPORT  const BOP_WireEdgeSet& WES() const;


//! Selector <br>
Standard_EXPORT  const TopTools_ListOfShape& NewFaces() const;


//! Modifier <br>
//! 0 -Treat internal edges, <br>
//! 1 -Do not treat internal edges <br>
Standard_EXPORT   void SetTreatment(const Standard_Integer aTreatment) ;


//! Modifier <br>
Standard_EXPORT   void SetManifoldFlag(const Standard_Boolean aMFlag) ;


//! Modifier <br>
//! 1 -Treat scale configured same domain faces, <br>
//! 0 -Do not treat them. <br>
Standard_EXPORT   void SetTreatSDScales(const Standard_Integer aTreatment) ;


//! Selector <br>
Standard_EXPORT   Standard_Boolean ManifoldFlag() const;


//! Selector <br>
Standard_EXPORT   Standard_Integer Treatment() const;


//! Selector <br>
Standard_EXPORT   Standard_Integer TreatSDScales() const;


Standard_EXPORT   Standard_Integer InitFace() ;


Standard_EXPORT   Standard_Boolean MoreFace() const;


//! <br>
//! <br>
//! Wires' iterator <br>
//! <br>
Standard_EXPORT   void NextFace() ;


Standard_EXPORT   Standard_Integer InitWire() ;


Standard_EXPORT   Standard_Boolean MoreWire() const;


Standard_EXPORT   void NextWire() ;


Standard_EXPORT   Standard_Boolean IsOldWire() const;


Standard_EXPORT  const TopoDS_Shape& OldWire() const;


//! <br>
Standard_EXPORT  const TopoDS_Wire& Wire() const;


Standard_EXPORT   void FindNextValidElement() ;


Standard_EXPORT   Standard_Integer InitEdge() ;


Standard_EXPORT   Standard_Boolean MoreEdge() const;


Standard_EXPORT   void NextEdge() ;


Standard_EXPORT  const TopoDS_Edge& Edge() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


//! Processes internal edges if they exists <br>
Standard_EXPORT   void DoInternalEdges() ;


//! Make Faces from Areas <br>
Standard_EXPORT   void BuildNewFaces() ;


//! Make Loops from wires <br>
Standard_EXPORT   void MakeLoops(BOP_WireEdgeSet& SS) ;


//! Treatment SD faces with a "scale" <br>
Standard_EXPORT   void SDScales() ;


 // Fields PRIVATE
 //
TopoDS_Face myFace;
BOP_LoopSet myLoopSet;
BOP_BlockIterator myBlockIterator;
BOP_BlockBuilder myBlockBuilder;
BOP_FaceAreaBuilder myFaceAreaBuilder;
BOP_PWireEdgeSet myWES;
TopTools_ListOfShape myNewFaces;
Standard_Integer myTreatment;
Standard_Boolean myManifoldFlag;
Standard_Integer myTreatSDScales;
TColStd_SequenceOfInteger myNegatives;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
