///////////////////////////////////////////////////////////////////////////////
// $Id: ContainerWidget.hxx,v 1.1 1995/01/08 06:50:37 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// ContainerWidget.hxx - Abstract base class for all container widgets
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: ContainerWidget.hxx,v $
// Revision 1.1  1995/01/08  06:50:37  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef CONTAINERWIDGET_HXX
#define CONTAINERWIDGET_HXX

#include "LinkedList.hxx"
#include "BasicWidget.hxx"


class ContainerWidget : public BasicWidget {
  private:
    // Linked list of my children
    LinkedList<BasicWidget> myChildren;

    friend BasicWidget::BasicWidget(ContainerWidget *const parent,
        const char *const name, int x, int y, int width, int height);
    friend BasicWidget::~BasicWidget();

    // Add the given child as my one of my children
    void addChild(BasicWidget* child);

    // Remove the given child as my one of my children
    void removeChild(BasicWidget* child);

  protected:
    // Protected constructor to prevent instantiation
    ContainerWidget(ContainerWidget *const parent, const char *const name,
        int x, int y, int width, int height);

    // Find the widget for the given window
    virtual BasicWidget* findWidget(Window window);

  public:
    // Destructor
    virtual ~ContainerWidget();

    // Manage the entire widget subtree that I represented
    virtual void manage();

    // Unmanage the entire widget subtree that I represented
    virtual void unmanage();

    // Answer my class
    virtual const char *const className() const { return("ContainerWidget"); }
};
#endif

