///////////////////////////////////////////////////////////////////////////////
// $Id: ContainerWidget.cxx,v 1.1 1995/01/08 06:50:28 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// ContainerWidget.cxx - Abstract base class for all container widgets
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: ContainerWidget.cxx,v $
// Revision 1.1  1995/01/08  06:50:28  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <assert.h>
#include "ContainerWidget.hxx"

///////////////////////////////////////////////////////////////////////////////
// Protected constructor to prevent instantiation
///////////////////////////////////////////////////////////////////////////////
ContainerWidget::ContainerWidget(ContainerWidget *const parent, 
    const char *const name, int x, int y, int width, int height)
    : BasicWidget(parent, name, x, y, width, height)
{
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
ContainerWidget::~ContainerWidget()
{
  // My children will be destroyed when the LinkedList is destructed
}

///////////////////////////////////////////////////////////////////////////////
// Manage the entire widget subtree that I represented
///////////////////////////////////////////////////////////////////////////////
void ContainerWidget::manage()
{
  BasicWidget::manage();

  // Now, tell each of my children to manage themselves
  for(BasicWidget* p = myChildren.first(); p != (BasicWidget*)0;
      p = myChildren.next())
  {
    p->manage();
  }
}

///////////////////////////////////////////////////////////////////////////////
// Unmanage the entire widget subtree that I represented
///////////////////////////////////////////////////////////////////////////////
void ContainerWidget::unmanage()
{
  // Tell each of my children to unmanage themselves
  for(BasicWidget* p = myChildren.first(); p != (BasicWidget*)0;
      p = myChildren.next())
  {
    p->unmanage();
  }

  BasicWidget::unmanage();
}

///////////////////////////////////////////////////////////////////////////////
// Add the given BasicWidget as one of my children
///////////////////////////////////////////////////////////////////////////////
void ContainerWidget::addChild(BasicWidget* child)
{
  myChildren.append(child);
}

///////////////////////////////////////////////////////////////////////////////
// Remove the given BasicWidget as one of my children
///////////////////////////////////////////////////////////////////////////////
void ContainerWidget::removeChild(BasicWidget* child)
{
  myChildren.remove(child);
}

///////////////////////////////////////////////////////////////////////////////
// Find the widget for the given window
///////////////////////////////////////////////////////////////////////////////
BasicWidget* ContainerWidget::findWidget(Window window)
{
  // See if I'm the window
  if (myWindow == window)
    return(this);

  // Check each of my children
  for(BasicWidget* p = myChildren.first(); p != (BasicWidget*)0;
      p = myChildren.next())
  {
    BasicWidget* result = p->findWidget(window);

    if(result != (BasicWidget*)0)
      return(result);
  }

  return((BasicWidget*)0);
}

