#!/usr/bin/perl
#
# vieweditjobs.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# 
# $Id: vieweditjobs.cgi,v 1.18 2001/08/29 22:22:45 adam Exp $

require 'etc/timesheet.conf';
require 'lib/job-funcs.pl';
require 'lib/common-funcs.pl';
use CGI qw(:standard);
use ADB;

my $dead = '';
my $function;
my $dummy;

my $javave =<<EOT;

function jump_cut () {

   myrec = eval(parent.right.document.loghours.record_number.value);
   totrec = eval(parent.right.document.loghours.totalrecords.value);
   if (isNaN(myrec)) {
      alert("The record number must be a number!");
   }

   if ( (myrec > totrec) || (myrec <= 0)) {
       alert("Hmmm. Can't find record number " +  myrec + " because there are only " + totrec + " records!" );
       parent.right.document.loghours.record_number.value = eval(parent.right.document.loghours.recordnumber.value);
   }
   else {
      document.loghours.submit();
   }
}

EOT

#&time_head($Conf::VIEWEDIT_HOURS);
   print header,
   start_html('-title'      =>$Conf::VIEWEDIT_HOURS,
	      '-BACKGROUND' => $Conf::BACKGROUND,
	      -'script'=>$javascript,
		  '-BGCOLOR'    => $Conf::BGCOLOR,
	     );

unless(param('output') eq "short") {
	&help_button_big('VIEWEDIT_JOBS');
}

if (param('recordnumber') != param('record_number')){
    my %state;
    my $dbconn;
    my $oops;
    my %jobs;
    my %job_info;
    my $var;
    &print_form_head;

    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if (! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    my @supers = &list_supervisors($dbconn);
    my @notifiers = &list_notifiers($dbconn);
    $state{'supers'} = \@supers;
    $state{'notifiers'} = \@notifiers;

    $state{'record_number'} = param('record_number');
    # Let's get our recordkeeping straight
    $state{'nextrecord'} = $state{'record_number'} + 1;
    $state{'prevrecord'} = ($state{'record_number'} - 1);
    $state{'recordnumber'} = $state{'record_number'};
    if ($state{'nextrecord'} > $state{'totalrecords'}){
	$state{'nextrecord'} = 0;
    }


    %jobs = &get_job_search_result($dbconn, $state{'searchtable'});
    $state{'job_id'} = $jobs{$state{'recordnumber'}};
    %job_info = &job_join($dbconn, $state{'job_id'});
    

    &add_job_to_state(\%state, \%job_info, $dbconn);
    
    &reset_all_params;

    &admin_show_job_form(%state);


    &write_state(%state);
    &print_job_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";
    

    
}
elsif (param('apply.x')) {
    my %state;
    my $dbconn;
    my $oops;
    my %job;
    my %job_info;
    my $var;
    my $reply;
    my $sql;
    my $current_job_id;
    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if (! $dbconn->is_ok) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    unless ( &is_superuser($state{'remote_user'}, $dbconn) ) {
	&user_error("Insufficient permissions");
    }
    my $current_job = $state{'recordnumber'};
    my @supers = &list_supervisors($dbconn);
    my @notifiers = &list_notifiers($dbconn);
    $state{'supers'} = \@supers;
    $state{'notifiers'} = \@notifiers;
    # Let's get our recordkeeping straight
    # If we came her via approve, we dont change anything
    # Otherwise we properly change recordnumber, nextrec etc...

    %job = &get_job_search_result($dbconn, $state{'searchtable'});
    if (param('target_job_id')) {
        $current_job_id = param('target_job_id');
    } else {
        $current_job_id = $job{$current_job};
    }
    %job_info = &job_join($dbconn, $current_job_id);


    ### We need to do some bookkeeping to provide our extre special 
    ### features

    ## if this job is being open or closed then set open/close date properly
    ##
    my $tempopen;
    $tempopen = 0 if param('open') eq 'n';
    $tempopen = 1 if param('open') eq 'y';

    $job_info{'open_date'} = &dbdate(param('open_date')) if param('open_date');
    $job_info{'close_date'} = &dbdate(param('close_date')) if param('close_date');
    $job_info{'current_estimate_date'} = &dbdate(param('current_estimate_date')) if param('current_estimate_date');

    if ($job_info{'open'} != $tempopen) { # we changes open/close
	if (! $tempopen) {
            # we closed the job
	    $job_info{'close_date'} = &dbdate_today;
	} else {
            # we opened the job
	    $job_info{'open_date'} = &dbdate_today;
	}
    }

    if ($tempopen == 1) {
        # job is open, shouldn't have a close date
        $job_info{'close_date'} = '';
    }

    $job_info{'job_description'} = param('job_description') if param('job_description');
    $job_info{'current_hours_estimate'} = param('current_hours_estimate') if param('current_hours_estimate');

    $job_info{'estimated_hours'} = param('estimated_hours') if param('estimated_hours');

    $job_info{'bill_rate'} = param('bill_rate') if param('bill_rate');
    $job_info{'flag_hrs'} = param('flag_hrs') if param('flag_hrs');
    $job_info{'category'} = param('category') if param('category');
    $job_info{'fksupervisor_id'} = param('fksupervisor_id') if param('fksupervisor_id');
    $job_info{'fknotify_id'} = &comma_pack_vals(param('fknotify_id')) if param('fknotify_id');

    $job_info{'open'} = 0 if param('open') eq 'n';
    $job_info{'open'} = 1 if param('open') eq 'y';

    $job_info{'default_approved'} = 0 if param('default_approved') eq 'n';
    $job_info{'default_approved'} = 1 if param('default_approved') eq 'y';
    #$job_info{'job_id'} = param('job_id') if param('job_id');

    &scrub_hash(\%job_info);

    # make our SQL
    $sql = "UPDATE job SET ";
    if ($job_info{'open_date'}) {
	$sql .= "open_date = '$job_info{'open_date'}', ";
    }
    if ($job_info{'close_date'}) {
	$sql .= "close_date = '$job_info{'close_date'}', ";
    } else {
        $sql .=  "close_date = NULL, ";
    }
    if ($job_info{'current_estimate_date'}) {
	$sql .= "current_estimate_date = '$job_info{'current_estimate_date'}', ";
    } else {
        $sql .=  "current_estimate_date = NULL, ";
    }
    $sql .= "current_hours_estimate = '$job_info{'current_hours_estimate'}', ";
    $sql .= "job_description = '$job_info{'job_description'}', ";
    $sql .= "estimated_hours = '$job_info{'estimated_hours'}', ";
    $sql .= "bill_rate = '$job_info{'bill_rate'}', ";
    $sql .= "fksupervisor_id = '$job_info{'fksupervisor_id'}', ";
    $sql .= "fknotify_id = '$job_info{'fknotify_id'}', ";
    $sql .= "open = $job_info{'open'}, ";
    $sql .= "flag_hrs = $job_info{'flag_hrs'}, ";
    $sql .= "category = '$job_info{'category'}', ";
    $sql .= "default_approved = $job_info{'default_approved'} ";
    $sql .= "WHERE job_id = $current_job_id;";

	
	
    $reply = $dbconn->query($sql);
    if (! $reply){
	$oops = $dbconn->errorstring;
	&error("Update error for $current_job_id: $oops", $sql);
    }
  
    if (param('output') eq "short"){
	print "<CENTER><B>PABLO ROCKS</B><BR><br>Your job $current_job_id has been
		edited.</CENTER>";
	return;
    }

    if (param('target_job_id')) {
	$state{'job_id'} = param('target_job_id');
    } else {
    	$state{'job_id'} = $job{$state{'recordnumber'}};
    }
    %job_info = &job_join($dbconn, $state{'job_id'});

    &add_job_to_state(\%state, \%job_info, $dbconn);

    &reset_all_params;

    &admin_show_job_form(%state);

    &write_state(%state);
    &print_job_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

} elsif (param('delete.x')) {
    my %state;
    my $dbconn;
    my $oops;
    my %job;
    my %job_info;
    my $var;

    my $current_job_id;
    &print_form_head;

    # Let's get our recordkeeping straight
    # If we came her via approve, we dont change anything
    # Otherwise we properly change recordnumber, nextrec etc...
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if (! $dbconn->is_ok) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    my $current_job = $state{'recordnumber'};
    my @supers = &list_supervisors($dbconn);
    my @notifiers = &list_notifiers($dbconn);
    $state{'supers'} = \@supers;
    $state{'notifiers'} = \@notifiers;
    %job = &get_job_search_result($dbconn, $state{'searchtable'});
    
    $current_job_id = $job{$current_job};

    my $reply = $dbconn->query("DELETE from $state{'searchtable'} where job_id = $current_job_id;");
    if (! $reply) {
	$oops = $dbconn->errorstring;
	&error("Delete error for $current_job_id: $oops");
    }
    $reply = $dbconn->query("DELETE from $Conf::JOB_DB where job_id = $current_job_id;");
    if (! $reply) {
	$oops = $dbconn->errorstring;
	&error("Update error for $current_job_id: $oops");
    }

    ####### MARK ALL HOURS UNDER THIS JOB AS DELETED ########
    ####### THIS IS TEMP SOLUTION 

    $reply = $dbconn->query("UPDATE $Conf::HOURS_DB set del = 'y' WHERE fkjob_id = $current_job_id;");
    if(!$reply){
	$oops = $dbconn->errorstring;
	&error("Error updated hours entries pointing to jobid $current_job_id: $oops");
    }
    
    $state{'totalrecords'}--;
    if ($state{'totalrecords'} == 0){
	&admin_search_job_form(%state);
	&searchbutton;
	&write_state(%state);
	print "</FORM>";
	exit;
    }
    if ($state{'totalrecords'} < $state{'recordnumber'}) {
	$state{'recordnumber'} = $state{'totalrecords'};
	$state{'nextrecord'} = 0;
	$state{'prevrecord'} = ($state{'totalrecords'} - 1);
    }

    %job = &get_job_search_result($dbconn, $state{'searchtable'});
    $state{'job_id'} = $job{$state{'recordnumber'}};
    if (! $state{'job_id'}) {
	&error("Next record not found, please use your back button");
    }
    %job_info = &job_join($dbconn, $state{'job_id'});

    &add_job_to_state(\%state, \%job_info, $dbconn);

    &reset_all_params;

    &admin_show_job_form(%state);

    &write_state(%state);
    &print_job_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

    exit;
} elsif (param('prevrecord.x')) {
    my %state;
    my $dbconn;
    my $oops;
    my %job;
    my %job_info;
    my $var;
    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if (! $dbconn->is_ok) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    my @supers = &list_supervisors($dbconn);
    my @notifiers = &list_notifiers($dbconn);
    $state{'supers'} = \@supers;
    $state{'notifiers'} = \@notifiers;
    # Let's get our recordkeeping straight
    $state{'nextrecord'} = $state{'recordnumber'};
    $state{'recordnumber'} = $state{'prevrecord'};    
    $state{'prevrecord'} = ($state{'recordnumber'} - 1);


    %job = &get_job_search_result($dbconn, $state{'searchtable'});
    $state{'job_id'} = $job{$state{'recordnumber'}};
    %job_info = &job_join($dbconn, $state{'job_id'});

    &add_job_to_state(\%state, \%job_info, $dbconn);
    &reset_all_params;
    
    &admin_show_job_form(%state);


    &write_state(%state);
    &print_job_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

} elsif (param('nextrecord.x') || param('approve.x')) {
    my %state;
    my $dbconn;
    my $oops;
    my %job;
    my %job_info;
    my $var;


    # OK, if we are doing an "Approve, we basically perform a
    # next record with one itnermediate step  So we just set a var
    # here to use in some conditionals later on

    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if(!$dbconn->is_ok){
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    # Let's get our recordkeeping straight
    # If we came her via approve, we dont change anything
    # Otherwise we properly change recordnumber, nextrec etc...
    my @supers = &list_supervisors($dbconn);
    my @notifiers = &list_notifiers($dbconn);
    $state{'supers'} = \@supers;
    $state{'notifiers'} = \@notifiers;
    
    $state{'prevrecord'} = $state{'recordnumber'};
    $state{'recordnumber'} = $state{'nextrecord'};    
    $state{'nextrecord'} = ($state{'recordnumber'} + 1);
    if ($state{'nextrecord'} > $state{'totalrecords'}) {
	$state{'nextrecord'} = 0;
    }


    %job = &get_job_search_result($dbconn, $state{'searchtable'});

    $state{'job_id'} = $job{$state{'recordnumber'}};


    %job_info = &job_join($dbconn, $state{'job_id'});

    &add_job_to_state(\%state, \%job_info, $dbconn);

    &admin_show_job_form(%state);

    &write_state(%state);
    &print_job_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";


} elsif (param('searchsubmit.x')) {
    my %state;
    my $searchtable;
    my $dbconn;
    my $result;
    my $oops;
    my %job;
    my $var;

    &print_form_head;
    

    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if (! $dbconn->is_ok) {
	$oops = $dbconn->errorstring;
	&error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);

    my @supers = &list_supervisors($dbconn);
    my @notifiers = &list_notifiers($dbconn);
    $state{'supers'} = \@supers;
    $state{'notifiers'} = \@notifiers;
    # Drop any old searches from temp storage in the DB
    $result = $dbconn->query("DROP TABLE temp_job_search_$state{'remote_user'};");
    
    # Get all the state variables in shape for the search
    $state{'fkclient_id'} = param('fkclient_id') unless(param('fkclient_id') eq "any");
    $state{'fksupervisor_id'} = param('fksupervisor_id') unless(param('fksupervisor_id') eq "any");
    $state{'open'} = param('open') unless (param('open') eq "any"); 
    $state{'category'} = param('category') unless (param('category') eq "any"); 
    $state{'default_approved'} = param('default_approved') unless (param('default_approved') eq "any"); 
    $state{'job_id'} = param('job_id') if param('job_id');
    $state{'bill_rate'} = param('bill_rate') if param('bill_rate');
    $state{'job_description'} = param('job_description') if param('job_description');
    

    &scrub_hash(\%state);
    # Run the search and get our temp storage table in return
    $state{'searchtable'} = &search_job(%state);
    
    # Fill up a hash with our results
    %job = &get_job_search_result($dbconn, $state{'searchtable'});
    
    if (! $job{'1'}) {
	print "<H1>No Matches Found</H1>";
	param('output', 'long');
	&print_form_head;
	&admin_search_job_form(%state);

	&searchbutton;
	print "</FORM>";
	exit;
    } else {
	$state{'job_id'} = $job{'1'};
    }
    
    #if we want the short listing do this
    if (param('output') eq "short") {
	my $key;
	my %short_job;
	my $sq = "Select * from $state{'searchtable'}, job, client WHERE ";
	$sq .= "$state{'searchtable'}.job_id = job.job_id AND job.fkclient_id ";
	$sq .= "= client.client_id;";
	my $job_munge = $dbconn->query("$sq");
	if (!$job_munge){
	    my $oops = $dbconn->errorstring;
	    &error("Error getting job munge: $oops", $sq);
	}
	print "<H3 align=center>Short Listing</H3><br>";
	print "<FORM ACTION=\"updatejobs.cgi\" METHOD=\"GET\">";
	print hidden('-name'=>'search_url',
		     '-value'=>self_url,
		     '-override'=>1);
	print "<TABLE BORDER=1>";
	print "<TR><TH>Job ID</TH><TH>Client</TH><TH>Description</TH><TH>Status</TH></TR>\n";
	my $numlines = $job_munge->get_num_rows;
	my $i;
	my %jhash;
	$i = 0;
	while ($i < $numlines){
	    %jhash = $job_munge->get_row($i);
	    my $job_url =
		"$Conf::TIMESHEET_URL/vieweditjobs.cgi?searchsubmit.x=1&job_id=$jhash{'job_id'}";
	    
	    
	    my $jstatus;
	    if ($jhash{'open'}) {
		$jstatus = 'open';
	    } else {
		$jstatus = 'closed';
	    }

	    my $yes_no_labels = ('open', ' Open', 'closed', ' Closed');
	    my $open_close_popup =
		popup_menu('-name'    => job . $jhash{'job_id'} . set,
			   '-values'  => ['open','closed'],
			   '-default' => "$jstatus",
			   '-override'=>1,
			   '-labels'  => \%yes_no_labels);
	    my $hidden_stat = hidden(
		'-name'=>job . $jhash{'job_id'} . status,
				     '-value'=>$jstatus);
	    # The URL linking to a close job action
	    my $close_me_url = 
		"$Conf::TIMESHEET_URL/vieweditjobs.cgi?apply.x=1fkclient_id=$jash{'fkclient_id'}&target_job_id=$jhash{'job_id'}&open=n&short_output=0";
	
	
		# And vice versa
		my $open_me_url = 
		"$Conf::TIMESHEET_URL/vieweditjobs.cgi?apply.x=1fkclient_id=$jhash{'fkclient_id'}&target_job_id=$jhash{'job_id'}&open=y&short_output=0";

	    print "<TR>";
		print "<TABLE BORDER=2>";
		print "<TR>";
		print "<TD><A HREF=\"$job_url\">$jhash{'job_id'}</A></TD>\n";
		print "<TD>$jhash{'client_name'}</TD><TD>$jhash{'job_description'}</TD><TD>";
	    if ($jhash{'open'}) {
		print "Open";
	    } else {
		print "Closed";
	    }
	    print "</TD>";
	    print "</TR>\n";
	    # Now the controls
	    print "<TR BGCOLOR=\"#EEEEEE\">";
	    print "<TD COLSPAN = 3>$open_close_popup";
	    print "$hidden_stat</TD>";
	    print "</TR>";
	    print "</TABLE>";
	    print "</TR>";
	    $i++;
	}
	
	
	print "</TABLE>";
	&write_state(%state);
	print '<INPUT TYPE="submit" NAME="Update Jobs" VALUE="Update Jobs">';

    
    }
    # OTHERWISE WE DO LONG OUTPUT
    else {
      # Some wooparse SQL to get all teh info for our first record
      my %job_info = &job_join($dbconn, $state{'job_id'});
      
      # Add these to our state hash
      &add_job_to_state(\%state, \%job_info, $dbconn);
      
      $state{'recordnumber'} = 1;
      my @recs = keys %job;
      $state{'totalrecords'} = $#recs + 1;
      if ($state{'totalrecords'} == $state{'recordnumber'}) {
	$state{'nextrecord'} = 0;
      }
      else {
	$state{'nextrecord'} = ($state{'recordnumber'} +1);
      }
      
      &admin_show_job_form(%state);
      
      &write_state(%state);
      
      &print_job_commands(%state);
      &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
			'recordnumber'=>"$state{'recordnumber'}",
			'nextrecord'=>"$state{'nextrecord'}");
      print "</FORM>";
    
    }#END OF LONG OUTPUT BLOCK
    
}else{				# The bottom of the basket, print new form
    my %state;
    my $oops;
    my $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if(!$dbconn->is_ok){
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    $state{'client_id'} = param('client_id');
    $state{'client_name'} = &client_id_to_name($state{'client_id'});
    $state{'remote_user'} = remote_user;
    my @supers = &list_supervisors($dbconn);
    my @notifiers = &list_notifiers($dbconn);
    $state{'supers'} = \@supers;
    $state{'notifiers'} = \@notifiers;
    &print_form_head;
    
    &reset_all_params;
    param('bill_rate','');
    param('fksupervisor_id','');
    param('job_id','');
    param('open','any');
    param('default_approved','any');
    param('current_hours_estimate', '');
    &admin_search_job_form('client_id'=>"$state{'client_id'}",
			   'client_name'=>"$state{'client_name'}",
			   'remote_user'=>"$state{'remote_user'}",
			   'supers'=>\@supers);
    
    &searchbutton;
    &write_state(%state);
    print "</FORM>";
    
}

sub print_form_head{

unless(param('output') eq "short"){
print <<EOT;
<CENTER>
<IMG SRC="images/vieweditjobs-big.gif" BORDER=0 ALT=[View/Edit Jobs]>
</CENTER>
<FORM NAME=loghours METHOD="GET" ACTION="vieweditjobs.cgi">
EOT
}

}

sub searchbutton
{
    print "<INPUT TYPE=\"image\" NAME=\"searchsubmit\" SRC=\"images/search.gif\" BORDER=\"0\">";
}


sub add_job_to_state
{
    my $st = shift;
    my $jb = shift;
    my $dbconn = shift;
    my $var;
    foreach $var (keys %$jb){
	$$st{$var} = $$jb{$var};
    }
    
    if ( $$st{'open'} == 1) {
        $$st{'open'} = "y";
    } else {
        $$st{'open'} = "n";
    }
    if ($$st{'default_approved'} == 1) {
        $$st{'default_approved'} = "y";
    } else {
        $$st{'default_approved'} = "n";
    }
    my $total = $dbconn->query("Select sum(total_hours) as total from $Conf::HOURS_DB where fkjob_id = $$st{'job_id'};");
    if ($total == 0) {
	$$st{'current_estimated_hours'} = "0";
    } else {
	$$st{'current_estimated_hours'} = $total->get_value(0, 'total');
	$total->free;
    }
    $$st{'open_date'} = &formdate($$jb{'open_date'});
    $$st{'close_date'} = &formdate($$jb{'close_date'});
    $$st{'current_estimate_date'} = &formdate($$jb{'current_estimate_date'});

}





